/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.preferencesmanager;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.x500.X500Principal;

public class KeystoreManager {
    KeyStore keyStore;
    KeyPair keyPair;
    private String alias = "STPALIAS";
    static final String KEY_ALGORITHM_RSA = "RSA";
    static final String KEYSTORE_NAME = "AndroidKeyStore";
    private static final String ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String ALGORITHM_M = "RSA/None/PKCS1Padding";
    private static final String PROVIDER = "AndroidOpenSSL";
    private static final String PROVIDER_M = "AndroidKeyStoreBCWorkaround";
    private static KeystoreManager instance;

    public KeystoreManager(Context context, String alias) {
        this.alias = alias;
        try {
            this.keyStore = KeyStore.getInstance(KEYSTORE_NAME);
            this.keyStore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            // empty catch block
        }
        try {
            if (!this.keyStore.containsAlias(this.alias)) {
                KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, KEYSTORE_NAME);
                if (Build.VERSION.SDK_INT >= 23) {
                    KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(this.alias, 3).setDigests(new String[]{"SHA-256", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
                    generator.initialize((AlgorithmParameterSpec)spec);
                } else {
                    Calendar start = Calendar.getInstance();
                    Calendar end = Calendar.getInstance();
                    end.add(1, 1);
                    KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(this.alias).setSubject(new X500Principal("CN=Sample Name, O=Android Authority")).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                    generator.initialize((AlgorithmParameterSpec)spec);
                }
                this.keyPair = generator.generateKeyPair();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String encryptText(String txt) {
        String encryptedText = "";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            if (txt.isEmpty()) {
                // empty if block
            }
            Cipher input = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(ALGORITHM_M, PROVIDER_M) : Cipher.getInstance(ALGORITHM, PROVIDER);
            input.init(1, publicKey);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            cipherOutputStream.write(txt.getBytes("UTF-8"));
            cipherOutputStream.close();
            byte[] vals = outputStream.toByteArray();
            encryptedText = Base64.encodeToString((byte[])vals, (int)0);
            return encryptedText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String decryptText(String txt) {
        String decryptedText = "";
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            try {
                int nextByte;
                Cipher output = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(ALGORITHM_M, PROVIDER_M) : Cipher.getInstance(ALGORITHM, PROVIDER);
                output.init(2, privateKey);
                CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)txt, (int)0)), output);
                ArrayList<Byte> values = new ArrayList<Byte>();
                while ((nextByte = cipherInputStream.read()) != -1) {
                    values.add((byte)nextByte);
                }
                byte[] bytes = new byte[values.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (Byte)values.get(i);
                }
                decryptedText = new String(bytes, 0, bytes.length, "UTF-8");
                return decryptedText;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException exception) {
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            // empty catch block
        }
        return "";
    }

    public byte[] encryptBytes(byte[] bytes) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            PublicKey publicKey = privateKeyEntry.getCertificate().getPublicKey();
            if (bytes.length <= 0) {
                // empty if block
            }
            Cipher input = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(ALGORITHM_M, PROVIDER_M) : Cipher.getInstance(ALGORITHM, PROVIDER);
            input.init(1, publicKey);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            cipherOutputStream.write(bytes);
            cipherOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableEntryException | NoSuchPaddingException exception) {
            return null;
        }
    }

    public byte[] decryptBytes(byte[] bytes) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            try {
                int nextByte;
                Cipher output = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(ALGORITHM_M, PROVIDER_M) : Cipher.getInstance(ALGORITHM, PROVIDER);
                output.init(2, privateKey);
                CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(bytes), output);
                ArrayList<Byte> values = new ArrayList<Byte>();
                while ((nextByte = cipherInputStream.read()) != -1) {
                    values.add((byte)nextByte);
                }
                byte[] result = new byte[values.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (Byte)values.get(i);
                }
                return result;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException exception) {
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            // empty catch block
        }
        return null;
    }

    private KeyStore getKeyStore() {
        return this.keyStore;
    }

    private KeyPair getKeyPair() {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            return new KeyPair(privateKeyEntry.getCertificate().getPublicKey(), privateKeyEntry.getPrivateKey());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            return null;
        }
    }
}

