package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.Response;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by Navas on 23/06/15
 * Return the response parsed to JsonObject
 */
public class CustomJsonObjectRequest extends CustomRequest<JSONObject>{


    public CustomJsonObjectRequest(int method, String path, String requestBody, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, path, requestBody, listener, errorListener);
    }

    public CustomJsonObjectRequest(int method, String path, String requestBody, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, path, requestBody, listener, errorListener, priority);
    }

    public CustomJsonObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, environment, path, requestBody, listener, errorListener);
    }

    public CustomJsonObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
    }

    @Override
    protected Object parseResponse(String response) throws JSONException {
        return new JSONObject(response);
    }
}
