package com.tm.datamanager.webservicesmanager.error;

import com.android.volley.NetworkResponse;
import com.android.volley.VolleyError;

/**
 * Created by Navas on 8/8/17.
 */

public class WebServicesError extends VolleyError {

    public static enum Error { NETWORK_ERROR, SERVER_ERROR, AUTH_FAILURE_ERROR, NO_CONNECTION_ERROR, TIMEOUT_ERROR, OTHER_ERROR, PARSE_ERROR}

    public Error type = Error.OTHER_ERROR;

    String message;

    NetworkResponse responseData;

    public WebServicesError(NetworkResponse response) {
        super(response);
        this.responseData = response;
    }

    public WebServicesError(String exceptionMessage) {
        super(exceptionMessage);
        message = exceptionMessage;
    }

    public WebServicesError(String exceptionMessage, Error type) {
        super(exceptionMessage);
        message = exceptionMessage;
        this.type = type;
    }



    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public NetworkResponse getResponseData() {
        return responseData;
    }

    public void setResponseData(NetworkResponse responseData) {
        this.responseData = responseData;
    }

    public int getStatusCode(){
        if(responseData != null) return responseData.statusCode;
        else return -1;
    }
}
