package com.tm.datamanager.webservicesmanager.configurations;

import com.tm.datamanager.webservicesmanager.certifieds.BaseCertified;
import com.tm.datamanager.webservicesmanager.error.WebServicesError;
import com.tm.datamanager.webservicesmanager.formatters.Formatter;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by Navas on 19/06/15
 * This class contains all configuration for the calls to the services
 */
public abstract class WebServicesConfiguration {

    // ENVIRONMENT SELECTED
    private String environment;
    private String environmentName;

    public StringBuffer bufferLog = new StringBuffer();

    public void addToBufferLog(String data, String title, String url){
        bufferLog.append(new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").format(new Date()) + "\n");
        bufferLog.append(url + "\n");
        bufferLog.append(title+"\n");
        data = Formatter.toPrettyString(data);
        bufferLog.append(data+"\n\n\n");
    }

    /**
     * Check if the server return an error
     * @param response
     * @return null if the server hasn't returned an error or a VolleyError with the information of
     * the error.
     */
    public abstract WebServicesError checkError(String response);

    /**
     * Process the response if it is necessary change strange character by other
     * @param response
     * @return
     */
    public String processResponse(String response){
        return response;
    }

    public abstract String[] getENVIRONMENTS();

    public abstract String[] getENVIRONMENTS_NAMES();

    public String getEnvironment(){
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironmentName(){
        return environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public abstract int getATTEMPTS();

    public abstract int getTIMEOUT();

    public abstract float getBACKOFFMULTIPLIER();

    /**
     * MESSAGE TO SHOW WHEN THE REQUEST THROWS AN ERROR
     * @return
     */
    public abstract String getDEFAULT_REQUEST_ERROR_MESSAGE();

    /**
     * ENABLE SHOW THE REQUESTS AND RESPONSES IN THE LOGCAT
     * @return
     */
    public abstract boolean isSHOW_REQUEST_LOGS();

    /**
     * ENABLE WRITE THE REQUESTS AND RESPONSES IN THE LOG FILE
     * @return
     */
    public abstract boolean isSHOW_REQUEST_LOGS_FILE();

    /**
     * NAME OF FILE LOG
     * @return
     */
    public abstract String getFILE_LOG();

    /**
     * ENABLE THE DUMMY RESPONSES, IF YOU SET TRUE, YOU HAVE TO ADD A RESPONSE FOR EACH REQUEST IN
     * DummyResponses FILE
     * @return
     */
    public abstract boolean isDUMMY();

    public abstract boolean setDUMMY(boolean dummy);

    /**
     * ENABLE SAVE THE COOKIES TO SAVE THE SESSION
     * @return
     */
    public abstract boolean isSAVECOOKIES();

    /**
     * Get certified to HTTPS request, only implement when if it necessary
     */
    public abstract BaseCertified getCertified();

    /**
     * Get codification of response, by default is UTF-8
     * @return null = UTF-8
     */
    public abstract String getResponseCodification();
}
