package com.tm.datamanager.webservicesmanager;

import android.animation.Animator;
import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.widget.TextView;
import android.widget.Toast;

import com.tm.datamanager.R;
/**
 * Created by Navas on 21/2/17.
 */

public class LogDialog extends Dialog {

    StringBuffer log;

    public LogDialog(Context context, StringBuffer log) {
        super(context, android.R.style.Theme_Translucent_NoTitleBar);
        this.log = log;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dialog_log);
        findViewById(R.id.btnClose).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        findViewById(R.id.btnCopy).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ClipboardManager clipboard = (ClipboardManager) getContext().getSystemService(Context.CLIPBOARD_SERVICE);
                ClipData clip = ClipData.newPlainText("Log", log.toString());
                clipboard.setPrimaryClip(clip);
                Toast.makeText(getContext(),"Added to clipboard",Toast.LENGTH_LONG).show();
                dismiss();
            }
        });
        ((TextView)findViewById(R.id.tvLog)).setText(log.toString());

    }

    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    @Override
    public void show() {
        super.show();
        final View view = findViewById(R.id.lyDialog);
        view.post(new Runnable() {
            @Override
            public void run() {
                view.setVisibility(View.VISIBLE);
                float y = view.getY();
                view.setY(((View)view.getParent()).getHeight());
                ViewPropertyAnimator animator = view.animate().setDuration(getContext().getResources().getInteger(android.R.integer.config_mediumAnimTime)).y(y);
                animator.start();
            }
        });
    }

    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    @Override
    public void dismiss() {
        View view = findViewById(R.id.lyDialog);
        float y = ((View)view.getParent()).getHeight();
        ViewPropertyAnimator animator = view.animate().setDuration(getContext().getResources().getInteger(android.R.integer.config_mediumAnimTime)).y(y);
        animator.setListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                LogDialog.super.dismiss();
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });
        animator.start();
    }
}
