/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import android.os.Environment;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkError;
import com.android.volley.NetworkResponse;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import com.tm.datamanager.webservicesmanager.error.CancelError;
import com.tm.datamanager.webservicesmanager.error.WebServicesError;
import com.tm.datamanager.webservicesmanager.formatters.Formatter;
import com.tm.datamanager.webservicesmanager.formatters.ResponseTransformer;
import com.tm.datamanager.webservicesmanager.requests.MultipartRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONException;

public class CustomRequest<T>
extends JsonRequest<T> {
    protected Map<String, String> headers;
    protected Map<String, String> params;
    protected Response.Listener listener;
    protected String path;
    protected String requestBody;
    protected Response.ErrorListener errorListener;
    protected Request.Priority priority;
    protected boolean encodeParams = true;
    protected static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    protected static final String RESPONSE = "response";
    protected boolean useDummyResponse = false;
    protected String dummyFileName;
    protected String bodyContentType;
    protected WebServicesConfiguration configuration;
    protected String url;
    protected ResponseTransformer responseTransformer;

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.path = path;
        this.url = environment + path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.url = environment + path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    protected void deliverResponse(T response) {
        if (response != null) {
            this.listener.onResponse(response);
        }
    }

    public void deliverError(VolleyError error) {
        this.errorListener.onErrorResponse(error);
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        volleyError.printStackTrace();
        String error = "";
        WebServicesError parseError = null;
        if (volleyError.networkResponse != null && volleyError.networkResponse.data != null) {
            error = new String(volleyError.networkResponse.data);
            parseError = this.configuration.checkError(error);
        } else if (volleyError.getMessage() != null) {
            error = volleyError.getMessage();
            parseError = this.configuration.checkError(error);
        }
        if (this.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)"ERROR: ");
            this.printLog(error);
            this.configuration.addToBufferLog(error, "RESPONSE ERROR", super.getUrl());
        }
        if (this.configuration.isSHOW_REQUEST_LOGS_FILE()) {
            this.writeLogInFile("ERROR:  " + error);
        }
        if (volleyError.networkResponse != null) {
            if (parseError == null) {
                parseError = new WebServicesError(volleyError.networkResponse);
            } else {
                parseError.setResponseData(volleyError.networkResponse);
            }
        }
        if (parseError == null) {
            parseError = new WebServicesError(this.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
        } else if (parseError.getMessage() == null) {
            parseError.setMessage(this.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
        }
        if (volleyError instanceof NetworkError) {
            parseError.type = WebServicesError.Error.NETWORK_ERROR;
        } else if (volleyError instanceof ServerError) {
            parseError.type = WebServicesError.Error.SERVER_ERROR;
        } else if (volleyError instanceof AuthFailureError) {
            parseError.type = WebServicesError.Error.AUTH_FAILURE_ERROR;
        } else if (volleyError instanceof NoConnectionError) {
            parseError.type = WebServicesError.Error.NO_CONNECTION_ERROR;
        } else if (volleyError instanceof TimeoutError) {
            parseError.type = WebServicesError.Error.TIMEOUT_ERROR;
        }
        return parseError;
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        try {
            WebServicesError volleyError;
            String responseData = this.configuration.getResponseCodification() == null ? new String(response.data) : new String(response.data, this.configuration.getResponseCodification());
            if (this.responseTransformer != null) {
                responseData = this.responseTransformer.transform(responseData);
            }
            if (this.configuration.isSHOW_REQUEST_LOGS()) {
                Log.e((String)"DATAMANAGER", (String)"RESPONSE: ");
                this.printLog(this.path);
                this.printLog(responseData);
                this.configuration.addToBufferLog(responseData, "RESPONSE", super.getUrl());
            }
            if (this.configuration.isSHOW_REQUEST_LOGS_FILE()) {
                this.writeLogInFile("RESPONSE: ");
                this.writeLogInFile(this.path);
                this.writeLogInFile(responseData);
            }
            if ((volleyError = this.configuration.checkError(responseData)) != null) {
                return Response.error((VolleyError)volleyError);
            }
            return Response.success((Object)this.parseResponse(responseData), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((VolleyError)new WebServicesError(this.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE(), WebServicesError.Error.PARSE_ERROR));
        }
    }

    public void printRequest() {
        if (this.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)"REQUEST: ");
            if (!(this instanceof MultipartRequest)) {
                this.printLog(this.path + new String(this.getBody()));
                this.configuration.addToBufferLog(new String(this.getBody()), "REQUEST", super.getUrl());
            }
        }
        if (this.configuration.isSHOW_REQUEST_LOGS_FILE() && !(this instanceof MultipartRequest)) {
            this.writeLogInFile("REQUEST: " + this.path + new String(this.getBody()));
        }
    }

    public void printLog(String log) {
        log = Formatter.toPrettyString(log);
        int cont = 0;
        do {
            Log.e((String)"DATAMANAGER", (String)log.substring(cont, cont + 4000 >= log.length() ? log.length() : cont + 4000));
        } while ((cont += 4000) < log.length());
    }

    public void bridgeToParseNetWorkResponse(NetworkResponse networkResponse) {
        Response<T> response = this.parseNetworkResponse(networkResponse);
        if (response.error != null) {
            this.deliverError(response.error);
        } else {
            this.deliverResponse(response.result);
        }
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    public void writeLogInFile(String text) {
        File root = Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + this.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Request.Priority getPriority() {
        if (this.priority == null) {
            return super.getPriority();
        }
        return this.priority;
    }

    public Map<String, String> getHeaders() {
        Map aux = null;
        try {
            aux = this.headers != null ? this.headers : super.getHeaders();
        }
        catch (Exception a) {
            aux = null;
        }
        return aux;
    }

    public String getBodyContentType() {
        if (this.bodyContentType != null) {
            return this.bodyContentType;
        }
        return super.getBodyContentType();
    }

    public void setBodyContentType(String bodyContentType) {
        this.bodyContentType = bodyContentType;
    }

    public byte[] getBody() {
        if (this.getParams() != null) {
            return this.encodeParameters(this.getParams());
        }
        try {
            return this.requestBody == null ? null : this.requestBody.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    private byte[] encodeParameters(Map<String, String> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                if (this.encodeParams) {
                    postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                } else {
                    postData.append(param.getKey());
                }
                postData.append('=');
                if (this.encodeParams) {
                    postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
                    continue;
                }
                postData.append(param.getValue());
            }
            byte[] data = postData.toString().getBytes("UTF-8");
            return data;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: utf-8", uee);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getParams() {
        Map aux = null;
        if (this.params != null) {
            aux = this.params;
        } else {
            try {
                aux = super.getParams();
            }
            catch (AuthFailureError e) {
                Log.e((String)REQUEST_EXCEPTION, (String)"Error en las cabeceras");
            }
        }
        return aux;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Response.Listener getListener() {
        return this.listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.configuration.getEnvironment() + this.path;
        }
        if (this.getMethod() != 0) {
            return this.url;
        }
        return this.url + this.requestBody;
    }

    public void cancel() {
        super.cancel();
        this.errorListener.onErrorResponse((VolleyError)new CancelError());
    }

    public String getDummyFileName() {
        if (this.dummyFileName == null) {
            return this.getPath();
        }
        return this.dummyFileName;
    }

    public void setDummyFileName(String dummyFileName) {
        this.dummyFileName = dummyFileName;
    }

    public boolean useDummyResponse() {
        return this.useDummyResponse;
    }

    public void setUseDummyResponse(boolean useDummyResponse) {
        this.useDummyResponse = useDummyResponse;
    }

    public boolean isEncodeParams() {
        return this.encodeParams;
    }

    public void setEncodeParams(boolean encodeParams) {
        this.encodeParams = encodeParams;
    }

    public void setConfiguration(WebServicesConfiguration configuration) {
        this.configuration = configuration;
    }

    public ResponseTransformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public void setResponseTransformer(ResponseTransformer responseTransformer) {
        this.responseTransformer = responseTransformer;
    }
}

