/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;

/*     */
/*     */
/*     */

/*     */
/*     */ public class SoapEnvelope
/*     */ {
/*     */   public static final int VER10 = 100;
/*     */   public static final int VER11 = 110;
/*     */   public static final int VER12 = 120;
/*     */   public static final String ENV2003 = "http://www.w3.org/2003/05/soap-envelope";
/*     */   public static final String ENC2003 = "http://www.w3.org/2003/05/soap-encoding";
/*     */   public static final String ENV = "http://schemas.xmlsoap.org/soap/envelope/";
/*     */   public static final String ENC = "http://schemas.xmlsoap.org/soap/encoding/";
/*     */   public static final String XSD = "http://www.w3.org/2001/XMLSchema";
/*     */   public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
/*     */   public static final String XSD1999 = "http://www.w3.org/1999/XMLSchema";
/*     */   public static final String XSI1999 = "http://www.w3.org/1999/XMLSchema-instance";
/*     */   public Object bodyIn;
/*     */   public Object bodyOut;
/*     */   public Element[] headerIn;
/*     */   public Element[] headerOut;
/*     */   public String encodingStyle;
/*     */   public int version;
/*     */   public String env;
/*     */   public String enc;
/*     */   public String xsi;
/*     */   public String xsd;
/*     */ 
/*     */   public static boolean stringToBoolean(String booleanAsString)
/*     */   {
/*  62 */     if (booleanAsString == null)
/*  63 */       return false;
/*  64 */     booleanAsString = booleanAsString.trim().toLowerCase();
/*  65 */     return (booleanAsString.equals("1")) || (booleanAsString.equals("true"));
/*     */   }
/*     */ 
/*     */   public SoapEnvelope(int version)
/*     */   {
/* 107 */     this.version = version;
/* 108 */     if (version == 100) {
/* 109 */       this.xsi = "http://www.w3.org/1999/XMLSchema-instance";
/* 110 */       this.xsd = "http://www.w3.org/1999/XMLSchema";
/*     */     } else {
/* 112 */       this.xsi = "http://www.w3.org/2001/XMLSchema-instance";
/* 113 */       this.xsd = "http://www.w3.org/2001/XMLSchema";
/*     */     }
/* 115 */     if (version < 120) {
/* 116 */       this.enc = "http://schemas.xmlsoap.org/soap/encoding/";
/* 117 */       this.env = "http://schemas.xmlsoap.org/soap/envelope/";
/*     */     } else {
/* 119 */       this.enc = "http://www.w3.org/2003/05/soap-encoding";
/* 120 */       this.env = "http://www.w3.org/2003/05/soap-envelope";
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(XmlPullParser parser) throws IOException, XmlPullParserException
/*     */   {
/* 126 */     parser.nextTag();
/* 127 */     parser.require(2, this.env, "Envelope");
/* 128 */     this.encodingStyle = parser.getAttributeValue(this.env, "encodingStyle");
/* 129 */     parser.nextTag();
/* 130 */     if ((parser.getEventType() == 2) && (parser.getNamespace().equals(this.env)) && (parser.getName().equals("Header"))) {
/* 131 */       parseHeader(parser);
/* 132 */       parser.require(3, this.env, "Header");
/* 133 */       parser.nextTag();
/*     */     }
/* 135 */     parser.require(2, this.env, "Body");
/* 136 */     this.encodingStyle = parser.getAttributeValue(this.env, "encodingStyle");
/* 137 */     parseBody(parser);
/* 138 */     parser.require(3, this.env, "Body");
/* 139 */     parser.nextTag();
/* 140 */     parser.require(3, this.env, "Envelope");
/*     */   }
/*     */ 
/*     */   public void parseHeader(XmlPullParser parser) throws IOException, XmlPullParserException
/*     */   {
/* 145 */     parser.nextTag();
/*     */ 
/* 147 */     Node headers = new Node();
/* 148 */     headers.parse(parser);
/* 149 */     int count = 0;
/* 150 */     for (int i = 0; i < headers.getChildCount(); i++) {
/* 151 */       Element child = headers.getElement(i);
/* 152 */       if (child != null)
/* 153 */         count++;
/*     */     }
/* 155 */     this.headerIn = new Element[count];
/* 156 */     count = 0;
/* 157 */     for (int i = 0; i < headers.getChildCount(); i++) {
/* 158 */       Element child = headers.getElement(i);
/* 159 */       if (child != null)
/* 160 */         this.headerIn[(count++)] = child;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parseBody(XmlPullParser parser) throws IOException, XmlPullParserException {
/* 165 */     parser.nextTag();
/*     */ 
/* 167 */     if ((parser.getEventType() == 2) && (parser.getNamespace().equals(this.env)) && (parser.getName().equals("Fault")))
/*     */     {
/*     */       SoapFault fault;
/* 170 */       if (this.version < 120)
/* 171 */         fault = new SoapFault(this.version);
/*     */       else {
/* 173 */         fault = new SoapFault12(this.version);
/*     */       }
/* 175 */       fault.parse(parser);
/* 176 */       this.bodyIn = fault;
/*     */     } else {
/* 178 */       Node node = (this.bodyIn instanceof Node) ? (Node)this.bodyIn : new Node();
/* 179 */       node.parse(parser);
/* 180 */       this.bodyIn = node;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 189 */     writer.setPrefix("i", this.xsi);
/* 190 */     writer.setPrefix("d", this.xsd);
/* 191 */     writer.setPrefix("c", this.enc);
/* 192 */     writer.setPrefix("v", this.env);
/* 193 */     writer.startTag(this.env, "Envelope");
/* 194 */     writer.startTag(this.env, "Header");
/* 195 */     writeHeader(writer);
/* 196 */     writer.endTag(this.env, "Header");
/* 197 */     writer.startTag(this.env, "Body");
/* 198 */     writeBody(writer);
/* 199 */     writer.endTag(this.env, "Body");
/* 200 */     writer.endTag(this.env, "Envelope");
/*     */   }
/*     */ 
/*     */   public void writeHeader(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 207 */     if (this.headerOut != null)
/* 208 */       for (int i = 0; i < this.headerOut.length; i++)
/* 209 */         this.headerOut[i].write(writer);
/*     */   }
/*     */ 
/*     */   public void writeBody(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 219 */     if (this.encodingStyle != null)
/* 220 */       writer.attribute(this.env, "encodingStyle", this.encodingStyle);
/* 221 */     ((Node)this.bodyOut).write(writer);
/*     */   }
/*     */ 
/*     */   public void setOutputSoapObject(Object soapObject)
/*     */   {
/* 229 */     this.bodyOut = soapObject;
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.ksoap2.SoapEnvelope
 * JD-Core Version:    0.6.2
 */