/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.preferencesmanager;

import android.content.Context;
import android.content.SharedPreferences;
import com.tm.datamanager.preferencesmanager.KeystoreManager;
import com.tm.datamanager.preferencesmanager.PreferencesConfigurations;

public class PreferencesManager {
    private Context context;
    private final SharedPreferences sharedPreferences;
    private PreferencesConfigurations configuration;
    KeystoreManager keystoreManager;

    public PreferencesManager(Context context, PreferencesConfigurations configuration) {
        this.context = context;
        this.configuration = configuration;
        this.keystoreManager = new KeystoreManager(context, configuration.getPreferencesFileName());
        this.sharedPreferences = context.getSharedPreferences(configuration.getPreferencesFileName(), 0);
    }

    public boolean setValue(int value, String preference) {
        return this.sharedPreferences.edit().putInt(preference, value).commit();
    }

    public int getIntValue(String preference) {
        return this.sharedPreferences.getInt(preference, this.configuration.getIntPreferenceDefaultValue());
    }

    public int getIntValue(String preference, int defaultValue) {
        return this.sharedPreferences.getInt(preference, defaultValue);
    }

    public boolean setValue(boolean value, String preference) {
        return this.sharedPreferences.edit().putBoolean(preference, value).commit();
    }

    public boolean getBooleanValue(String preference) {
        return this.sharedPreferences.getBoolean(preference, this.configuration.getBooleanPreferenceDefaultValue());
    }

    public boolean getBooleanValue(String preference, boolean defaultValue) {
        return this.sharedPreferences.getBoolean(preference, defaultValue);
    }

    public boolean setValue(String value, String preference) {
        return this.sharedPreferences.edit().putString(preference, value).commit();
    }

    public boolean setEncryptValue(String value, String preference) {
        if (value.length() > 245) {
            if (this.contains(preference + 1)) {
                this.deleteEncryptedPrefences(preference);
            }
            int splits = value.length() / 245;
            for (int i = 1; i <= splits; ++i) {
                this.saveEncryptPreference(value.substring((i - 1) * 245, i * 245), preference + i);
            }
            if (value.length() % 245 != 0) {
                this.saveEncryptPreference(value.substring(splits++ * 245), preference + splits);
            }
            this.saveEncryptPreference(splits + "", preference);
            return true;
        }
        return this.saveEncryptPreference(value, preference);
    }

    private boolean saveEncryptPreference(String value, String preference) {
        value = this.keystoreManager.encryptText(value);
        return this.sharedPreferences.edit().putString(preference, value).commit();
    }

    public String getExcryptValue(String preference) {
        if (this.contains(preference + 1)) {
            String value = "";
            int splits = Integer.parseInt(this.getEncryptPreference(preference));
            for (int i = 1; i <= splits; ++i) {
                value = value + this.getEncryptPreference(preference + i);
            }
            return value;
        }
        return this.getEncryptPreference(preference);
    }

    private String getEncryptPreference(String preference) {
        String value = this.sharedPreferences.getString(preference, this.configuration.getStringPreferenceDefaultValue());
        return this.keystoreManager.decryptText(value);
    }

    public boolean deleteEncryptedPrefences(String key) {
        int splits = Integer.parseInt(this.getExcryptValue(key));
        for (int i = 1; i <= splits; ++i) {
            this.removePreference(key + i);
        }
        return this.removePreference(key);
    }

    public String getStringValue(String preference) {
        return this.sharedPreferences.getString(preference, this.configuration.getStringPreferenceDefaultValue());
    }

    public String getStringValue(String preference, String defaultValue) {
        return this.sharedPreferences.getString(preference, defaultValue);
    }

    public boolean removePreference(String preference) {
        if (this.contains(preference + 1)) {
            return this.deleteEncryptedPrefences(preference);
        }
        return this.sharedPreferences.edit().remove(preference).commit();
    }

    public boolean clearPreferences() {
        return this.sharedPreferences.edit().clear().commit();
    }

    public boolean contains(String key) {
        return this.sharedPreferences.contains(key);
    }
}

