/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;

/*     */
/*     */
/*     */

/*     */
/*     */ public class SoapFault12 extends SoapFault
/*     */ {
/*     */   private static final long serialVersionUID = 1012001L;
/*     */   public Node Code;
/*     */   public Node Reason;
/*     */   public Node Node;
/*     */   public Node Role;
/*     */   public Node Detail;
/*     */ 
/*     */   public SoapFault12()
/*     */   {
/*  51 */     this.version = 120;
/*     */   }
/*     */ 
/*     */   public SoapFault12(int version)
/*     */   {
/*  56 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public void parse(XmlPullParser parser)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/*  63 */     parseSelf(parser);
/*     */ 
/*  65 */     this.faultcode = this.Code.getElement("http://www.w3.org/2003/05/soap-envelope", "Value").getText(0);
/*  66 */     this.faultstring = this.Reason.getElement("http://www.w3.org/2003/05/soap-envelope", "Text").getText(0);
/*  67 */     this.detail = this.Detail;
/*  68 */     this.faultactor = null;
/*     */   }
/*     */ 
/*     */   private void parseSelf(XmlPullParser parser) throws IOException, XmlPullParserException
/*     */   {
/*  73 */     parser.require(2, "http://www.w3.org/2003/05/soap-envelope", "Fault");
/*     */ 
/*  75 */     while (parser.nextTag() == 2) {
/*  76 */       String name = parser.getName();
/*  77 */       parser.nextTag();
/*  78 */       if (name.equals("Code")) {
/*  79 */         this.Code = new Node();
/*  80 */         this.Code.parse(parser);
/*  81 */       } else if (name.equals("Reason")) {
/*  82 */         this.Reason = new Node();
/*  83 */         this.Reason.parse(parser);
/*  84 */       } else if (name.equals("Node")) {
/*  85 */         this.Node = new Node();
/*  86 */         this.Node.parse(parser);
/*  87 */       } else if (name.equals("Role")) {
/*  88 */         this.Role = new Node();
/*  89 */         this.Role.parse(parser);
/*  90 */       } else if (name.equals("Detail")) {
/*  91 */         this.Detail = new Node();
/*  92 */         this.Detail.parse(parser);
/*     */       } else {
/*  94 */         throw new RuntimeException("unexpected tag:" + name);
/*     */       }
/*     */ 
/*  97 */       parser.require(3, "http://www.w3.org/2003/05/soap-envelope", name);
/*     */     }
/*  99 */     parser.require(3, "http://www.w3.org/2003/05/soap-envelope", "Fault");
/* 100 */     parser.nextTag();
/*     */   }
/*     */ 
/*     */   public void write(XmlSerializer xw)
/*     */     throws IOException
/*     */   {
/* 107 */     xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Fault");
/*     */ 
/* 110 */     xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Code");
/* 111 */     this.Code.write(xw);
/* 112 */     xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Code");
/* 113 */     xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Reason");
/* 114 */     this.Reason.write(xw);
/* 115 */     xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Reason");
/*     */ 
/* 117 */     if (this.Node != null) {
/* 118 */       xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Node");
/* 119 */       this.Node.write(xw);
/* 120 */       xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Node");
/*     */     }
/* 122 */     if (this.Role != null) {
/* 123 */       xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Role");
/* 124 */       this.Role.write(xw);
/* 125 */       xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Role");
/*     */     }
/*     */ 
/* 128 */     if (this.Detail != null) {
/* 129 */       xw.startTag("http://www.w3.org/2003/05/soap-envelope", "Detail");
/* 130 */       this.Detail.write(xw);
/* 131 */       xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Detail");
/*     */     }
/* 133 */     xw.endTag("http://www.w3.org/2003/05/soap-envelope", "Fault");
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 140 */     return this.Reason.getElement("http://www.w3.org/2003/05/soap-envelope", "Text").getText(0);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 145 */     String reason = this.Reason.getElement("http://www.w3.org/2003/05/soap-envelope", "Text").getText(0);
/* 146 */     String code = this.Code.getElement("http://www.w3.org/2003/05/soap-envelope", "Value").getText(0);
/* 147 */     return "Code: " + code + ", Reason: " + reason;
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.ksoap2.SoapFault12
 * JD-Core Version:    0.6.2
 */