package com.tm.datamanager.webservicesmanager.certifieds;

import java.security.cert.X509Certificate;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

/**
 * Created by Navas on 23/6/17.
 */

public class NoCertified extends BaseCertified {

    SSLSocketFactory defaultSslSocketFactory;

    @ Override
    public void checkClientTrusted (X509Certificate [] x509Certificates, String s) throws java.security.cert.CertificateException {
        if(s != null && s.equals("NO TRUSTED"))
            throw new java.security.cert.CertificateException();
    }

    @ Override
    public void checkServerTrusted (X509Certificate [] x509Certificates, String s) throws java.security.cert.CertificateException {
        if(s != null && s.equals("NO TRUSTED"))
            throw new java.security.cert.CertificateException();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void allowAllSSL() {
        if(defaultSslSocketFactory != null)
            HttpsURLConnection.setDefaultSSLSocketFactory (defaultSslSocketFactory);
    }

    public void setDefaultSslSocketFactory(SSLSocketFactory defaultSslSocketFactory) {
        this.defaultSslSocketFactory = defaultSslSocketFactory;
    }
}
