package com.tm.datamanager.webservicesmanager.certifieds;

import android.content.Context;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.HurlStack;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;


public class GermanyCertified extends BaseCertified {

    private static TrustManager[] trustManagers;
    private static final X509Certificate[] _AcceptedIssuers = new X509Certificate [] {};
    private Context context;
    private int certificateResource;
    private RequestQueue queue;
    private String pass;
    private boolean isSecured;

    @ Override
    public void checkClientTrusted (X509Certificate [] x509Certificates, String s) throws java.security.cert.CertificateException {
        if(s != null && s.equals("NO TRUSTED"))
            throw new java.security.cert.CertificateException();
    }

    @ Override
    public void checkServerTrusted (X509Certificate [] x509Certificates, String s) throws java.security.cert.CertificateException {
        if(s != null && s.equals("NO TRUSTED"))
            throw new java.security.cert.CertificateException();
    }

    public boolean isClientTrusted (X509Certificate [] chain) {
        return true;
    }

    public boolean isServerTrusted (X509Certificate [] chain) {
        return true;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return _AcceptedIssuers;
    }


    /*
    @Override
    public X509Certificate [] getAcceptedIssuers () {
        return _AcceptedIssuers;
    }*/
    @Override
    public void allowAllSSL () {
        setAppCertificate();
    }


    public void setAppCertificate() {
        try {

            KeyStore trustStore = buildKeyStore(context, certificateResource);

            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);

            SSLSocketFactory sslFactory = sslContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory (sslFactory);
            HurlStack hurlStack = new HurlStack(null, sslFactory);
            //create request ssl and to queue
            //queue = Volley.newRequestQueue(context, hurlStack);

        }catch(Exception e){
            e.printStackTrace();
        }

    }

    private static KeyStore buildKeyStore(Context context, int certRawResId) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        // init a default key store
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);

        // read and add certificate authority
        Certificate cert = readCert(context, certRawResId);
        keyStore.setCertificateEntry("ca", cert);

        return keyStore;
    }

    private static Certificate readCert(Context context, int certResourceId) throws CertificateException, IOException {

        // read certificate resource
        InputStream caInput = context.getResources().openRawResource(certResourceId);

        Certificate ca;
        try {
            // generate a certificate
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ca = cf.generateCertificate(caInput);
        } finally {
            caInput.close();
        }

        return ca;
    }

    public RequestQueue getQueue() {
        return queue;
    }

    public void setQueue(RequestQueue queue) {
        this.queue = queue;
    }

    public int getCertificateResource() {
        return certificateResource;
    }

    public void setCertificateResource(int certificateResource) {
        this.certificateResource = certificateResource;
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getPass() {
        return pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public boolean isSecured() {
        return isSecured;
    }

    public void setIsSecured(boolean isSecured) {
        this.isSecured = isSecured;
    }
}