/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.certifieds;

import android.content.Context;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.HurlStack;
import com.tm.datamanager.webservicesmanager.certifieds.BaseCertified;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class GermanyCertified
extends BaseCertified {
    private static TrustManager[] trustManagers;
    private static final X509Certificate[] _AcceptedIssuers;
    private Context context;
    private int certificateResource;
    private RequestQueue queue;
    private String pass;
    private boolean isSecured;

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (s != null && s.equals("NO TRUSTED")) {
            throw new CertificateException();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (s != null && s.equals("NO TRUSTED")) {
            throw new CertificateException();
        }
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        return true;
    }

    public boolean isServerTrusted(X509Certificate[] chain) {
        return true;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return _AcceptedIssuers;
    }

    @Override
    public void allowAllSSL() {
        this.setAppCertificate();
    }

    public void setAppCertificate() {
        try {
            KeyStore trustStore = GermanyCertified.buildKeyStore(this.context, this.certificateResource);
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory sslFactory = sslContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslFactory);
            HurlStack hurlStack = new HurlStack(null, sslFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static KeyStore buildKeyStore(Context context, int certRawResId) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        Certificate cert = GermanyCertified.readCert(context, certRawResId);
        keyStore.setCertificateEntry("ca", cert);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate readCert(Context context, int certResourceId) throws CertificateException, IOException {
        Certificate ca;
        try (InputStream caInput = context.getResources().openRawResource(certResourceId);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ca = cf.generateCertificate(caInput);
        }
        return ca;
    }

    public RequestQueue getQueue() {
        return this.queue;
    }

    public void setQueue(RequestQueue queue) {
        this.queue = queue;
    }

    public int getCertificateResource() {
        return this.certificateResource;
    }

    public void setCertificateResource(int certificateResource) {
        this.certificateResource = certificateResource;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setIsSecured(boolean isSecured) {
        this.isSecured = isSecured;
    }

    static {
        _AcceptedIssuers = new X509Certificate[0];
    }
}

