/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

/*     */
/*     */
/*     */
/*     */
/*     */

/*     */
/*     */ public class SoapSerializationEnvelope extends SoapEnvelope
/*     */ {
/*     */   protected static final int QNAME_TYPE = 1;
/*     */   protected static final int QNAME_NAMESPACE = 0;
/*     */   protected static final int QNAME_MARSHAL = 3;
/*     */   private static final String ANY_TYPE_LABEL = "anyType";
/*     */   private static final String ARRAY_MAPPING_NAME = "Array";
/*     */   private static final String NULL_LABEL = "null";
/*     */   private static final String NIL_LABEL = "nil";
/*     */   private static final String HREF_LABEL = "href";
/*     */   private static final String ID_LABEL = "id";
/*     */   private static final String ROOT_LABEL = "root";
/*     */   private static final String TYPE_LABEL = "type";
/*     */   private static final String ITEM_LABEL = "item";
/*     */   private static final String ARRAY_TYPE_LABEL = "arrayType";
/*  53 */   static final Marshal DEFAULT_MARSHAL = new DM();
/*  54 */   public Hashtable properties = new Hashtable();
/*     */ 
/*  56 */   Hashtable idMap = new Hashtable();
/*     */   Vector multiRef;
/*     */   public boolean implicitTypes;
/*     */   public boolean dotNet;
/*  78 */   protected Hashtable qNameToClass = new Hashtable();
/*     */ 
/*  84 */   protected Hashtable classToQName = new Hashtable();
/*     */ 
/*  89 */   protected boolean addAdornments = true;
/*     */ 
/*     */   public SoapSerializationEnvelope(int version)
/*     */   {
/*  93 */     super(version);
/*  94 */     addMapping(this.enc, "Array", PropertyInfo.VECTOR_CLASS);
/*  95 */     DEFAULT_MARSHAL.register(this);
/*     */   }
/*     */ 
/*     */   public boolean isAddAdornments()
/*     */   {
/* 103 */     return this.addAdornments;
/*     */   }
/*     */ 
/*     */   public void setAddAdornments(boolean addAdornments)
/*     */   {
/* 112 */     this.addAdornments = addAdornments;
/*     */   }
/*     */ 
/*     */   public void setBodyOutEmpty(boolean emptyBody)
/*     */   {
/* 122 */     if (emptyBody)
/* 123 */       this.bodyOut = null;
/*     */   }
/*     */ 
/*     */   public void parseBody(XmlPullParser parser)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 129 */     this.bodyIn = null;
/* 130 */     parser.nextTag();
/* 131 */     if ((parser.getEventType() == 2) && (parser.getNamespace().equals(this.env)) && (parser.getName().equals("Fault")))
/*     */     {
/*     */       SoapFault fault;
/* 135 */       if (this.version < 120)
/* 136 */         fault = new SoapFault(this.version);
/*     */       else {
/* 138 */         fault = new SoapFault12(this.version);
/*     */       }
/* 140 */       fault.parse(parser);
/* 141 */       this.bodyIn = fault;
/*     */     }
/*     */     else
/*     */     {
/* 145 */       while (parser.getEventType() == 2)
/*     */       {
/* 147 */         String rootAttr = parser.getAttributeValue(this.enc, "root");
/*     */ 
/* 149 */         Object o = read(parser, null, -1, parser.getNamespace(), parser.getName(), PropertyInfo.OBJECT_TYPE);
/*     */ 
/* 151 */         if (("1".equals(rootAttr)) || (this.bodyIn == null))
/* 152 */           this.bodyIn = o;
/* 153 */         parser.nextTag();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void readSerializable(XmlPullParser parser, SoapObject obj)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 162 */     for (int counter = 0; counter < parser.getAttributeCount(); counter++)
/*     */     {
/* 164 */       String attributeName = parser.getAttributeName(counter);
/* 165 */       String value = parser.getAttributeValue(counter);
/* 166 */       obj.addAttribute(attributeName, value);
/*     */     }
/* 168 */     readSerializable(parser, obj);
/*     */   }
/*     */ 
/*     */   protected void readSerializable(XmlPullParser parser, KvmSerializable obj)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 175 */     int testIndex = -1;
/* 176 */     int propertyCount = obj.getPropertyCount();
/* 177 */     PropertyInfo info = new PropertyInfo();
/* 178 */     while (parser.nextTag() != 3)
/*     */     {
/* 180 */       String name = parser.getName();
/* 181 */       int countdown = propertyCount;
/*     */ 
/* 188 */       if ((!this.implicitTypes) || (!(obj instanceof SoapObject)))
/*     */       {
/*     */         while (true)
/*     */         {
/* 192 */           if (countdown-- == 0)
/*     */           {
/* 194 */             throw new RuntimeException("Unknown Property: " + name);
/*     */           }
/* 196 */           testIndex++; if (testIndex >= propertyCount)
/*     */           {
/* 198 */             testIndex = 0;
/*     */           }
/* 200 */           obj.getPropertyInfo(testIndex, this.properties, info);
/* 201 */           if (((info.namespace != null) || (!name.equals(info.name))) && ((info.name != null) || (testIndex != 0))) if ((name.equals(info.name)) && (parser.getNamespace().equals(info.namespace)))
/*     */             {
/* 205 */               break;
/*     */             }
/*     */         }
/* 208 */         obj.setProperty(testIndex, read(parser, obj, testIndex, null, null, info));
/*     */       }
/*     */       else
/*     */       {
/* 214 */         ((SoapObject)obj).addProperty(parser.getName(), read(parser, obj, obj.getPropertyCount(), ((SoapObject)obj).getNamespace(), name, PropertyInfo.OBJECT_TYPE));
/*     */       }
/*     */     }
/*     */ 
/* 218 */     parser.require(3, null, null);
/*     */   }
/*     */ 
/*     */   protected Object readUnknown(XmlPullParser parser, String typeNamespace, String typeName)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 236 */     String name = parser.getName();
/* 237 */     String namespace = parser.getNamespace();
/*     */ 
/* 240 */     Vector attributeInfoVector = new Vector();
/* 241 */     for (int attributeCount = 0; attributeCount < parser.getAttributeCount(); attributeCount++)
/*     */     {
/* 243 */       AttributeInfo attributeInfo = new AttributeInfo();
/* 244 */       attributeInfo.setName(parser.getAttributeName(attributeCount));
/* 245 */       attributeInfo.setValue(parser.getAttributeValue(attributeCount));
/* 246 */       attributeInfo.setNamespace(parser.getAttributeNamespace(attributeCount));
/* 247 */       attributeInfo.setType(parser.getAttributeType(attributeCount));
/* 248 */       attributeInfoVector.addElement(attributeInfo);
/*     */     }
/*     */ 
/* 251 */     parser.next();
/* 252 */     Object result = null;
/* 253 */     String text = null;
/* 254 */     if (parser.getEventType() == 4)
/*     */     {
/* 256 */       text = parser.getText();
/* 257 */       SoapPrimitive sp = new SoapPrimitive(typeNamespace, typeName, text);
/* 258 */       result = sp;
/*     */ 
/* 260 */       for (int i = 0; i < attributeInfoVector.size(); i++) {
/* 261 */         sp.addAttribute((AttributeInfo)attributeInfoVector.elementAt(i));
/*     */       }
/* 263 */       parser.next();
/*     */     }
/* 265 */     else if (parser.getEventType() == 3)
/*     */     {
/* 267 */       SoapObject so = new SoapObject(typeNamespace, typeName);
/*     */ 
/* 269 */       for (int i = 0; i < attributeInfoVector.size(); i++) {
/* 270 */         so.addAttribute((AttributeInfo)attributeInfoVector.elementAt(i));
/*     */       }
/* 272 */       result = so;
/*     */     }
/*     */ 
/* 275 */     if (parser.getEventType() == 2)
/*     */     {
/* 277 */       if ((text != null) && (text.trim().length() != 0))
/*     */       {
/* 279 */         throw new RuntimeException("Malformed input: Mixed content");
/*     */       }
/* 281 */       SoapObject so = new SoapObject(typeNamespace, typeName);
/*     */ 
/* 283 */       for (int i = 0; i < attributeInfoVector.size(); i++) {
/* 284 */         so.addAttribute((AttributeInfo)attributeInfoVector.elementAt(i));
/*     */       }
/*     */ 
/* 287 */       while (parser.getEventType() != 3)
/*     */       {
/* 289 */         so.addProperty(parser.getName(), read(parser, so, so.getPropertyCount(), null, null, PropertyInfo.OBJECT_TYPE));
/*     */ 
/* 291 */         parser.nextTag();
/*     */       }
/* 293 */       result = so;
/*     */     }
/* 295 */     parser.require(3, namespace, name);
/* 296 */     return result;
/*     */   }
/*     */ 
/*     */   private int getIndex(String value, int start, int dflt)
/*     */   {
/* 301 */     if (value == null)
/* 302 */       return dflt;
/* 303 */     return value.length() - start < 3 ? dflt : Integer.parseInt(value.substring(start + 1, value.length() - 1));
/*     */   }
/*     */ 
/*     */   protected void readVector(XmlPullParser parser, Vector v, PropertyInfo elementType)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 310 */     String namespace = null;
/* 311 */     String name = null;
/* 312 */     int size = v.size();
/* 313 */     boolean dynamic = true;
/* 314 */     String type = parser.getAttributeValue(this.enc, "arrayType");
/* 315 */     if (type != null)
/*     */     {
/* 317 */       int cut0 = type.indexOf(':');
/* 318 */       int cut1 = type.indexOf("[", cut0);
/* 319 */       name = type.substring(cut0 + 1, cut1);
/* 320 */       String prefix = cut0 == -1 ? "" : type.substring(0, cut0);
/* 321 */       namespace = parser.getNamespace(prefix);
/* 322 */       size = getIndex(type, cut1, -1);
/* 323 */       if (size != -1)
/*     */       {
/* 325 */         v.setSize(size);
/* 326 */         dynamic = false;
/*     */       }
/*     */     }
/* 329 */     if (elementType == null)
/* 330 */       elementType = PropertyInfo.OBJECT_TYPE;
/* 331 */     parser.nextTag();
/* 332 */     int position = getIndex(parser.getAttributeValue(this.enc, "offset"), 0, 0);
/* 333 */     while (parser.getEventType() != 3)
/*     */     {
/* 336 */       position = getIndex(parser.getAttributeValue(this.enc, "position"), 0, position);
/* 337 */       if ((dynamic) && (position >= size))
/*     */       {
/* 339 */         size = position + 1;
/* 340 */         v.setSize(size);
/*     */       }
/*     */ 
/* 343 */       v.setElementAt(read(parser, v, position, namespace, name, elementType), position);
/* 344 */       position++;
/* 345 */       parser.nextTag();
/*     */     }
/* 347 */     parser.require(3, null, null);
/*     */   }
/*     */ 
/*     */   public Object read(XmlPullParser parser, Object owner, int index, String namespace, String name, PropertyInfo expected)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 358 */     String elementName = parser.getName();
/* 359 */     String href = parser.getAttributeValue(null, "href");
/*     */     Object obj;
/* 361 */     if (href != null)
/*     */     {
/* 363 */       if (owner == null)
/* 364 */         throw new RuntimeException("href at root level?!?");
/* 365 */       href = href.substring(1);
/* 366 */       obj = this.idMap.get(href);
/* 367 */       if ((obj == null) || ((obj instanceof FwdRef)))
/*     */       {
/* 369 */         FwdRef f = new FwdRef();
/* 370 */         f.next = ((FwdRef)obj);
/* 371 */         f.obj = owner;
/* 372 */         f.index = index;
/* 373 */         this.idMap.put(href, f);
/* 374 */         obj = null;
/*     */       }
/* 376 */       parser.nextTag();
/* 377 */       parser.require(3, null, elementName);
/*     */     }
/*     */     else
/*     */     {
/* 381 */       String nullAttr = parser.getAttributeValue(this.xsi, "nil");
/* 382 */       String id = parser.getAttributeValue(null, "id");
/* 383 */       if (nullAttr == null)
/* 384 */         nullAttr = parser.getAttributeValue(this.xsi, "null");
/* 385 */       if ((nullAttr != null) && (SoapEnvelope.stringToBoolean(nullAttr)))
/*     */       {
/* 387 */         obj = null;
/* 388 */         parser.nextTag();
/* 389 */         parser.require(3, null, elementName);
/*     */       }
/*     */       else
/*     */       {
/* 393 */         String type = parser.getAttributeValue(this.xsi, "type");
/* 394 */         if (type != null)
/*     */         {
/* 396 */           int cut = type.indexOf(':');
/* 397 */           name = type.substring(cut + 1);
/* 398 */           String prefix = cut == -1 ? "" : type.substring(0, cut);
/* 399 */           namespace = parser.getNamespace(prefix);
/*     */         }
/* 401 */         else if ((name == null) && (namespace == null))
/*     */         {
/* 403 */           if (parser.getAttributeValue(this.enc, "arrayType") != null)
/*     */           {
/* 405 */             namespace = this.enc;
/* 406 */             name = "Array";
/*     */           }
/*     */           else
/*     */           {
/* 410 */             Object[] names = getInfo(expected.type, null);
/* 411 */             namespace = (String)names[0];
/* 412 */             name = (String)names[1];
/*     */           }
/*     */         }
/*     */ 
/* 416 */         if (type == null)
/*     */         {
/* 418 */           this.implicitTypes = true;
/*     */         }
/* 420 */         obj = readInstance(parser, namespace, name, expected);
/* 421 */         if (obj == null) {
/* 422 */           obj = readUnknown(parser, namespace, name);
/*     */         }
/*     */       }
/* 425 */       if (id != null)
/*     */       {
/* 427 */         Object hlp = this.idMap.get(id);
/* 428 */         if ((hlp instanceof FwdRef))
/*     */         {
/* 430 */           FwdRef f = (FwdRef)hlp;
/*     */           do
/*     */           {
/* 433 */             if ((f.obj instanceof KvmSerializable))
/* 434 */               ((KvmSerializable)f.obj).setProperty(f.index, obj);
/*     */             else
/* 436 */               ((Vector)f.obj).setElementAt(obj, f.index);
/* 437 */             f = f.next;
/*     */           }
/* 439 */           while (f != null);
/*     */         }
/* 441 */         else if (hlp != null) {
/* 442 */           throw new RuntimeException("double ID");
/* 443 */         }this.idMap.put(id, obj);
/*     */       }
/*     */     }
/*     */ 
/* 447 */     parser.require(3, null, elementName);
/* 448 */     return obj;
/*     */   }
/*     */ 
/*     */   public Object readInstance(XmlPullParser parser, String namespace, String name, PropertyInfo expected)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 458 */     Object obj = this.qNameToClass.get(new SoapPrimitive(namespace, name, null));
/* 459 */     if (obj == null)
/* 460 */       return null;
/* 461 */     if ((obj instanceof Marshal))
/* 462 */       return ((Marshal)obj).readInstance(parser, namespace, name, expected);
/* 463 */     if ((obj instanceof SoapObject))
/*     */     {
/* 465 */       obj = ((SoapObject)obj).newInstance();
/*     */     }
/* 467 */     else if (obj == SoapObject.class)
/*     */     {
/* 469 */       obj = new SoapObject(namespace, name);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 475 */         obj = ((Class)obj).newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 479 */         throw new RuntimeException(e.toString());
/*     */       }
/*     */     }
/*     */ 
/* 483 */     if ((obj instanceof SoapObject))
/* 484 */       readSerializable(parser, (SoapObject)obj);
/* 485 */     else if ((obj instanceof KvmSerializable))
/* 486 */       readSerializable(parser, (KvmSerializable)obj);
/* 487 */     else if ((obj instanceof Vector))
/* 488 */       readVector(parser, (Vector)obj, expected.elementType);
/*     */     else
/* 490 */       throw new RuntimeException("no deserializer for " + obj.getClass());
/* 491 */     return obj;
/*     */   }
/*     */ 
/*     */   public Object[] getInfo(Object type, Object instance)
/*     */   {
/* 501 */     if (type == null)
/*     */     {
/* 503 */       if (((instance instanceof SoapObject)) || ((instance instanceof SoapPrimitive)))
/* 504 */         type = instance;
/*     */       else
/* 506 */         type = instance.getClass();
/*     */     }
/* 508 */     if ((type instanceof SoapObject))
/*     */     {
/* 510 */       SoapObject so = (SoapObject)type;
/* 511 */       return new Object[] { so.getNamespace(), so.getName(), null, null };
/*     */     }
/* 513 */     if ((type instanceof SoapPrimitive))
/*     */     {
/* 515 */       SoapPrimitive sp = (SoapPrimitive)type;
/* 516 */       return new Object[] { sp.getNamespace(), sp.getName(), null, DEFAULT_MARSHAL };
/*     */     }
/* 518 */     if (((type instanceof Class)) && (type != PropertyInfo.OBJECT_CLASS))
/*     */     {
/* 520 */       Object[] tmp = (Object[])this.classToQName.get(((Class)type).getName());
/* 521 */       if (tmp != null)
/* 522 */         return tmp;
/*     */     }
/* 524 */     return new Object[] { this.xsd, "anyType", null, null };
/*     */   }
/*     */ 
/*     */   public void addMapping(String namespace, String name, Class clazz, Marshal marshal)
/*     */   {
/* 533 */     this.qNameToClass.put(new SoapPrimitive(namespace, name, null), marshal == null ? clazz : marshal);
/*     */ 
/* 535 */     this.classToQName.put(clazz.getName(), new Object[] { namespace, name, null, marshal });
/*     */   }
/*     */ 
/*     */   public void addMapping(String namespace, String name, Class clazz)
/*     */   {
/* 543 */     addMapping(namespace, name, clazz, null);
/*     */   }
/*     */ 
/*     */   public void addTemplate(SoapObject so)
/*     */   {
/* 552 */     this.qNameToClass.put(new SoapPrimitive(so.namespace, so.name, null), so);
/*     */   }
/*     */ 
/*     */   public Object getResponse()
/*     */     throws SoapFault
/*     */   {
/* 564 */     if ((this.bodyIn instanceof SoapFault))
/*     */     {
/* 566 */       throw ((SoapFault)this.bodyIn);
/*     */     }
/* 568 */     KvmSerializable ks = (KvmSerializable)this.bodyIn;
/*     */ 
/* 570 */     if (ks.getPropertyCount() == 0)
/* 571 */       return null;
/* 572 */     if (ks.getPropertyCount() == 1) {
/* 573 */       return ks.getProperty(0);
/*     */     }
/* 575 */     Vector ret = new Vector();
/* 576 */     for (int i = 0; i < ks.getPropertyCount(); i++) {
/* 577 */       ret.add(ks.getProperty(i));
/*     */     }
/* 579 */     return ret;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Object getResult()
/*     */   {
/* 590 */     KvmSerializable ks = (KvmSerializable)this.bodyIn;
/* 591 */     return ks.getPropertyCount() == 0 ? null : ks.getProperty(0);
/*     */   }
/*     */ 
/*     */   public void writeBody(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 604 */     if (this.bodyOut != null) {
/* 605 */       this.multiRef = new Vector();
/* 606 */       this.multiRef.addElement(this.bodyOut);
/* 607 */       Object[] qName = getInfo(null, this.bodyOut);
/* 608 */       writer.startTag(this.dotNet ? "" : (String)qName[0], (String)qName[1]);
/* 609 */       if (this.dotNet)
/*     */       {
/* 611 */         writer.attribute(null, "xmlns", (String)qName[0]);
/*     */       }
/* 613 */       if (this.addAdornments)
/*     */       {
/* 615 */         writer.attribute(null, "id", qName[2] == null ? "o0" : (String)qName[2]);
/* 616 */         writer.attribute(this.enc, "root", "1");
/*     */       }
/* 618 */       writeElement(writer, this.bodyOut, null, qName[3]);
/* 619 */       writer.endTag(this.dotNet ? "" : (String)qName[0], (String)qName[1]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeObjectBody(XmlSerializer writer, SoapObject obj)
/*     */     throws IOException
/*     */   {
/* 629 */     SoapObject soapObject = obj;
/* 630 */     int cnt = soapObject.getAttributeCount();
/* 631 */     for (int counter = 0; counter < cnt; counter++)
/*     */     {
/* 633 */       AttributeInfo attributeInfo = new AttributeInfo();
/* 634 */       soapObject.getAttributeInfo(counter, attributeInfo);
/* 635 */       writer.attribute(attributeInfo.getNamespace(), attributeInfo.getName(), attributeInfo.getValue().toString());
/*     */     }
/*     */ 
/* 638 */     cnt = soapObject.getNestedSoapCount();
/* 639 */     for (int counter = 0; counter < cnt; counter++) {
/* 640 */       SoapObject nestedSoap = (SoapObject)soapObject.getNestedSoap(counter);
/* 641 */       writer.startTag(nestedSoap.getNamespace(), nestedSoap.getName());
/* 642 */       writeObjectBody(writer, nestedSoap);
/* 643 */       writer.endTag(nestedSoap.getNamespace(), nestedSoap.getName());
/*     */     }
/* 645 */     writeObjectBody(writer, obj);
/*     */   }
/*     */ 
/*     */   public void writeObjectBody(XmlSerializer writer, KvmSerializable obj)
/*     */     throws IOException
/*     */   {
/* 653 */     PropertyInfo info = new PropertyInfo();
/* 654 */     int cnt = obj.getPropertyCount();
/* 655 */     for (int i = 0; i < cnt; i++)
/*     */     {
/* 657 */       obj.getPropertyInfo(i, this.properties, info);
/* 658 */       if ((info.flags & 0x1) == 0)
/*     */       {
/* 660 */         writer.startTag(info.namespace, info.name);
/* 661 */         writeProperty(writer, obj.getProperty(i), info);
/* 662 */         writer.endTag(info.namespace, info.name);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void writeProperty(XmlSerializer writer, Object obj, PropertyInfo type) throws IOException
/*     */   {
/* 669 */     if (obj == null)
/*     */     {
/* 671 */       writer.attribute(this.xsi, this.version >= 120 ? "nil" : "null", "true");
/* 672 */       return;
/*     */     }
/* 674 */     Object[] qName = getInfo(null, obj);
/* 675 */     if ((type.multiRef) || (qName[2] != null))
/*     */     {
/* 677 */       int i = this.multiRef.indexOf(obj);
/* 678 */       if (i == -1)
/*     */       {
/* 680 */         i = this.multiRef.size();
/* 681 */         this.multiRef.addElement(obj);
/*     */       }
/* 683 */       writer.attribute(null, "href", "#" + qName[2]);
/*     */     }
/*     */     else
/*     */     {
/* 687 */       if ((!this.implicitTypes) || (obj.getClass() != type.type))
/*     */       {
/* 689 */         String prefix = writer.getPrefix((String)qName[0], true);
/* 690 */         writer.attribute(this.xsi, "type", prefix + ":" + qName[1]);
/*     */       }
/* 692 */       writeElement(writer, obj, type, qName[3]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeElement(XmlSerializer writer, Object element, PropertyInfo type, Object marshal)
/*     */     throws IOException
/*     */   {
/* 699 */     if (marshal != null)
/* 700 */       ((Marshal)marshal).writeInstance(writer, element);
/* 701 */     else if ((element instanceof SoapObject))
/* 702 */       writeObjectBody(writer, (SoapObject)element);
/* 703 */     else if ((element instanceof KvmSerializable))
/* 704 */       writeObjectBody(writer, (KvmSerializable)element);
/* 705 */     else if ((element instanceof Vector))
/* 706 */       writeVectorBody(writer, (Vector)element, type.elementType);
/*     */     else
/* 708 */       throw new RuntimeException("Cannot serialize: " + element);
/*     */   }
/*     */ 
/*     */   protected void writeVectorBody(XmlSerializer writer, Vector vector, PropertyInfo elementType)
/*     */     throws IOException
/*     */   {
/* 714 */     String itemsTagName = "item";
/* 715 */     String itemsNamespace = null;
/*     */ 
/* 717 */     if (elementType == null)
/*     */     {
/* 719 */       elementType = PropertyInfo.OBJECT_TYPE;
/*     */     }
/* 721 */     else if ((elementType instanceof PropertyInfo))
/*     */     {
/* 723 */       if (elementType.name != null)
/*     */       {
/* 725 */         itemsTagName = elementType.name;
/* 726 */         itemsNamespace = elementType.namespace;
/*     */       }
/*     */     }
/*     */ 
/* 730 */     int cnt = vector.size();
/* 731 */     Object[] arrType = getInfo(elementType.type, null);
/*     */ 
/* 734 */     if (!this.implicitTypes)
/*     */     {
/* 736 */       writer.attribute(this.enc, "arrayType", writer.getPrefix((String)arrType[0], false) + ":" + arrType[1] + "[" + cnt + "]");
/*     */     }
/*     */ 
/* 740 */     boolean skipped = false;
/* 741 */     for (int i = 0; i < cnt; i++)
/*     */     {
/* 743 */       if (vector.elementAt(i) == null) {
/* 744 */         skipped = true;
/*     */       }
/*     */       else {
/* 747 */         writer.startTag(itemsNamespace, itemsTagName);
/* 748 */         if (skipped)
/*     */         {
/* 750 */           writer.attribute(this.enc, "position", "[" + i + "]");
/* 751 */           skipped = false;
/*     */         }
/*     */ 
/* 754 */         writeProperty(writer, vector.elementAt(i), elementType);
/*     */ 
/* 756 */         writer.endTag(itemsNamespace, itemsTagName);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.ksoap2.serialization.SoapSerializationEnvelope
 * JD-Core Version:    0.6.2
 */