package com.tm.datamanager.webservicesmanager.requests;

import android.content.Context;
import android.content.res.AssetManager;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Created by Navas on 24/06/15
 * It controls all dummy request
 */
public class DummyRequestQueue extends RequestQueue{

    AssetManager assetManager;

    RequestFinishedListener requestFinishedListener;

    public DummyRequestQueue(Context context) {
        super(null, null);
        this.assetManager = context.getAssets();
    }

    @Override
    public Request add(Request request){
        CustomRequest customRequest = (CustomRequest) request;
        String data = DummyResponses.DUMMY_RESPONSES.get(customRequest.getPath());
        NetworkResponse networkResponse;
        if(data == null){
            networkResponse = new NetworkResponse(readDummyFile(customRequest.getDummyFileName()));
        }else{
            networkResponse = new NetworkResponse(data.getBytes());
        }
        Response response = customRequest.parseNetworkResponse(networkResponse);
        if(response.error!=null)
            customRequest.deliverError(response.error);
        else
            customRequest.deliverResponse(response.result);
        if(requestFinishedListener != null) requestFinishedListener.onRequestFinished(request);
        return request;
    }

    @Override
    public <T> void addRequestFinishedListener(RequestFinishedListener<T> listener) {
        this.requestFinishedListener = listener;
    }

    private byte[] readDummyFile(String dummyFile){
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(
                    new InputStreamReader(assetManager.open("dummies/"+dummyFile)));
            StringBuffer buffer = new StringBuffer();
            // do reading, usually loop until end of file reading
            String mLine;
            while ((mLine = reader.readLine()) != null) {
                buffer.append(mLine);
            }
            return buffer.toString().getBytes();
        } catch (IOException e) {
            return "".getBytes();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    //log the exception
                }
            }
        }
    }


}
