package com.tm.datamanager.webservicesmanager.requests;

import android.util.Log;
import android.util.Xml;

import com.android.volley.Response;
import com.google.gson.Gson;
import com.tm.datamanager.webservicesmanager.soap.SoapEnvelope;
import com.tm.datamanager.webservicesmanager.soap.SoapObject;
import com.tm.datamanager.webservicesmanager.soap.SoapResponse;
import com.tm.datamanager.webservicesmanager.soap.SoapSerializationEnvelope;

import org.json.JSONException;
import org.json.XML;
import org.xmlpull.v1.XmlPullParser;

import java.io.ByteArrayInputStream;

/**
 * Created by Navas on 10/6/15
 * Return the response parsed to T class using Soap Response
 */
public class CustomSoapObjectRequest<T extends SoapResponse> extends CustomRequest<T> {
    private final Gson gson = new Gson();
    private Class<T> clazz;

    public CustomSoapObjectRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    @Override
    protected Object parseResponse(String response) {
        try {
            SoapObject soapObject = stringToSoapObject(response);
            T responseObject = clazz.newInstance();
            responseObject.parse(soapObject);
            return responseObject;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;

    }

    public static SoapObject stringToSoapObject(String response) throws Exception {

        SoapSerializationEnvelope envelope=new SoapSerializationEnvelope(SoapEnvelope.VER11);
        SoapObject soap=null;
        try {
            ByteArrayInputStream inputStream=new ByteArrayInputStream(response.getBytes());
            XmlPullParser p= Xml.newPullParser();
            p.setInput(inputStream, "UTF-8");
            envelope.parse(p);
            soap=(SoapObject)envelope.bodyIn;
        } catch (Exception e) {
            e.printStackTrace();
        }



        return soap;
    }
}
