package com.tm.datamanager.webservicesmanager.error;

import com.android.volley.NetworkResponse;
import com.android.volley.VolleyError;

/**
 * Created by Navas on 8/8/17.
 */

public class WebServicesError extends VolleyError {

    public static enum Error { NETWORK_ERROR, SERVER_ERROR, AUTH_FAILURE_ERROR, NO_CONNECTION_ERROR, TIMEOUT_ERROR, OTHER_ERROR}

    public Error type = Error.OTHER_ERROR;

    String message;

    public WebServicesError(NetworkResponse response) {
        super(response);
    }

    public WebServicesError(String exceptionMessage) {
        super(exceptionMessage);
        message = exceptionMessage;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
