package com.tm.datamanager.webservicesmanager.requests;

import android.util.Log;
import android.util.Xml;

import com.android.volley.Response;
import com.google.gson.Gson;
import com.tm.datamanager.webservicesmanager.soap.SoapEnvelope;
import com.tm.datamanager.webservicesmanager.soap.SoapObject;
import com.tm.datamanager.webservicesmanager.soap.SoapResponse;
import com.tm.datamanager.webservicesmanager.soap.SoapSerializationEnvelope;

import org.json.JSONException;
import org.json.XML;
import org.xmlpull.v1.XmlPullParser;

import java.io.ByteArrayInputStream;

/**
 * Created by Navas on 10/6/15
 * Return the response parsed to T class using Soap Response
 */
public class CustomSoapRequest<T> extends CustomRequest<T> {
    private final Gson gson = new Gson();
    private Class<T> clazz;
    String rootLabel = "methodResult";

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz,String rootLabel) {
        super(method, path, requestBody, listener, errorListener);
        this.clazz = clazz;
        if(rootLabel != null) this.rootLabel = rootLabel;
    }

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz,String rootLabel) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
        if(rootLabel != null) this.rootLabel = rootLabel;
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz,String rootLabel) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.clazz = clazz;
        if(rootLabel != null) this.rootLabel = rootLabel;
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz,String rootLabel) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
        if(rootLabel != null) this.rootLabel = rootLabel;
    }

    @Override
    protected Object parseResponse(String response) {
        String initLabel = "<"+rootLabel+">";
        String endLabel = "</"+rootLabel+">";
        String xml = response.substring(response.indexOf(initLabel) + initLabel.length(),
                response.indexOf(endLabel));


        try {
            return gson.fromJson(XML.toJSONObject(xml).toString(), clazz);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;

    }

    public static SoapObject stringToSoapObject(String response) throws Exception {

        SoapSerializationEnvelope envelope=new SoapSerializationEnvelope(SoapEnvelope.VER11);
        SoapObject soap=null;
        try {
            ByteArrayInputStream inputStream=new ByteArrayInputStream(response.getBytes());
            XmlPullParser p= Xml.newPullParser();
            p.setInput(inputStream, "UTF-8");
            envelope.parse(p);
            soap=(SoapObject)envelope.bodyIn;
        } catch (Exception e) {
            e.printStackTrace();
        }



        return soap;
    }
}
