package com.tm.datamanager.webservicesmanager.requests;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import com.tm.datamanager.webservicesmanager.error.CancelError;
import com.tm.datamanager.webservicesmanager.formatters.Formatter;
import com.tm.datamanager.webservicesmanager.formatters.ResponseTransformer;

import org.json.JSONException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Navas on 23/06/15
 * This is the parent of the request
 * By default return the response in String format
 */
public class  CustomRequest<T> extends JsonRequest<T> {

    protected Map<String, String> headers;
    protected Map<String, String> params;
    protected Response.Listener listener;
    protected String path;
    protected String requestBody;
    protected Response.ErrorListener errorListener;
    protected Priority priority;
    protected boolean encodeParams = true;

    protected static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    protected static final String RESPONSE = "response";

    protected boolean useDummyResponse = false;

    protected String dummyFileName;

    protected String bodyContentType;

    protected WebServicesConfiguration configuration;
    protected String url;

    protected ResponseTransformer responseTransformer;

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.path = path;
        url = environment + path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        url = environment + path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }


    @Override
    protected void deliverResponse(T response) {
        if(response != null)
            listener.onResponse(response);
    }

    @Override
    public void deliverError(VolleyError error) {
        errorListener.onErrorResponse(error);
    }

    @Override
    protected VolleyError parseNetworkError(VolleyError volleyError) {

        volleyError.printStackTrace();
        String error="";
        VolleyError parseError = null;
        if(volleyError.getMessage() != null){
            error = volleyError.getMessage();
            parseError = configuration.checkError(error);
        }else if(volleyError.networkResponse != null && volleyError.networkResponse.data != null){
            error = new String(volleyError.networkResponse.data);
            parseError = configuration.checkError(error);
        }else if(volleyError.networkResponse != null){
            error = volleyError.networkResponse.statusCode+"";
        }
        if (configuration.isSHOW_REQUEST_LOGS()) {
            Log.e("DATAMANAGER", "ERROR: ");
            printLog(error);
            configuration.addToBufferLog(error,"RESPONSE ERROR", super.getUrl());
        }
        if (configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("ERROR:  " + error);
        if(parseError != null) return parseError;
        return new VolleyError(configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
    }

    @Override
    protected Response<T> parseNetworkResponse(NetworkResponse response) {
//        if(configuration.isSAVECOOKIES()) {
//            WebServicesManager.headers = response.headers;
//            WebServicesManager.headers.remove("Content-Length");
//        }
        try {
            String responseData;
            if(configuration.getResponseCodification() == null)
                responseData = new String(response.data);
            else
                responseData = new String(response.data,configuration.getResponseCodification());

            if(responseTransformer != null) responseData = responseTransformer.transform(responseData);

            if (configuration.isSHOW_REQUEST_LOGS()) {
                Log.e("DATAMANAGER", "RESPONSE: ");
                printLog(path);
                printLog(responseData);
                configuration.addToBufferLog(responseData,"RESPONSE", super.getUrl());
            }
            if (configuration.isSHOW_REQUEST_LOGS_FILE()) {
                writeLogInFile("RESPONSE: ");
                writeLogInFile(path);
                writeLogInFile(responseData);
            }

            VolleyError volleyError = configuration.checkError(responseData);
            if (volleyError != null) {
                return Response.error(volleyError);
            } else {
                return Response.success((T) parseResponse(responseData)
                        , HttpHeaderParser.parseCacheHeaders(response));
            }

        } catch (Exception e) {
            e.printStackTrace();
            return Response.error(new VolleyError(configuration.getDEFAULT_REQUEST_ERROR_MESSAGE()));
        }
    }

    public void printRequest(){
        if (configuration.isSHOW_REQUEST_LOGS()) {
            Log.e("DATAMANAGER", "REQUEST: ");
            if(! (this instanceof MultipartRequest)) {
                printLog(path + new String(getBody()));
                configuration.addToBufferLog(new String(getBody()),"REQUEST", super.getUrl());
            }
        }
        if (configuration.isSHOW_REQUEST_LOGS_FILE())
            if(! (this instanceof MultipartRequest))
            writeLogInFile("REQUEST: " + path +  new String(getBody()));
    }

    public void printLog(String log){
        log = Formatter.toPrettyString(log);
        int cont = 0;
        do{
            Log.e("DATAMANAGER",
                    log.substring(cont, (cont+4000 >= log.length())?log.length() : cont+4000));
            cont += 4000;
        }while(cont < log.length());
    }

    /**
     * Function to process request from external WebServicesManagers
     * @param networkResponse
     */
    public void bridgeToParseNetWorkResponse(NetworkResponse networkResponse){
        Response response = parseNetworkResponse(networkResponse);
        if(response.error != null)
            deliverError(response.error);
        else
            deliverResponse((T) response.result);
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    /**
     * WRITE THE REQUESTS AND RESPONSES IN THE LOG FILE
     *
     * @param text log to write in the log
     */
    public void writeLogInFile(String text) {
        File root = android.os.Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    // GETTERS AND SETTERS

    @Override
    public Priority getPriority() {
        if (priority == null)
            return super.getPriority();
        return priority;
    }


    @Override
    public Map<String, String> getHeaders() {

        Map<String, String> aux = null;
        try {
            if (headers != null) {
                aux = headers;
            } else {
                aux = super.getHeaders();
            }
        }catch (Exception a){
            aux = null;
        }

        return aux;
    }

    @Override
    public String getBodyContentType() {
        if(bodyContentType != null)
            return bodyContentType;
        else return super.getBodyContentType();
    }

    public void setBodyContentType(String bodyContentType) {
        this.bodyContentType = bodyContentType;
    }

    @Override
    public byte[] getBody() {
        if(getParams() != null){
            return encodeParameters(getParams());
        }else {
            try {
                return requestBody == null ? null : requestBody.getBytes(PROTOCOL_CHARSET);
            } catch (UnsupportedEncodingException uee) {
                return null;
            }
        }
    }

    private byte[] encodeParameters(Map<String, String> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (postData.length() != 0)
                    postData.append('&');
                if(encodeParams) postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                else postData.append(param.getKey());
                postData.append('=');
                if(encodeParams) postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
                else postData.append(param.getValue());
            }
            byte[] data = postData.toString().getBytes("UTF-8");

            //return params
            return data;

        } catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + PROTOCOL_CHARSET, uee);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> aux = null;
        if (params != null) {
            aux = params;
        } else {
            try {
                aux = super.getParams();
            } catch (AuthFailureError e) {
                Log.e(REQUEST_EXCEPTION, "Error en las cabeceras");
            }
        }

        return aux;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }


    public Response.Listener getListener() {
        return listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return path;
    }

    @Override
    public String getUrl() {
        if(url == null) url = configuration.getEnvironment() + path;
        if(getMethod() != Method.GET)
            return url;
        else
            return url+requestBody;
    }

    @Override
    public void cancel() {
        super.cancel();
        errorListener.onErrorResponse(new CancelError());
    }

    public String getDummyFileName() {
        if(dummyFileName == null) return getPath();
        return dummyFileName;
    }

    public void setDummyFileName(String dummyFileName) {
        this.dummyFileName = dummyFileName;
    }

    public boolean useDummyResponse() {
        return useDummyResponse;
    }

    public void setUseDummyResponse(boolean useDummyResponse) {
        this.useDummyResponse = useDummyResponse;
    }

    public boolean isEncodeParams() {
        return encodeParams;
    }

    public void setEncodeParams(boolean encodeParams) {
        this.encodeParams = encodeParams;
    }

    public void setConfiguration(WebServicesConfiguration configuration) {
        this.configuration = configuration;
    }

    public ResponseTransformer getResponseTransformer() {
        return responseTransformer;
    }

    public void setResponseTransformer(ResponseTransformer responseTransformer) {
        this.responseTransformer = responseTransformer;
    }
}