/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.Response;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class MultipartRequest
extends CustomRequest<String> {
    private final String twoHyphens = "--";
    private final String lineEnd = "\r\n";
    private final String boundary = "apiclient-" + System.currentTimeMillis();
    Map<String, DataPart> data;
    private String filePartName = "file";
    private String contentType = "image/jpg";

    public MultipartRequest(int method, String path, Response.Listener<String> listener, Response.ErrorListener errorListener, Map<String, DataPart> data) {
        super(method, path, "", listener, errorListener);
        this.setData(data);
    }

    public MultipartRequest(int method, String path, Response.Listener<String> listener, Response.ErrorListener errorListener, Map<String, DataPart> data, HashMap<String, String> params) {
        super(method, path, "", listener, errorListener);
        this.setData(data);
        this.setParams(params);
    }

    public MultipartRequest(int method, String environment, String path, Response.Listener<String> listener, Response.ErrorListener errorListener, Map<String, DataPart> data) {
        super(method, environment, path, "", listener, errorListener);
        this.setData(data);
    }

    public MultipartRequest(int method, String environment, String path, Response.Listener<String> listener, Response.ErrorListener errorListener, Map<String, DataPart> data, HashMap<String, String> params) {
        super(method, environment, path, "", listener, errorListener);
        this.setData(data);
        this.setParams(params);
    }

    public void setData(Map<String, DataPart> data) {
        this.data = data;
    }

    @Override
    public byte[] getBody() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            Map<String, String> params = this.getParams();
            if (params != null && params.size() > 0) {
                this.textParse(dos, params, this.getParamsEncoding());
            }
            if (this.data != null && this.data.size() > 0) {
                this.dataParse(dos, this.data);
            }
            dos.writeBytes("--" + this.boundary + "--" + "\r\n");
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBodyContentType() {
        return "multipart/form-data;boundary=" + this.boundary;
    }

    private void textParse(DataOutputStream dataOutputStream, Map<String, String> params, String encoding) throws IOException {
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                this.buildTextPart(dataOutputStream, entry.getKey(), entry.getValue());
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + encoding, uee);
        }
    }

    private void dataParse(DataOutputStream dataOutputStream, Map<String, DataPart> data) throws IOException {
        for (Map.Entry<String, DataPart> entry : data.entrySet()) {
            this.buildDataPart(dataOutputStream, entry.getValue(), entry.getKey());
        }
    }

    private void buildTextPart(DataOutputStream dataOutputStream, String parameterName, String parameterValue) throws IOException {
        dataOutputStream.writeBytes("--" + this.boundary + "\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + parameterName + "\"" + "\r\n");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.writeBytes(parameterValue + "\r\n");
    }

    private void buildDataPart(DataOutputStream dataOutputStream, DataPart dataFile, String inputName) throws IOException {
        dataOutputStream.writeBytes("--" + this.boundary + "\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + dataFile.getFileName() + "\"" + "\r\n");
        if (dataFile.getType() != null && !dataFile.getType().trim().isEmpty()) {
            dataOutputStream.writeBytes("Content-Type: " + dataFile.getType() + "\r\n");
        }
        dataOutputStream.writeBytes("\r\n");
        ByteArrayInputStream fileInputStream = new ByteArrayInputStream(dataFile.getContent());
        int bytesAvailable = fileInputStream.available();
        int maxBufferSize = 0x100000;
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        while (bytesRead > 0) {
            dataOutputStream.write(buffer, 0, bufferSize);
            bytesAvailable = fileInputStream.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        }
        dataOutputStream.writeBytes("\r\n");
    }

    public static class DataPart {
        private String fileName;
        private byte[] content = new byte[0];
        private String type;

        public DataPart() {
        }

        public DataPart(String name, byte[] data) {
            this.fileName = name;
            this.content = data;
        }

        public DataPart(String name, byte[] data, String mimeType) {
            this.fileName = name;
            this.content = data;
            this.type = mimeType;
        }

        public DataPart(String name, File data, String mimeType) {
            this.fileName = name;
            try {
                this.content = this.readFile(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.type = mimeType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFile(File file) throws IOException {
            try (RandomAccessFile f = new RandomAccessFile(file, "r");){
                long longlength = f.length();
                int length = (int)longlength;
                if ((long)length != longlength) {
                    throw new IOException("File size >= 2 GB");
                }
                byte[] data = new byte[length];
                f.readFully(data);
                byte[] byArray = data;
                return byArray;
            }
        }
    }
}

