/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Environment;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.Volley;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.webservicesmanager.LogDialog;
import com.tm.datamanager.webservicesmanager.certifieds.BaseCertified;
import com.tm.datamanager.webservicesmanager.certifieds.FakeX509TrustManager;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import com.tm.datamanager.webservicesmanager.requests.CustomRequestParallelList;
import com.tm.datamanager.webservicesmanager.requests.DummyRequestQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class WebServicesManager
implements RequestQueue.RequestFinishedListener {
    private Context context;
    private RequestQueue requestQueue;
    private BaseCertified certified;
    private LinkedList<Request> queue = new LinkedList();
    private ArrayList<RequestQueue> parallelRequestQueues = new ArrayList();
    static RequestQueue requestQueueInstance;
    WebServicesConfiguration configuration;

    public WebServicesManager(Context context, WebServicesConfiguration configuration, HashMap<String, String> dummyResponses) {
        this.context = context;
        this.configuration = configuration;
        if (dummyResponses != null) {
            DummyResponses.DUMMY_RESPONSES = dummyResponses;
        }
        this.selectEnvironment(DataManager.getPreferencesManagerInstance().getIntValue("ENVIRONMENT"));
        this.requestQueue = this.generateRequestQueue();
        if (configuration.isSHOW_REQUEST_LOGS_FILE()) {
            this.generateLogFile();
        }
        if (configuration.isSAVECOOKIES()) {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
    }

    public void showLog(Context context) {
        new LogDialog(context, this.configuration.bufferLog).show();
    }

    private void generateLogFile() {
        File root = Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + this.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, false);
            pw.append("");
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private RequestQueue generateRequestQueue() {
        if (this.configuration.isDUMMY()) {
            return new DummyRequestQueue(this.context);
        }
        if (requestQueueInstance == null) {
            requestQueueInstance = Volley.newRequestQueue((Context)this.context.getApplicationContext());
        }
        return requestQueueInstance;
    }

    public void onRequestFinished(Request request) {
        if (this.queue.size() != 0) {
            this.requestQueue.add(this.queue.removeFirst());
        }
    }

    public void addRequest(Request request, String tag) {
        if (request instanceof CustomRequest) {
            ((CustomRequest)request).setConfiguration(this.configuration);
        }
        if (((CustomRequest)request).useDummyResponse()) {
            new DummyRequestQueue(this.context).add(request);
        } else {
            request.setTag((Object)tag);
            this.configureRetryPolicy(request);
            if (request.getUrl().contains("https://")) {
                this.certified.allowAllSSL();
            }
            ((CustomRequest)request).printRequest();
            if (this.queue.size() == 0) {
                this.requestQueue.add(request);
            } else {
                this.queue.addLast(request);
            }
        }
    }

    public void addParallelRequest(Request request, String tag) {
        if (request instanceof CustomRequest) {
            ((CustomRequest)request).setConfiguration(this.configuration);
        }
        final RequestQueue requestQueue = this.generateRequestQueue();
        request.setTag((Object)tag);
        this.configureRetryPolicy(request);
        if (request.getUrl().contains("https://")) {
            this.certified.allowAllSSL();
        }
        ((CustomRequest)request).printRequest();
        requestQueue.add(request);
        requestQueue.addRequestFinishedListener((RequestQueue.RequestFinishedListener)new RequestQueue.RequestFinishedListener<Object>(){

            public void onRequestFinished(Request<Object> request) {
                WebServicesManager.this.parallelRequestQueues.remove(requestQueue);
            }
        });
        this.parallelRequestQueues.add(requestQueue);
    }

    public void addParallelRequestList(final CustomRequestParallelList requestList, String tag) {
        for (CustomRequest request : requestList) {
            request.setConfiguration(this.configuration);
            RequestQueue generatedRequest = this.configuration.isDUMMY() ? new DummyRequestQueue(this.context) : Volley.newRequestQueue((Context)this.context.getApplicationContext());
            final RequestQueue parallelrequestQueue = generatedRequest;
            request.setTag(tag);
            this.configureRetryPolicy((Request)request);
            request.printRequest();
            if (request.getUrl().contains("https://")) {
                this.certified.allowAllSSL();
            }
            parallelrequestQueue.addRequestFinishedListener((RequestQueue.RequestFinishedListener)new RequestQueue.RequestFinishedListener<Object>(){

                public void onRequestFinished(Request<Object> request) {
                    parallelrequestQueue.stop();
                    if (parallelrequestQueue.getCache() != null) {
                        parallelrequestQueue.getCache().clear();
                    }
                    WebServicesManager.this.parallelRequestQueues.remove(parallelrequestQueue);
                    requestList.finishRequest();
                }
            });
            this.parallelRequestQueues.add(parallelrequestQueue);
            parallelrequestQueue.add((Request)request);
        }
    }

    private void configureRetryPolicy(Request request) {
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(this.configuration.getTIMEOUT(), this.configuration.getATTEMPTS(), this.configuration.getBACKOFFMULTIPLIER()));
    }

    public void cancelRequest(String tag) {
        this.requestQueue.cancelAll((Object)tag);
        for (RequestQueue requestQueue : this.parallelRequestQueues) {
            requestQueue.cancelAll((Object)tag);
        }
        for (Request request : this.queue) {
            if (!request.getTag().equals(tag)) continue;
            this.queue.remove(request);
            break;
        }
    }

    public void configureEnvironment(final Context context, final OnEnvironmentSelectedListener onEnvironmentSelectedListener) {
        Object[] environmentNames = new String[]{"DUMMY"};
        if (this.configuration.getENVIRONMENTS_NAMES() != null) {
            environmentNames = new String[this.configuration.getENVIRONMENTS_NAMES().length + 1];
            environmentNames[0] = "DUMMY";
            for (int i = 0; i < this.configuration.getENVIRONMENTS_NAMES().length; ++i) {
                environmentNames[i + 1] = this.configuration.getENVIRONMENTS_NAMES()[i];
            }
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"ENVIRONMENTS");
        ArrayAdapter adapter = new ArrayAdapter(context, 17367058, environmentNames);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                WebServicesManager.this.selectEnvironment(i - 1);
                if (onEnvironmentSelectedListener != null) {
                    onEnvironmentSelectedListener.onEnvironmentSelected(WebServicesManager.this.configuration.getEnvironmentName());
                }
                Toast.makeText((Context)context, (CharSequence)WebServicesManager.this.configuration.getEnvironment(), (int)0).show();
            }
        });
        builder.create().show();
    }

    public void selectEnvironment(int i) {
        this.configuration.setDUMMY(i == -1);
        this.requestQueue = this.generateRequestQueue();
        this.configuration.setEnvironment(i == -1 ? "" : this.configuration.getENVIRONMENTS()[i]);
        this.configuration.setEnvironmentName(i == -1 ? "DUMMY" : this.configuration.getENVIRONMENTS_NAMES()[i]);
        DataManager.getPreferencesManagerInstance().setValue(i, "ENVIRONMENT");
        this.certified = this.configuration.getCertified() != null ? this.configuration.getCertified() : new FakeX509TrustManager();
    }

    public void setCertified(BaseCertified certified) {
        this.certified = certified;
    }

    public WebServicesConfiguration getConfiguration() {
        return this.configuration;
    }

    public static interface OnEnvironmentSelectedListener {
        public void onEnvironmentSelected(String var1);
    }
}

