/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.websocket;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.tm.datamanager.webservicesmanager.websocket.HybiParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;

public class WebSocketClient {
    private static final String TAG = "WebSocketClient";
    private static final int SWITCHING_PROTOCOLS_CODE = 101;
    private URI mURI;
    private Listener mListener;
    private Socket mSocket;
    private Thread mThread;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private List<BasicNameValuePair> mExtraHeaders;
    private HybiParser mParser;
    private final Object mSendLock = new Object();
    private static TrustManager[] sTrustManagers;

    public static void setTrustManagers(TrustManager[] tm) {
        sTrustManagers = tm;
    }

    public WebSocketClient(URI uri, Listener listener, List<BasicNameValuePair> extraHeaders) {
        this.mURI = uri;
        this.mListener = listener;
        this.mExtraHeaders = extraHeaders;
        this.mParser = new HybiParser(this);
        this.mHandlerThread = new HandlerThread("websocket-thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    public Listener getListener() {
        return this.mListener;
    }

    public void connect() {
        if (this.mThread != null && this.mThread.isAlive()) {
            return;
        }
        this.mThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    String path;
                    String secret = WebSocketClient.this.createSecret();
                    int port = WebSocketClient.this.mURI.getPort() != -1 ? WebSocketClient.this.mURI.getPort() : (WebSocketClient.this.mURI.getScheme().equals("wss") ? 443 : 80);
                    String string = path = TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getPath()) ? "/" : WebSocketClient.this.mURI.getPath();
                    if (!TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getQuery())) {
                        path = path + "?" + WebSocketClient.this.mURI.getQuery();
                    }
                    String originScheme = WebSocketClient.this.mURI.getScheme().equals("wss") ? "https" : "http";
                    URI origin = new URI(originScheme, "//" + WebSocketClient.this.mURI.getHost(), null);
                    SocketFactory factory = WebSocketClient.this.mURI.getScheme().equals("wss") ? WebSocketClient.this.getSSLSocketFactory() : SocketFactory.getDefault();
                    WebSocketClient.this.mSocket = factory.createSocket(WebSocketClient.this.mURI.getHost(), port);
                    PrintWriter out = new PrintWriter(WebSocketClient.this.mSocket.getOutputStream());
                    out.print("GET " + path + " HTTP/1.1\r\n");
                    out.print("Upgrade: websocket\r\n");
                    out.print("Connection: Upgrade\r\n");
                    out.print("Host: " + WebSocketClient.this.mURI.getHost() + "\r\n");
                    out.print("Origin: " + origin.toString() + "\r\n");
                    out.print("Sec-WebSocket-Key: " + secret + "\r\n");
                    out.print("Sec-WebSocket-Version: 13\r\n");
                    if (WebSocketClient.this.mExtraHeaders != null) {
                        for (NameValuePair pair : WebSocketClient.this.mExtraHeaders) {
                            out.print(String.format("%s: %s\r\n", pair.getName(), pair.getValue()));
                        }
                    }
                    out.print("\r\n");
                    out.flush();
                    HybiParser.HappyDataInputStream stream = new HybiParser.HappyDataInputStream(WebSocketClient.this.mSocket.getInputStream());
                    StatusLine statusLine = WebSocketClient.this.parseStatusLine(WebSocketClient.this.readLine(stream));
                    if (statusLine == null) {
                        throw new Exception("Received no reply from server.");
                    }
                    if (statusLine.getStatusCode() != 101) {
                        throw new Exception("Wrong status code: " + statusLine.getStatusCode());
                    }
                    boolean validated = false;
                    while (!TextUtils.isEmpty((CharSequence)(line = WebSocketClient.this.readLine(stream)))) {
                        String actual;
                        Header header = WebSocketClient.this.parseHeader(line);
                        if (!header.getName().equals("Sec-WebSocket-Accept")) continue;
                        String expected = WebSocketClient.this.createSecretValidation(secret);
                        if (!expected.equals(actual = header.getValue().trim())) {
                            throw new HttpException("Bad Sec-WebSocket-Accept header value.");
                        }
                        validated = true;
                    }
                    if (!validated) {
                        throw new HttpException("No Sec-WebSocket-Accept header.");
                    }
                    WebSocketClient.this.mListener.onConnect();
                    WebSocketClient.this.mParser.start(stream);
                }
                catch (EOFException ex) {
                    Log.d((String)WebSocketClient.TAG, (String)"WebSocket EOF!", (Throwable)ex);
                    WebSocketClient.this.mListener.onDisconnect(0, "EOF");
                }
                catch (SSLException ex) {
                    Log.d((String)WebSocketClient.TAG, (String)"Websocket SSL error!", (Throwable)ex);
                    WebSocketClient.this.mListener.onDisconnect(0, "SSL");
                }
                catch (Exception ex) {
                    WebSocketClient.this.mListener.onError(ex);
                }
            }
        });
        this.mThread.start();
    }

    public void disconnect() {
        if (this.mSocket != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketClient.this.mSocket.close();
                        WebSocketClient.this.mSocket = null;
                    }
                    catch (IOException ex) {
                        Log.d((String)WebSocketClient.TAG, (String)"Error while disconnecting", (Throwable)ex);
                        WebSocketClient.this.mListener.onError(ex);
                    }
                }
            });
        }
    }

    public void send(String data) {
        this.sendFrame(this.mParser.frame(data));
    }

    public void send(byte[] data) {
        this.sendFrame(this.mParser.frame(data));
    }

    private StatusLine parseStatusLine(String line) {
        if (TextUtils.isEmpty((CharSequence)line)) {
            return null;
        }
        return BasicLineParser.parseStatusLine((String)line, (LineParser)new BasicLineParser());
    }

    private Header parseHeader(String line) {
        return BasicLineParser.parseHeader((String)line, (LineParser)new BasicLineParser());
    }

    private String readLine(HybiParser.HappyDataInputStream reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuilder string = new StringBuilder("");
        while (readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            if ((readChar = reader.read()) != -1) continue;
            return null;
        }
        return string.toString();
    }

    private String createSecret() {
        byte[] nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            nonce[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeToString((byte[])nonce, (int)0).trim();
    }

    private String createSecretValidation(String secret) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update((secret + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes());
            return Base64.encodeToString((byte[])md.digest(), (int)0).trim();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    void sendFrame(final byte[] frame) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = WebSocketClient.this.mSendLock;
                    synchronized (object) {
                        if (WebSocketClient.this.mSocket == null) {
                            throw new IllegalStateException("Socket not connected");
                        }
                        OutputStream outputStream = WebSocketClient.this.mSocket.getOutputStream();
                        outputStream.write(frame);
                        outputStream.flush();
                    }
                }
                catch (IOException e) {
                    WebSocketClient.this.mListener.onError(e);
                }
            }
        });
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, sTrustManagers, null);
        return context.getSocketFactory();
    }

    public static interface Listener {
        public void onConnect();

        public void onMessage(String var1);

        public void onMessage(byte[] var1);

        public void onDisconnect(int var1, String var2);

        public void onError(Exception var1);
    }
}

