/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import android.os.Environment;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.error.CancelError;
import com.tm.datamanager.webservicesmanager.formatters.Formatter;
import com.tm.datamanager.webservicesmanager.requests.MultipartRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONException;

public class CustomRequest<T>
extends JsonRequest<T> {
    private Map<String, String> headers;
    private Map<String, String> params;
    private Response.Listener listener;
    private String path;
    private String requestBody;
    private Response.ErrorListener errorListener;
    private Request.Priority priority;
    private static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    private static final String RESPONSE = "response";
    private boolean useDummyResponse = false;
    private String dummyFileName;

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, WebServicesManager.configuration.getEnvironment() + path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, WebServicesManager.configuration.getEnvironment() + path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    protected void deliverResponse(T response) {
        if (response != null) {
            this.listener.onResponse(response);
        }
    }

    public void deliverError(VolleyError error) {
        this.errorListener.onErrorResponse(error);
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        volleyError.printStackTrace();
        String error = "";
        VolleyError parseError = null;
        if (volleyError.getMessage() != null) {
            error = volleyError.getMessage();
            parseError = WebServicesManager.configuration.checkError(error);
        } else if (volleyError.networkResponse != null && volleyError.networkResponse.data != null) {
            error = new String(volleyError.networkResponse.data);
            parseError = WebServicesManager.configuration.checkError(error);
        } else if (volleyError.networkResponse != null) {
            error = volleyError.networkResponse.statusCode + "";
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)"ERROR: ");
            this.printLog(error);
            DataManager.getWebServicesManagerInstance().addToBufferLog(error, "RESPONSE ERROR", super.getUrl());
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
            CustomRequest.writeLogInFile("ERROR:  " + error);
        }
        if (parseError != null) {
            return parseError;
        }
        return new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        try {
            VolleyError volleyError;
            String responseData = WebServicesManager.configuration.getResponseCodification() == null ? new String(response.data) : new String(response.data, WebServicesManager.configuration.getResponseCodification());
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
                Log.e((String)"DATAMANAGER", (String)"RESPONSE: ");
                this.printLog(this.path + " " + responseData);
                DataManager.getWebServicesManagerInstance().addToBufferLog(responseData, "RESPONSE", super.getUrl());
            }
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
                CustomRequest.writeLogInFile("RESPONSE: " + this.path + " " + responseData);
            }
            if ((volleyError = WebServicesManager.configuration.checkError(responseData)) != null) {
                return Response.error((VolleyError)volleyError);
            }
            return Response.success((Object)this.parseResponse(responseData), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((VolleyError)new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE()));
        }
    }

    public void printRequest() {
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)"REQUEST: ");
            if (!(this instanceof MultipartRequest)) {
                this.printLog(this.path + new String(this.getBody()));
                DataManager.getWebServicesManagerInstance().addToBufferLog(new String(this.getBody()), "REQUEST", super.getUrl());
            }
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE() && !(this instanceof MultipartRequest)) {
            CustomRequest.writeLogInFile("REQUEST: " + this.path + new String(this.getBody()));
        }
    }

    public void printLog(String log) {
        log = Formatter.toPrettyString(log);
        int cont = 0;
        do {
            Log.e((String)"DATAMANAGER", (String)log.substring(cont, cont + 4000 >= log.length() ? log.length() : cont + 4000));
        } while ((cont += 4000) < log.length());
    }

    public void bridgeToParseNetWorkResponse(NetworkResponse networkResponse) {
        Response<T> response = this.parseNetworkResponse(networkResponse);
        if (response.error != null) {
            this.deliverError(response.error);
        } else {
            this.deliverResponse(response.result);
        }
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    public static void writeLogInFile(String text) {
        File root = Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + WebServicesManager.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Request.Priority getPriority() {
        if (this.priority == null) {
            return super.getPriority();
        }
        return this.priority;
    }

    public Map<String, String> getHeaders() {
        Map aux = null;
        try {
            aux = this.headers != null ? this.headers : super.getHeaders();
        }
        catch (Exception a) {
            aux = null;
        }
        return aux;
    }

    public byte[] getBody() {
        if (this.getParams() != null) {
            return this.encodeParameters(this.getParams());
        }
        try {
            return this.requestBody == null ? null : this.requestBody.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    private byte[] encodeParameters(Map<String, String> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] data = postData.toString().getBytes("UTF-8");
            return data;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: utf-8", uee);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getParams() {
        Map aux = null;
        if (this.params != null) {
            aux = this.params;
        } else {
            try {
                aux = super.getParams();
            }
            catch (AuthFailureError e) {
                Log.e((String)REQUEST_EXCEPTION, (String)"Error en las cabeceras");
            }
        }
        return aux;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Response.Listener getListener() {
        return this.listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        if (this.getMethod() != 0) {
            return super.getUrl();
        }
        return super.getUrl() + this.requestBody;
    }

    public void cancel() {
        super.cancel();
        this.errorListener.onErrorResponse((VolleyError)new CancelError());
    }

    public String getDummyFileName() {
        if (this.dummyFileName == null) {
            return this.getPath();
        }
        return this.dummyFileName;
    }

    public void setDummyFileName(String dummyFileName) {
        this.dummyFileName = dummyFileName;
    }

    public boolean useDummyResponse() {
        return this.useDummyResponse;
    }

    public void setUseDummyResponse(boolean useDummyResponse) {
        this.useDummyResponse = useDummyResponse;
    }
}

