/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;
import java.util.Vector;

/*     */
/*     */
/*     */
/*     */

/*     */
/*     */ public class Element extends Node
/*     */ {
/*     */   protected String namespace;
/*     */   protected String name;
/*     */   protected Vector attributes;
/*     */   protected Node parent;
/*     */   protected Vector prefixes;
/*     */ 
/*     */   public void init()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  59 */     this.attributes = null;
/*  60 */     this.children = null;
/*     */   }
/*     */ 
/*     */   public Element createElement(String namespace, String name)
/*     */   {
/*  71 */     return this.parent == null ? super.createElement(namespace, name) : this.parent.createElement(namespace, name);
/*     */   }
/*     */ 
/*     */   public int getAttributeCount()
/*     */   {
/*  80 */     return this.attributes == null ? 0 : this.attributes.size();
/*     */   }
/*     */ 
/*     */   public String getAttributeNamespace(int index) {
/*  84 */     return ((String[])(String[])this.attributes.elementAt(index))[0];
/*     */   }
/*     */ 
/*     */   public String getAttributeName(int index)
/*     */   {
/*  92 */     return ((String[])(String[])this.attributes.elementAt(index))[1];
/*     */   }
/*     */ 
/*     */   public String getAttributeValue(int index)
/*     */   {
/*  97 */     return ((String[])(String[])this.attributes.elementAt(index))[2];
/*     */   }
/*     */ 
/*     */   public String getAttributeValue(String namespace, String name)
/*     */   {
/* 102 */     for (int i = 0; i < getAttributeCount(); i++) {
/* 103 */       if ((name.equals(getAttributeName(i))) && ((namespace == null) || (namespace.equals(getAttributeNamespace(i)))))
/*     */       {
/* 105 */         return getAttributeValue(i);
/*     */       }
/*     */     }
/* 108 */     return null;
/*     */   }
/*     */ 
/*     */   public Node getRoot()
/*     */   {
/* 117 */     Element current = this;
/*     */ 
/* 119 */     while (current.parent != null) {
/* 120 */       if (!(current.parent instanceof Element)) return current.parent;
/* 121 */       current = (Element)current.parent;
/*     */     }
/*     */ 
/* 124 */     return current;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 131 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getNamespace()
/*     */   {
/* 138 */     return this.namespace;
/*     */   }
/*     */ 
/*     */   public String getNamespaceUri(String prefix)
/*     */   {
/* 146 */     int cnt = getNamespaceCount();
/* 147 */     for (int i = 0; i < cnt; i++)
/* 148 */       if ((prefix == getNamespacePrefix(i)) || ((prefix != null) && (prefix.equals(getNamespacePrefix(i)))))
/*     */       {
/* 150 */         return getNamespaceUri(i);
/*     */       }
/* 152 */     return (this.parent instanceof Element) ? ((Element)this.parent).getNamespaceUri(prefix) : null;
/*     */   }
/*     */ 
/*     */   public int getNamespaceCount()
/*     */   {
/* 161 */     return this.prefixes == null ? 0 : this.prefixes.size();
/*     */   }
/*     */ 
/*     */   public String getNamespacePrefix(int i)
/*     */   {
/* 166 */     return ((String[])(String[])this.prefixes.elementAt(i))[0];
/*     */   }
/*     */ 
/*     */   public String getNamespaceUri(int i) {
/* 170 */     return ((String[])(String[])this.prefixes.elementAt(i))[1];
/*     */   }
/*     */ 
/*     */   public Node getParent()
/*     */   {
/* 178 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void parse(XmlPullParser parser)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 199 */     for (int i = parser.getNamespaceCount(parser.getDepth() - 1); 
/* 200 */       i < parser.getNamespaceCount(parser.getDepth()); i++) {
/* 201 */       setPrefix(parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
/*     */     }
/*     */ 
/* 205 */     for (int i = 0; i < parser.getAttributeCount(); i++) {
/* 206 */       setAttribute(parser.getAttributeNamespace(i), parser.getAttributeName(i), parser.getAttributeValue(i));
/*     */     }
/*     */ 
/* 214 */     init();
/*     */ 
/* 217 */     if (parser.isEmptyElementTag()) {
/* 218 */       parser.nextToken();
/*     */     } else {
/* 220 */       parser.nextToken();
/* 221 */       super.parse(parser);
/*     */ 
/* 223 */       if (getChildCount() == 0) {
/* 224 */         addChild(7, "");
/*     */       }
/*     */     }
/* 227 */     parser.require(3, getNamespace(), getName());
/*     */ 
/* 232 */     parser.nextToken();
/*     */   }
/*     */ 
/*     */   public void setAttribute(String namespace, String name, String value)
/*     */   {
/* 240 */     if (this.attributes == null) {
/* 241 */       this.attributes = new Vector();
/*     */     }
/* 243 */     if (namespace == null) {
/* 244 */       namespace = "";
/*     */     }
/* 246 */     for (int i = this.attributes.size() - 1; i >= 0; i--) {
/* 247 */       String[] attribut = (String[])this.attributes.elementAt(i);
/* 248 */       if ((attribut[0].equals(namespace)) && (attribut[1].equals(name)))
/*     */       {
/* 251 */         if (value == null) {
/* 252 */           this.attributes.removeElementAt(i);
/*     */         }
/*     */         else {
/* 255 */           attribut[2] = value;
/*     */         }
/* 257 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 261 */     this.attributes.addElement(new String[] { namespace, name, value });
/*     */   }
/*     */ 
/*     */   public void setPrefix(String prefix, String namespace)
/*     */   {
/* 271 */     if (this.prefixes == null) this.prefixes = new Vector();
/* 272 */     this.prefixes.addElement(new String[] { prefix, namespace });
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 280 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public void setNamespace(String namespace)
/*     */   {
/* 290 */     if (namespace == null)
/* 291 */       throw new NullPointerException("Use \"\" for empty namespace");
/* 292 */     this.namespace = namespace;
/*     */   }
/*     */ 
/*     */   protected void setParent(Node parent)
/*     */   {
/* 302 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public void write(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 312 */     if (this.prefixes != null) {
/* 313 */       for (int i = 0; i < this.prefixes.size(); i++) {
/* 314 */         writer.setPrefix(getNamespacePrefix(i), getNamespaceUri(i));
/*     */       }
/*     */     }
/*     */ 
/* 318 */     writer.startTag(getNamespace(), getName());
/*     */ 
/* 322 */     int len = getAttributeCount();
/*     */ 
/* 324 */     for (int i = 0; i < len; i++) {
/* 325 */       writer.attribute(getAttributeNamespace(i), getAttributeName(i), getAttributeValue(i));
/*     */     }
/*     */ 
/* 331 */     writeChildren(writer);
/*     */ 
/* 333 */     writer.endTag(getNamespace(), getName());
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.kxml2.kdom.Element
 * JD-Core Version:    0.6.2
 */