package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Response;
import com.android.volley.VolleyLog;

import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.CharsetUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

/**
 * Created by Navas on 19/7/16.
 */
public class MultipartRequest extends CustomRequest<String> {

    MultipartEntityBuilder entity = MultipartEntityBuilder.create();
    HttpEntity httpentity;
    private String FILE_PART_NAME = "file";
    private String contentType = "image/jpg";
    private final File file;

    public MultipartRequest(int method, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, File file) {
        super(method, path, requestBody, listener, errorListener);
        this.file = file;
        generateRequest();
    }

    public MultipartRequest(int method, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, Priority priority, File file) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.file = file;
        generateRequest();
    }

    public MultipartRequest(int method, String environment, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, File file) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.file = file;
        generateRequest();
    }

    public MultipartRequest(int method, String environment, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, Priority priority, File file) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.file = file;
        generateRequest();
    }

    private void generateRequest(){
        entity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            entity.setCharset(CharsetUtils.get("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buildMultipartEntity();
        httpentity = entity.build();
    }

    private void buildMultipartEntity() {
        entity.addPart(FILE_PART_NAME, new FileBody(file, ContentType.create(contentType), file.getName()));
//        if (mStringPart != null) {
//            for (Map.Entry<String, String> entry : mStringPart.entrySet()) {
//                entity.addTextBody(entry.getKey(), entry.getValue());
//            }
//        }
    }

    @Override
    public String getBodyContentType() {
        return httpentity.getContentType().getValue();
    }

    public void setFILE_PART_NAME(String FILE_PART_NAME) {
        this.FILE_PART_NAME = FILE_PART_NAME;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public byte[] getBody() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            httpentity.writeTo(new CountingOutputStream(bos, file.length(),
                    null));
        } catch (IOException e) {
            VolleyLog.e("IOException writing to ByteArrayOutputStream");
        }
        return bos.toByteArray();
    }

    public static interface MultipartProgressListener {
        void transferred(long transfered, int progress);
    }

    public static class CountingOutputStream extends FilterOutputStream {
        private final MultipartProgressListener progListener;
        private long transferred;
        private long fileLength;

        public CountingOutputStream(final OutputStream out, long fileLength,
                                    final MultipartProgressListener listener) {
            super(out);
            this.fileLength = fileLength;
            this.progListener = listener;
            this.transferred = 0;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            out.write(b, off, len);
            if (progListener != null) {
                this.transferred += len;
                int prog = (int) (transferred * 100 / fileLength);
                this.progListener.transferred(this.transferred, prog);
            }
        }

        public void write(int b) throws IOException {
            out.write(b);
            if (progListener != null) {
                this.transferred++;
                int prog = (int) (transferred * 100 / fileLength);
                this.progListener.transferred(this.transferred, prog);
            }
        }

    }

}
