package com.tm.datamanager.webservicesmanager;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.webservicesmanager.certifieds.BaseCertified;
import com.tm.datamanager.webservicesmanager.certifieds.FakeX509TrustManager;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import com.tm.datamanager.webservicesmanager.formatters.Formatter;
import com.tm.datamanager.webservicesmanager.formatters.JSONFormatter;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import com.tm.datamanager.webservicesmanager.requests.CustomRequestParallelList;
import com.tm.datamanager.webservicesmanager.requests.DummyRequestQueue;
import com.tm.datamanager.webservicesmanager.formatters.XMLFormatter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;


/**
 * Created by Navas on 19/06/15
 * This class manage the web call services.
 */
public class WebServicesManager implements RequestQueue.RequestFinishedListener{

    private Context context;

    // This is the principal request queue, only there will be an only instance of this queue
    private RequestQueue requestQueue;

    // Certified to applicate in HTTPS request
    private BaseCertified certified;

    private LinkedList<Request> queue = new LinkedList<>();

    // This list contains the call that will be called in parallel
    private ArrayList<RequestQueue> parallelRequestQueues = new ArrayList<RequestQueue>();

    static RequestQueue requestQueueInstance;


    public static WebServicesConfiguration configuration;

    public StringBuffer bufferLog = new StringBuffer();

    public WebServicesManager(Context context, WebServicesConfiguration configuration, HashMap<String, String> dummyResponses){
        this.context = context;
        this.configuration = configuration;
        if(dummyResponses != null) {
            DummyResponses.DUMMY_RESPONSES = dummyResponses;
        }
        // Load the last environment selected
        selectEnvironment(DataManager.getPreferencesManagerInstance().getIntValue("ENVIRONMENT"));
        requestQueue = generateRequestQueue();
        if(configuration.isSHOW_REQUEST_LOGS_FILE()) {
            generateLogFile();
        }
        if(configuration.isSAVECOOKIES())
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    public void showLog(Context context){
        new LogDialog(context,bufferLog).show();
    }

    public void addToBufferLog(String data, String title, String url){
        bufferLog.append(new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").format(new Date()) + "\n");
        bufferLog.append(url + "\n");
        bufferLog.append(title+"\n");
        data = Formatter.toPrettyString(data);
        bufferLog.append(data+"\n\n\n");
    }

    private void generateLogFile(){
        File root = android.os.Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, false);
            pw.append("");
            pw.flush();
            pw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * It check if the app has enabled dummy mode to return a custom requestqueue that return dummy
     * responses
     * @return
     */
    private RequestQueue generateRequestQueue(){
        if(configuration.isDUMMY())
            return new DummyRequestQueue(context);
        else
            if(requestQueueInstance == null)
                requestQueueInstance = Volley.newRequestQueue(context.getApplicationContext());
        return requestQueueInstance;
    }

    /**
     * When a Request finishes, it throws the next request in the queue
     */
    @Override
    public void onRequestFinished(Request request) {
        if(queue.size() != 0) requestQueue.add(queue.removeFirst());
    }

    /**
     * Add a request to the principal request queue
     * @param request request for add to the queue
     * @param tag tag to identify the request
     */
    public void addRequest(Request request, String tag){
        if(((CustomRequest)request).useDummyResponse()){
            new DummyRequestQueue(context).add(request);
        }else {
            request.setTag(tag);
            configureRetryPolicy(request);
            if (request.getUrl().contains("https://")) certified.allowAllSSL();
            ((CustomRequest) request).printRequest();
            if (queue.size() == 0) requestQueue.add(request);
            else queue.addLast(request);
        }

    }

    /**
     * When you add a parallel request, this will not be added to the principal queue, by these reason
     * all parallel request that will be added will launched in other threads
     * @param request request for add to the queue
     * @param tag tag to identify the request
     */
    public void addParallelRequest(Request request, String tag){
        final RequestQueue requestQueue = generateRequestQueue();
        request.setTag(tag);
        configureRetryPolicy(request);
        if(request.getUrl().contains("https://")) certified.allowAllSSL();
        ((CustomRequest)request).printRequest();
        requestQueue.add(request);
        requestQueue.addRequestFinishedListener(new RequestQueue.RequestFinishedListener<Object>() {
            @Override
            public void onRequestFinished(Request<Object> request) {
                parallelRequestQueues.remove(requestQueue);
            }
        });
        parallelRequestQueues.add(requestQueue);
    }

    public void addParallelRequestList(final CustomRequestParallelList requestList, String tag){
        for(CustomRequest request : requestList) {
            RequestQueue generatedRequest;
            if(configuration.isDUMMY())
                generatedRequest =  new DummyRequestQueue(context);
            else
                generatedRequest = Volley.newRequestQueue(context.getApplicationContext());
            final RequestQueue parallelrequestQueue = generatedRequest;
            request.setTag(tag);
            configureRetryPolicy(request);
            request.printRequest();
            parallelrequestQueue.add(request);
            if(request.getUrl().contains("https://")) certified.allowAllSSL();
            parallelrequestQueue.addRequestFinishedListener(new RequestQueue.RequestFinishedListener<Object>() {
                @Override
                public void onRequestFinished(Request<Object> request) {
                    parallelrequestQueue.stop();
                    parallelrequestQueue.getCache().clear();
                    parallelRequestQueues.remove(parallelrequestQueue);
                    requestList.finishRequest();
                }
            });
            parallelRequestQueues.add(parallelrequestQueue);
        }
    }

    /**
     * It set default RetryPolicy to the request if it hasn't
     * @param request
     */
    private void configureRetryPolicy(Request request){
//        if(request.getRetryPolicy() == null){
        request.setRetryPolicy(new DefaultRetryPolicy(configuration.getTIMEOUT(),
                configuration.getATTEMPTS(),
                configuration.getBACKOFFMULTIPLIER()));
//        }
    }

    /**
     * Cancel the request by his tag
     * @param tag to identify the request on the queue
     */
    public void cancelRequest(String tag){
        requestQueue.cancelAll(tag);
        for(RequestQueue requestQueue : parallelRequestQueues)
            requestQueue.cancelAll(tag);
        for(Request request : queue)
            if(request.getTag().equals(tag)){
                queue.remove(request);
                break;
            }
    }

    /**
     * Show a dialog for select the environment
     * @param context
     */
    public void configureEnvironment(final Context context,final OnEnvironmentSelectedListener onEnvironmentSelectedListener){
        String[] environmentNames = {"DUMMY"};
        if(configuration.getENVIRONMENTS_NAMES() != null){
            environmentNames = new String[configuration.getENVIRONMENTS_NAMES().length+1];
            environmentNames[0] = "DUMMY";
            for(int i = 0; i < configuration.getENVIRONMENTS_NAMES().length;i++)
                environmentNames[i+1] = configuration.getENVIRONMENTS_NAMES()[i];
        }

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle("ENVIRONMENTS");
        final ArrayAdapter<String> adapter = new ArrayAdapter<String>(context, android.R.layout.select_dialog_singlechoice,environmentNames);
        builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                selectEnvironment(i-1);
                if(onEnvironmentSelectedListener != null)
                    onEnvironmentSelectedListener.onEnvironmentSelected(configuration.getEnvironmentName());
                Toast.makeText(context, configuration.getEnvironment(), Toast.LENGTH_SHORT).show();
            }
        });
        builder.create().show();
    }

    public void selectEnvironment(int i) {
        configuration.setDUMMY(i == -1);
        requestQueue = generateRequestQueue();
        configuration.setEnvironment(i == -1 ? "" : configuration.getENVIRONMENTS()[i]);
        configuration.setEnvironmentName(i == -1 ? "DUMMY" : configuration.getENVIRONMENTS_NAMES()[i]);
        DataManager.getPreferencesManagerInstance().setValue(i, "ENVIRONMENT");
        this.certified = configuration.getCertified() != null ? configuration.getCertified() : new FakeX509TrustManager();
    }

    public interface OnEnvironmentSelectedListener{
        void onEnvironmentSelected(String environmentName);
    }

    public void setCertified(BaseCertified certified) {
        this.certified = certified;
    }
}
