/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.CharsetUtils;

public class MultipartRequest
extends CustomRequest<String> {
    MultipartEntityBuilder entity = MultipartEntityBuilder.create();
    HttpEntity httpentity;
    private String FILE_PART_NAME = "file";
    private String contentType = "image/jpg";
    private final File file;

    public MultipartRequest(int method, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, File file) {
        super(method, path, requestBody, listener, errorListener);
        this.file = file;
        this.generateRequest();
    }

    public MultipartRequest(int method, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, Request.Priority priority, File file) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.file = file;
        this.generateRequest();
    }

    public MultipartRequest(int method, String environment, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, File file) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.file = file;
        this.generateRequest();
    }

    public MultipartRequest(int method, String environment, String path, String requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, Request.Priority priority, File file) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.file = file;
        this.generateRequest();
    }

    private void generateRequest() {
        this.entity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            this.entity.setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.buildMultipartEntity();
        this.httpentity = this.entity.build();
    }

    private void buildMultipartEntity() {
        this.entity.addPart(this.FILE_PART_NAME, (ContentBody)new FileBody(this.file, ContentType.create((String)this.contentType), this.file.getName()));
    }

    public String getBodyContentType() {
        return this.httpentity.getContentType().getValue();
    }

    public void setFILE_PART_NAME(String FILE_PART_NAME) {
        this.FILE_PART_NAME = FILE_PART_NAME;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public byte[] getBody() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.httpentity.writeTo((OutputStream)new CountingOutputStream(bos, this.file.length(), null));
        }
        catch (IOException e) {
            VolleyLog.e((String)"IOException writing to ByteArrayOutputStream", (Object[])new Object[0]);
        }
        return bos.toByteArray();
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final MultipartProgressListener progListener;
        private long transferred;
        private long fileLength;

        public CountingOutputStream(OutputStream out, long fileLength, MultipartProgressListener listener) {
            super(out);
            this.fileLength = fileLength;
            this.progListener = listener;
            this.transferred = 0L;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            if (this.progListener != null) {
                this.transferred += (long)len;
                int prog = (int)(this.transferred * 100L / this.fileLength);
                this.progListener.transferred(this.transferred, prog);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            if (this.progListener != null) {
                ++this.transferred;
                int prog = (int)(this.transferred * 100L / this.fileLength);
                this.progListener.transferred(this.transferred, prog);
            }
        }
    }

    public static interface MultipartProgressListener {
        public void transferred(long var1, int var3);
    }
}

