/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;
import java.util.Vector;

/*     */
/*     */
/*     */
/*     */

/*     */
/*     */ public class Node
/*     */ {
/*     */   public static final int DOCUMENT = 0;
/*     */   public static final int ELEMENT = 2;
/*     */   public static final int TEXT = 4;
/*     */   public static final int CDSECT = 5;
/*     */   public static final int ENTITY_REF = 6;
/*     */   public static final int IGNORABLE_WHITESPACE = 7;
/*     */   public static final int PROCESSING_INSTRUCTION = 8;
/*     */   public static final int COMMENT = 9;
/*     */   public static final int DOCDECL = 10;
/*     */   protected Vector children;
/*     */   protected StringBuffer types;
/*     */ 
/*     */   public void addChild(int index, int type, Object child)
/*     */   {
/*  49 */     if (child == null) {
/*  50 */       throw new NullPointerException();
/*     */     }
/*  52 */     if (this.children == null) {
/*  53 */       this.children = new Vector();
/*  54 */       this.types = new StringBuffer();
/*     */     }
/*     */ 
/*  57 */     if (type == 2) {
/*  58 */       if (!(child instanceof Element)) {
/*  59 */         throw new RuntimeException("Element obj expected)");
/*     */       }
/*  61 */       ((Element)child).setParent(this);
/*     */     }
/*  63 */     else if (!(child instanceof String)) {
/*  64 */       throw new RuntimeException("String expected");
/*     */     }
/*  66 */     this.children.insertElementAt(child, index);
/*  67 */     this.types.insert(index, (char)type);
/*     */   }
/*     */ 
/*     */   public void addChild(int type, Object child)
/*     */   {
/*  73 */     addChild(getChildCount(), type, child);
/*     */   }
/*     */ 
/*     */   public Element createElement(String namespace, String name)
/*     */   {
/*  86 */     Element e = new Element();
/*  87 */     e.namespace = (namespace == null ? "" : namespace);
/*  88 */     e.name = name;
/*  89 */     return e;
/*     */   }
/*     */ 
/*     */   public Object getChild(int index)
/*     */   {
/*  97 */     return this.children.elementAt(index);
/*     */   }
/*     */ 
/*     */   public int getChildCount()
/*     */   {
/* 103 */     return this.children == null ? 0 : this.children.size();
/*     */   }
/*     */ 
/*     */   public Element getElement(int index)
/*     */   {
/* 110 */     Object child = getChild(index);
/* 111 */     return (child instanceof Element) ? (Element)child : null;
/*     */   }
/*     */ 
/*     */   public Element getElement(String namespace, String name)
/*     */   {
/* 120 */     int i = indexOf(namespace, name, 0);
/* 121 */     int j = indexOf(namespace, name, i + 1);
/*     */ 
/* 123 */     if ((i == -1) || (j != -1)) {
/* 124 */       throw new RuntimeException(new StringBuilder().append("Element {").append(namespace).append("}").append(name).append(i == -1 ? " not found in " : " more than once in ").append(this).toString());
/*     */     }
/*     */ 
/* 132 */     return getElement(i);
/*     */   }
/*     */ 
/*     */   public String getText(int index)
/*     */   {
/* 175 */     return isText(index) ? (String)getChild(index) : null;
/*     */   }
/*     */ 
/*     */   public int getType(int index)
/*     */   {
/* 182 */     return this.types.charAt(index);
/*     */   }
/*     */ 
/*     */   public int indexOf(String namespace, String name, int startIndex)
/*     */   {
/* 200 */     int len = getChildCount();
/*     */ 
/* 202 */     for (int i = startIndex; i < len; i++)
/*     */     {
/* 204 */       Element child = getElement(i);
/*     */ 
/* 206 */       if ((child != null) && (name.equals(child.getName())) && ((namespace == null) || (namespace.equals(child.getNamespace()))))
/*     */       {
/* 209 */         return i;
/*     */       }
/*     */     }
/* 211 */     return -1;
/*     */   }
/*     */ 
/*     */   public boolean isText(int i) {
/* 215 */     int t = getType(i);
/* 216 */     return (t == 4) || (t == 7) || (t == 5);
/*     */   }
/*     */ 
/*     */   public void parse(XmlPullParser parser)
/*     */     throws IOException, XmlPullParserException
/*     */   {
/* 226 */     boolean leave = false;
/*     */     do
/*     */     {
/* 229 */       int type = parser.getEventType();
/*     */ 
/* 233 */       switch (type)
/*     */       {
/*     */       case 2:
/* 237 */         Element child = createElement(parser.getNamespace(), parser.getName());
/*     */ 
/* 242 */         addChild(2, child);
/*     */ 
/* 247 */         child.parse(parser);
/* 248 */         break;
/*     */       case 1:
/*     */       case 3:
/* 253 */         leave = true;
/* 254 */         break;
/*     */       default:
/* 257 */         if (parser.getText() != null) {
/* 258 */           addChild(type == 6 ? 4 : type, parser.getText());
/*     */         }
/* 261 */         else if ((type == 6) && (parser.getName() != null))
/*     */         {
/* 264 */           addChild(6, parser.getName());
/*     */         }
/* 266 */         parser.nextToken();
/*     */       }
/*     */     }
/* 269 */     while (!leave);
/*     */   }
/*     */ 
/*     */   public void removeChild(int idx)
/*     */   {
/* 275 */     this.children.removeElementAt(idx);
/*     */ 
/* 280 */     int n = this.types.length() - 1;
/*     */ 
/* 282 */     for (int i = idx; i < n; i++) {
/* 283 */       this.types.setCharAt(i, this.types.charAt(i + 1));
/*     */     }
/* 285 */     this.types.setLength(n);
/*     */   }
/*     */ 
/*     */   public void write(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 313 */     writeChildren(writer);
/* 314 */     writer.flush();
/*     */   }
/*     */ 
/*     */   public void writeChildren(XmlSerializer writer)
/*     */     throws IOException
/*     */   {
/* 320 */     if (this.children == null) {
/* 321 */       return;
/*     */     }
/* 323 */     int len = this.children.size();
/*     */ 
/* 325 */     for (int i = 0; i < len; i++) {
/* 326 */       int type = getType(i);
/* 327 */       Object child = this.children.elementAt(i);
/* 328 */       switch (type) {
/*     */       case 2:
/* 330 */         ((Element)child).write(writer);
/* 331 */         break;
/*     */       case 4:
/* 334 */         writer.text((String)child);
/* 335 */         break;
/*     */       case 7:
/* 338 */         writer.ignorableWhitespace((String)child);
/* 339 */         break;
/*     */       case 5:
/* 342 */         writer.cdsect((String)child);
/* 343 */         break;
/*     */       case 9:
/* 346 */         writer.comment((String)child);
/* 347 */         break;
/*     */       case 6:
/* 350 */         writer.entityRef((String)child);
/* 351 */         break;
/*     */       case 8:
/* 354 */         writer.processingInstruction((String)child);
/* 355 */         break;
/*     */       case 10:
/* 358 */         writer.docdecl((String)child);
/* 359 */         break;
/*     */       case 3:
/*     */       default:
/* 362 */         throw new RuntimeException(new StringBuilder().append("Illegal type: ").append(type).toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.kxml2.kdom.Node
 * JD-Core Version:    0.6.2
 */