/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import android.util.Xml;
import com.android.volley.Request;
import com.android.volley.Response;
import com.google.gson.Gson;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import com.tm.datamanager.webservicesmanager.soap.SoapObject;
import com.tm.datamanager.webservicesmanager.soap.SoapResponse;
import com.tm.datamanager.webservicesmanager.soap.SoapSerializationEnvelope;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;

public class CustomSoapObjectRequest<T extends SoapResponse>
extends CustomRequest<T> {
    private final Gson gson = new Gson();
    private Class<T> clazz;

    public CustomSoapObjectRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomSoapObjectRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    @Override
    protected Object parseResponse(String response) {
        try {
            SoapObject soapObject = CustomSoapObjectRequest.stringToSoapObject(response);
            SoapResponse responseObject = (SoapResponse)this.clazz.newInstance();
            responseObject.parse(soapObject);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoapObject stringToSoapObject(String response) throws Exception {
        SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
        SoapObject soap = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes());
            XmlPullParser p = Xml.newPullParser();
            p.setInput((InputStream)inputStream, "UTF-8");
            envelope.parse(p);
            soap = (SoapObject)envelope.bodyIn;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return soap;
    }
}

