/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import android.util.Xml;
import com.android.volley.Request;
import com.android.volley.Response;
import com.google.gson.Gson;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import com.tm.datamanager.webservicesmanager.soap.SoapObject;
import com.tm.datamanager.webservicesmanager.soap.SoapSerializationEnvelope;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.json.JSONException;
import org.json.XML;
import org.xmlpull.v1.XmlPullParser;

public class CustomSoapRequest<T>
extends CustomRequest<T> {
    private final Gson gson = new Gson();
    private Class<T> clazz;
    String rootLabel = "methodResult";

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz, String rootLabel) {
        super(method, path, requestBody, listener, errorListener);
        this.clazz = clazz;
        if (rootLabel != null) {
            this.rootLabel = rootLabel;
        }
    }

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority, Class<T> clazz, String rootLabel) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
        if (rootLabel != null) {
            this.rootLabel = rootLabel;
        }
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz, String rootLabel) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.clazz = clazz;
        if (rootLabel != null) {
            this.rootLabel = rootLabel;
        }
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority, Class<T> clazz, String rootLabel) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
        if (rootLabel != null) {
            this.rootLabel = rootLabel;
        }
    }

    @Override
    protected Object parseResponse(String response) {
        String initLabel = "<" + this.rootLabel + ">";
        String endLabel = "</" + this.rootLabel + ">";
        String xml = response.substring(response.indexOf(initLabel) + initLabel.length(), response.indexOf(endLabel));
        try {
            return this.gson.fromJson(XML.toJSONObject((String)xml).toString(), this.clazz);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoapObject stringToSoapObject(String response) throws Exception {
        SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
        SoapObject soap = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes());
            XmlPullParser p = Xml.newPullParser();
            p.setInput((InputStream)inputStream, "UTF-8");
            envelope.parse(p);
            soap = (SoapObject)envelope.bodyIn;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return soap;
    }
}

