/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.requests;

import android.os.Environment;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.error.CancelError;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;

public class CustomRequest<T>
extends JsonRequest<T> {
    private static Map<String, String> headers;
    private Map<String, String> params;
    private Response.Listener listener;
    private String path;
    private String requestBody;
    private Response.ErrorListener errorListener;
    private Request.Priority priority;
    private static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    private static final String RESPONSE = "response";

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, WebServicesManager.configuration.getEnvironment() + path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, WebServicesManager.configuration.getEnvironment() + path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, environment + path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    protected void deliverResponse(T response) {
        this.listener.onResponse(response);
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)("REQUEST: " + this.path + this.requestBody));
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
            CustomRequest.writeLogInFile("REQUEST: " + this.path + this.requestBody);
        }
        volleyError.printStackTrace();
        String error = "";
        if (volleyError.getMessage() != null) {
            error = volleyError.getMessage();
        } else if (volleyError.networkResponse != null && volleyError.networkResponse.data != null) {
            error = new String(volleyError.networkResponse.data);
        } else if (volleyError.networkResponse != null) {
            error = volleyError.networkResponse.statusCode + "";
        }
        Log.e((String)"DATAMANAGER", (String)("ERROR: " + error));
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
            CustomRequest.writeLogInFile("ERROR:  " + error);
        }
        return new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        WebServicesManager.headers = response.headers;
        WebServicesManager.headers.remove("Content-Length");
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
            Log.e((String)"DATAMANAGER", (String)("REQUEST: " + this.path + this.requestBody));
        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
            CustomRequest.writeLogInFile("REQUEST: " + this.path + this.requestBody);
        }
        try {
            VolleyError volleyError;
            String responseData = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS()) {
                Log.e((String)"DATAMANAGER", (String)("RESPONSE: " + this.path + " " + responseData));
            }
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE()) {
                CustomRequest.writeLogInFile("RESPONSE: " + this.path + " " + responseData);
            }
            if ((volleyError = WebServicesManager.configuration.checkError(responseData)) != null) {
                return Response.error((VolleyError)volleyError);
            }
            return Response.success((Object)this.parseResponse(responseData), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((VolleyError)new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE()));
        }
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    public static void writeLogInFile(String text) {
        File root = Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + WebServicesManager.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Request.Priority getPriority() {
        if (this.priority == null) {
            return super.getPriority();
        }
        return this.priority;
    }

    public Map<String, String> getHeaders() {
        if (WebServicesManager.headers != null) {
            return WebServicesManager.headers;
        }
        try {
            return super.getHeaders();
        }
        catch (AuthFailureError e) {
            Log.e((String)REQUEST_EXCEPTION, (String)"Error en las cabeceras");
            return null;
        }
    }

    public void setHeaders(Map<String, String> headers) {
        CustomRequest.headers = headers;
    }

    public Map<String, String> getParams() {
        if (this.params != null) {
            return this.params;
        }
        try {
            return super.getParams();
        }
        catch (AuthFailureError e) {
            Log.e((String)REQUEST_EXCEPTION, (String)"Error en las cabeceras");
            return null;
        }
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Response.Listener getListener() {
        return this.listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        if (this.getMethod() == 1) {
            return super.getUrl();
        }
        return super.getUrl() + this.requestBody;
    }

    public void cancel() {
        super.cancel();
        this.errorListener.onErrorResponse((VolleyError)new CancelError());
    }
}

