package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;

/**
 * Created by Navas on 24/06/15
 * It controls all dummy request
 */
public class DummyRequestQueue extends RequestQueue{

    public DummyRequestQueue() {
        super(null, null);
    }

    @Override
    public Request add(Request request){
        CustomRequest customRequest = (CustomRequest) request;
        String data = DummyResponses.DUMMY_RESPONSES.get(customRequest.getPath());
        data = (data == null) ? "" : data;
        NetworkResponse networkResponse = new NetworkResponse(data.getBytes());
        Response response = customRequest.parseNetworkResponse(networkResponse);
        if(response.error!=null)
            customRequest.deliverError(response.error);
        else
            customRequest.deliverResponse(response.result);
        return request;
    }


}
