/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager.soap;

import com.tm.datamanager.webservicesmanager.soap.AttributeInfo;
import com.tm.datamanager.webservicesmanager.soap.PropertyInfo;
import java.util.Vector;

public class AttributeContainer {
    private Vector attributes = new Vector();

    public void getAttributeInfo(int index, AttributeInfo attributeInfo) {
        AttributeInfo p = (AttributeInfo)this.attributes.elementAt(index);
        attributeInfo.name = p.name;
        attributeInfo.namespace = p.namespace;
        attributeInfo.flags = p.flags;
        attributeInfo.type = p.type;
        attributeInfo.elementType = p.elementType;
        attributeInfo.value = p.getValue();
    }

    public Object getAttribute(int index) {
        return ((AttributeInfo)this.attributes.elementAt(index)).getValue();
    }

    public String getAttributeAsString(int index) {
        AttributeInfo attributeInfo = (AttributeInfo)this.attributes.elementAt(index);
        return attributeInfo.getValue().toString();
    }

    public Object getAttribute(String name) {
        Integer i = this.attributeIndex(name);
        if (i != null) {
            return this.getAttribute(i);
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public String getAttributeAsString(String name) {
        Integer i = this.attributeIndex(name);
        if (i != null) {
            return this.getAttribute(i).toString();
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public boolean hasAttribute(String name) {
        return this.attributeIndex(name) != null;
    }

    public Object getAttributeSafely(String name) {
        Integer i = this.attributeIndex(name);
        if (i != null) {
            return this.getAttribute(i);
        }
        return null;
    }

    public Object getAttributeSafelyAsString(String name) {
        Integer i = this.attributeIndex(name);
        if (i != null) {
            return this.getAttribute(i).toString();
        }
        return "";
    }

    public Object safeGetAttribute(String name) {
        return this.getAttributeSafely(name);
    }

    private Integer attributeIndex(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!name.equals(((AttributeInfo)this.attributes.elementAt(i)).getName())) continue;
            return new Integer(i);
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    protected boolean attributesAreEqual(AttributeContainer other) {
        int numAttributes = this.getAttributeCount();
        if (numAttributes != other.getAttributeCount()) {
            return false;
        }
        for (int attribIndex = 0; attribIndex < numAttributes; ++attribIndex) {
            AttributeInfo thisAttrib = (AttributeInfo)this.attributes.elementAt(attribIndex);
            Object thisAttribValue = thisAttrib.getValue();
            if (!other.hasAttribute(thisAttrib.getName())) {
                return false;
            }
            Object otherAttribValue = other.safeGetAttribute(thisAttrib.getName());
            if (thisAttribValue.equals(otherAttribValue)) continue;
            return false;
        }
        return true;
    }

    public void addAttribute(String name, Object value) {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.name = name;
        attributeInfo.type = value == null ? PropertyInfo.OBJECT_CLASS : value.getClass();
        attributeInfo.value = value;
        this.addAttribute(attributeInfo);
    }

    public void addAttributeIfValue(String name, Object value) {
        if (value != null) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.addElement(attributeInfo);
    }

    public void addAttributeIfValue(AttributeInfo attributeInfo) {
        if (attributeInfo.value != null) {
            this.attributes.addElement(attributeInfo);
        }
    }
}

