/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */ import java.util.Vector;

/*     */
/*     */ public class AttributeContainer
/*     */ {
/*   6 */   private Vector attributes = new Vector();
/*     */ 
/*     */   public void getAttributeInfo(int index, AttributeInfo attributeInfo)
/*     */   {
/*  15 */     AttributeInfo p = (AttributeInfo)this.attributes.elementAt(index);
/*  16 */     attributeInfo.name = p.name;
/*  17 */     attributeInfo.namespace = p.namespace;
/*  18 */     attributeInfo.flags = p.flags;
/*  19 */     attributeInfo.type = p.type;
/*  20 */     attributeInfo.elementType = p.elementType;
/*  21 */     attributeInfo.value = p.getValue();
/*     */   }
/*     */ 
/*     */   public Object getAttribute(int index)
/*     */   {
/*  28 */     return ((AttributeInfo)this.attributes.elementAt(index)).getValue();
/*     */   }
/*     */ 
/*     */   public String getAttributeAsString(int index)
/*     */   {
/*  35 */     AttributeInfo attributeInfo = (AttributeInfo)this.attributes.elementAt(index);
/*  36 */     return attributeInfo.getValue().toString();
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String name)
/*     */   {
/*  45 */     Integer i = attributeIndex(name);
/*  46 */     if (i != null) return getAttribute(i.intValue());
/*  47 */     throw new RuntimeException("illegal property: " + name);
/*     */   }
/*     */ 
/*     */   public String getAttributeAsString(String name)
/*     */   {
/*  56 */     Integer i = attributeIndex(name);
/*  57 */     if (i != null) {
/*  58 */       return getAttribute(i.intValue()).toString();
/*     */     }
/*     */ 
/*  61 */     throw new RuntimeException("illegal property: " + name);
/*     */   }
/*     */ 
/*     */   public boolean hasAttribute(String name)
/*     */   {
/*  69 */     if (attributeIndex(name) != null) {
/*  70 */       return true;
/*     */     }
/*     */ 
/*  73 */     return false;
/*     */   }
/*     */ 
/*     */   public Object getAttributeSafely(String name)
/*     */   {
/*  84 */     Integer i = attributeIndex(name);
/*  85 */     if (i != null) {
/*  86 */       return getAttribute(i.intValue());
/*     */     }
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getAttributeSafelyAsString(String name)
/*     */   {
/* 101 */     Integer i = attributeIndex(name);
/* 102 */     if (i != null) {
/* 103 */       return getAttribute(i.intValue()).toString();
/*     */     }
/* 105 */     return "";
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Object safeGetAttribute(String name)
/*     */   {
/* 113 */     return getAttributeSafely(name);
/*     */   }
/*     */ 
/*     */   private Integer attributeIndex(String name) {
/* 117 */     for (int i = 0; i < this.attributes.size(); i++) {
/* 118 */       if (name.equals(((AttributeInfo)this.attributes.elementAt(i)).getName())) return new Integer(i);
/*     */     }
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public int getAttributeCount()
/*     */   {
/* 129 */     return this.attributes.size();
/*     */   }
/*     */ 
/*     */   protected boolean attributesAreEqual(AttributeContainer other)
/*     */   {
/* 139 */     int numAttributes = getAttributeCount();
/* 140 */     if (numAttributes != other.getAttributeCount()) {
/* 141 */       return false;
/*     */     }
/* 143 */     for (int attribIndex = 0; attribIndex < numAttributes; attribIndex++) {
/* 144 */       AttributeInfo thisAttrib = (AttributeInfo)this.attributes.elementAt(attribIndex);
/* 145 */       Object thisAttribValue = thisAttrib.getValue();
/* 146 */       if (!other.hasAttribute(thisAttrib.getName())) return false;
/* 147 */       Object otherAttribValue = other.safeGetAttribute(thisAttrib.getName());
/* 148 */       if (!thisAttribValue.equals(otherAttribValue)) {
/* 149 */         return false;
/*     */       }
/*     */     }
/* 152 */     return true;
/*     */   }
/*     */ 
/*     */   public void addAttribute(String name, Object value)
/*     */   {
/* 163 */     AttributeInfo attributeInfo = new AttributeInfo();
/* 164 */     attributeInfo.name = name;
/* 165 */     attributeInfo.type = (value == null ? PropertyInfo.OBJECT_CLASS : value.getClass());
/* 166 */     attributeInfo.value = value;
/* 167 */     addAttribute(attributeInfo);
/*     */   }
/*     */ 
/*     */   public void addAttributeIfValue(String name, Object value)
/*     */   {
/* 176 */     if (value != null)
/* 177 */       addAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public void addAttribute(AttributeInfo attributeInfo)
/*     */   {
/* 189 */     this.attributes.addElement(attributeInfo);
/*     */   }
/*     */ 
/*     */   public void addAttributeIfValue(AttributeInfo attributeInfo)
/*     */   {
/* 197 */     if (attributeInfo.value != null)
/* 198 */       this.attributes.addElement(attributeInfo);
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.ksoap2.serialization.AttributeContainer
 * JD-Core Version:    0.6.2
 */