/*     */ package com.tm.datamanager.webservicesmanager.soap;
/*     */ 
/*     */

import java.util.Hashtable;
import java.util.Vector;

/*     */

/*     */
/*     */ public class SoapObject extends AttributeContainer
/*     */   implements KvmSerializable
/*     */ {
/*     */   protected String namespace;
/*     */   protected String name;
/*  47 */   protected Vector properties = new Vector();
/*     */ 
/*  51 */   protected Vector nestedSoapObjects = new Vector();
/*     */ 
/*     */   public SoapObject(String namespace, String name)
/*     */   {
/*  63 */     this.namespace = namespace;
/*  64 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj) {
/*  68 */     if (!(obj instanceof SoapObject)) {
/*  69 */       return false;
/*     */     }
/*     */ 
/*  72 */     SoapObject otherSoapObject = (SoapObject)obj;
/*     */ 
/*  74 */     if ((!this.name.equals(otherSoapObject.name)) || (!this.namespace.equals(otherSoapObject.namespace))) {
/*  75 */       return false;
/*     */     }
/*     */ 
/*  79 */     int numProperties = this.properties.size();
/*  80 */     if (numProperties != otherSoapObject.properties.size()) {
/*  81 */       return false;
/*     */     }
/*  83 */     int numNested = this.nestedSoapObjects.size();
/*  84 */     if (numNested != otherSoapObject.nestedSoapObjects.size()) {
/*  85 */       return false;
/*     */     }
/*     */ 
/*  97 */     for (int propIndex = 0; propIndex < numProperties; propIndex++) {
/*  98 */       PropertyInfo thisProp = (PropertyInfo)this.properties.elementAt(propIndex);
/*  99 */       Object thisPropValue = thisProp.getValue();
/* 100 */       if (!otherSoapObject.hasProperty(thisProp.getName())) {
/* 101 */         return false;
/*     */       }
/* 103 */       Object otherPropValue = otherSoapObject.getProperty(thisProp.getName());
/* 104 */       if (!thisPropValue.equals(otherPropValue)) {
/* 105 */         return false;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 110 */     for (int nestIndex = 0; nestIndex < numNested; nestIndex++) {
/* 111 */       if (!getNestedSoap(nestIndex).equals(otherSoapObject.getNestedSoap(nestIndex))) {
/* 112 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 116 */     return attributesAreEqual(otherSoapObject);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 121 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getNamespace() {
/* 125 */     return this.namespace;
/*     */   }
/*     */ 
/*     */   public Object getNestedSoap(int index)
/*     */   {
/* 132 */     return (SoapObject)this.nestedSoapObjects.elementAt(index);
/*     */   }
/*     */ 
/*     */   public Object getProperty(int index)
/*     */   {
/* 139 */     return ((PropertyInfo)this.properties.elementAt(index)).getValue();
/*     */   }
/*     */ 
/*     */   public String getPropertyAsString(int index)
/*     */   {
/* 148 */     PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
/* 149 */     return propertyInfo.getValue().toString();
/*     */   }
/*     */ 
/*     */   public Object getProperty(String name)
/*     */   {
/* 158 */     Integer index = propertyIndex(name);
/* 159 */     if (index != null) {
/* 160 */       return getProperty(index.intValue());
/*     */     }
/* 162 */     throw new RuntimeException("illegal property: " + name);
/*     */   }
/*     */ 
/*     */   public String getPropertyAsString(String name)
/*     */   {
/* 173 */     Integer index = propertyIndex(name);
/* 174 */     if (index != null) {
/* 175 */       return getProperty(index.intValue()).toString();
/*     */     }
/* 177 */     throw new RuntimeException("illegal property: " + name);
/*     */   }
/*     */ 
/*     */   public boolean hasProperty(String name)
/*     */   {
/* 185 */     if (propertyIndex(name) != null) {
/* 186 */       return true;
/*     */     }
/* 188 */     return false;
/*     */   }
/*     */ 
/*     */   public Object getPropertySafely(String name)
/*     */   {
/* 198 */     Integer i = propertyIndex(name);
/* 199 */     if (i != null) {
/* 200 */       return getProperty(i.intValue());
/*     */     }
/* 202 */     return new NullSoapObject();
/*     */   }
/*     */ 
/*     */   public String getPropertySafelyAsString(String name)
/*     */   {
/* 214 */     Integer i = propertyIndex(name);
/* 215 */     if (i != null) {
/* 216 */       return getProperty(i.intValue()).toString();
/*     */     }
/* 218 */     return "";
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Object safeGetProperty(String name)
/*     */   {
/* 226 */     return getPropertySafely(name);
/*     */   }
/*     */ 
/*     */   public Object getPropertySafely(String name, Object defaultThing)
/*     */   {
/* 237 */     Integer i = propertyIndex(name);
/* 238 */     if (i != null) {
/* 239 */       return getProperty(i.intValue());
/*     */     }
/* 241 */     return defaultThing;
/*     */   }
/*     */ 
/*     */   public String getPropertySafelyAsString(String name, Object defaultThing)
/*     */   {
/* 257 */     Integer i = propertyIndex(name);
/* 258 */     if (i != null) {
/* 259 */       return getProperty(i.intValue()).toString();
/*     */     }
/* 261 */     return defaultThing.toString();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Object safeGetProperty(String name, Object defaultThing)
/*     */   {
/* 268 */     return getPropertySafely(name, defaultThing);
/*     */   }
/*     */ 
/*     */   private Integer propertyIndex(String name) {
/* 272 */     for (int i = 0; i < this.properties.size(); i++) {
/* 273 */       if (name.equals(((PropertyInfo)this.properties.elementAt(i)).getName())) return new Integer(i);
/*     */     }
/* 275 */     return null;
/*     */   }
/*     */ 
/*     */   public int getPropertyCount()
/*     */   {
/* 284 */     return this.properties.size();
/*     */   }
/*     */ 
/*     */   public int getNestedSoapCount()
/*     */   {
/* 293 */     return this.nestedSoapObjects.size();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void getPropertyInfo(int index, Hashtable properties, PropertyInfo propertyInfo)
/*     */   {
/* 304 */     getPropertyInfo(index, propertyInfo);
/*     */   }
/*     */ 
/*     */   public void getPropertyInfo(int index, PropertyInfo propertyInfo)
/*     */   {
/* 314 */     PropertyInfo p = (PropertyInfo)this.properties.elementAt(index);
/* 315 */     propertyInfo.name = p.name;
/* 316 */     propertyInfo.namespace = p.namespace;
/* 317 */     propertyInfo.flags = p.flags;
/* 318 */     propertyInfo.type = p.type;
/* 319 */     propertyInfo.elementType = p.elementType;
/* 320 */     propertyInfo.value = p.value;
/* 321 */     propertyInfo.multiRef = p.multiRef;
/*     */   }
/*     */ 
/*     */   public SoapObject newInstance()
/*     */   {
/* 331 */     SoapObject o = new SoapObject(this.namespace, this.name);
/* 332 */     for (int propIndex = 0; propIndex < this.properties.size(); propIndex++) {
/* 333 */       PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(propIndex);
/* 334 */       o.addProperty(propertyInfo);
/*     */     }
/* 336 */     for (int attribIndex = 0; attribIndex < getAttributeCount(); attribIndex++) {
/* 337 */       AttributeInfo newAI = new AttributeInfo();
/* 338 */       getAttributeInfo(attribIndex, newAI);
/* 339 */       AttributeInfo attributeInfo = newAI;
/* 340 */       o.addAttribute(attributeInfo);
/*     */     }
/* 342 */     return o;
/*     */   }
/*     */ 
/*     */   public void setProperty(int index, Object value)
/*     */   {
/* 352 */     ((PropertyInfo)this.properties.elementAt(index)).setValue(value);
/*     */   }
/*     */ 
/*     */   public SoapObject addProperty(String name, Object value)
/*     */   {
/* 362 */     PropertyInfo propertyInfo = new PropertyInfo();
/* 363 */     propertyInfo.name = name;
/* 364 */     propertyInfo.type = (value == null ? PropertyInfo.OBJECT_CLASS : value.getClass());
/* 365 */     propertyInfo.value = value;
/* 366 */     return addProperty(propertyInfo);
/*     */   }
/*     */ 
/*     */   public SoapObject addPropertyIfValue(String name, Object value)
/*     */   {
/* 376 */     if (value != null) {
/* 377 */       return addProperty(name, value);
/*     */     }
/* 379 */     return this;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public SoapObject addProperty(PropertyInfo propertyInfo, Object value)
/*     */   {
/* 391 */     propertyInfo.setValue(value);
/* 392 */     addProperty(propertyInfo);
/* 393 */     return this;
/*     */   }
/*     */ 
/*     */   public SoapObject addPropertyIfValue(PropertyInfo propertyInfo, Object value)
/*     */   {
/* 404 */     if (value != null) {
/* 405 */       return addProperty(propertyInfo, value);
/*     */     }
/* 407 */     return this;
/*     */   }
/*     */ 
/*     */   public SoapObject addProperty(PropertyInfo propertyInfo)
/*     */   {
/* 417 */     this.properties.addElement(propertyInfo);
/* 418 */     return this;
/*     */   }
/*     */ 
/*     */   public SoapObject addPropertyIfValue(PropertyInfo propertyInfo)
/*     */   {
/* 427 */     if (propertyInfo.value != null) {
/* 428 */       this.properties.addElement(propertyInfo);
/* 429 */       return this;
/*     */     }
/* 431 */     return this;
/*     */   }
/*     */ 
/*     */   public SoapObject addSoapObject(SoapObject soapObject)
/*     */   {
/* 442 */     this.nestedSoapObjects.addElement(soapObject);
/* 443 */     return this;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 451 */     StringBuffer buf = new StringBuffer("" + this.name + "{");
/* 452 */     for (int j = 0; j < getNestedSoapCount(); j++) {
/* 453 */       buf.append("\n" + ((SoapObject)this.nestedSoapObjects.elementAt(j)).toString());
/*     */     }
/* 455 */     for (int i = 0; i < getPropertyCount(); i++) {
/* 456 */       buf.append("" + ((PropertyInfo)this.properties.elementAt(i)).getName() + "=" + getProperty(i) + "; ");
/*     */     }
/* 458 */     buf.append("}");
/* 459 */     return buf.toString();
/*     */   }
/*     */ }

/* Location:           C:\Users\Samuel\Documents\Proyectos\SantanderMobilePaymentLibrary\SMPLibrary\mobilepaymentlibrary\libs\ksoap2-android.jar
 * Qualified Name:     org.ksoap2.serialization.SoapObject
 * JD-Core Version:    0.6.2
 */