package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.Response;
import com.google.gson.Gson;
import com.tm.datamanager.webservicesmanager.soap.SoapResponse;

/**
 * Created by Navas on 10/6/15
 * Return the response parsed to T class using Soap Response
 */
public class CustomSoapRequest<T extends SoapResponse> extends CustomRequest<T> {

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, path, requestBody, listener, errorListener);
    }

    public CustomSoapRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, path, requestBody, listener, errorListener, priority);
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment, path, requestBody, listener, errorListener);
    }

    public CustomSoapRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
    }

    @Override
    protected Object parseResponse(String response) {
        T objectResponse = (T) new Object();
        objectResponse.setResponse(response);
        return objectResponse;
    }
}
