package com.tm.datamanager.webservicesmanager.requests;

import com.android.volley.Response;
import com.google.gson.Gson;

/**
 * Created by Navas on 10/6/15
 * Return the response parsed to T class using GSON library
 */
public class CustomGsonRequest<T> extends CustomRequest<T> {
    private final Gson gson = new Gson();
    private Class<T> clazz;

    public CustomGsonRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomGsonRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz) {
        super(method, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    public CustomGsonRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener);
        this.clazz = clazz;
    }

    public CustomGsonRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority, Class<T> clazz) {
        super(method, environment, path, requestBody, listener, errorListener, priority);
        this.clazz = clazz;
    }

    @Override
    protected Object parseResponse(String response) {
        return gson.fromJson(response, clazz);
    }
}
