package com.tm.datamanager.webservicesmanager.requests;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.error.CancelError;

import org.json.JSONException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Navas on 23/06/15
 * This is the parent of the request
 * By default return the response in String format
 */
public class  CustomRequest<T> extends JsonRequest<T> {

    private Map<String, String> headers;
    private Map<String, String> params;
    private Response.Listener listener;
    private String path;
    private String requestBody;
    private Response.ErrorListener errorListener;
    private Priority priority;

    private static final String REQUEST_EXCEPTION = "REQUEST_EXCEPTION";
    private static final String RESPONSE = "response";

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, WebServicesManager.configuration.getEnvironment()+path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, WebServicesManager.configuration.getEnvironment()+path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public CustomRequest(int method, String environment, String path, String requestBody, Response.Listener<T> listener, Response.ErrorListener errorListener, Priority priority) {
        super(method, environment+path, requestBody, listener, errorListener);
        this.priority = priority;
        this.path = path;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }



    @Override
    protected void deliverResponse(T response) {
        if(response != null)
            listener.onResponse(response);
    }

    @Override
    public void deliverError(VolleyError error) {
        errorListener.onErrorResponse(error);
    }

    @Override
    protected VolleyError parseNetworkError(VolleyError volleyError) {
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
            Log.e("DATAMANAGER", "REQUEST: " + path +  new String(getBody()));
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("REQUEST: " + path +  new String(getBody()));
        volleyError.printStackTrace();
        String error="";
        VolleyError parseError = null;
        if(volleyError.getMessage() != null){
            error = volleyError.getMessage();
            parseError = WebServicesManager.configuration.checkError(error);
        }else if(volleyError.networkResponse != null && volleyError.networkResponse.data != null){
            error = new String(volleyError.networkResponse.data);
            parseError = WebServicesManager.configuration.checkError(error);
        }else if(volleyError.networkResponse != null){
            error = volleyError.networkResponse.statusCode+"";
        }
        Log.e("DATAMANAGER", "ERROR: " + error);
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("ERROR:  " + error);
        if(parseError != null) return parseError;
        return new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE());
    }

    @Override
    protected Response<T> parseNetworkResponse(NetworkResponse response) {
//        if(WebServicesManager.configuration.isSAVECOOKIES()) {
//            WebServicesManager.headers = response.headers;
//            WebServicesManager.headers.remove("Content-Length");
//        }
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
            Log.e("DATAMANAGER", "REQUEST: " + path + new String(getBody()));
        if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
            writeLogInFile("REQUEST: " + path + new String(getBody()));

        try {
            String responseData;
            if(WebServicesManager.configuration.getResponseCodification() == null)
                responseData = new String(response.data);
            else
                responseData = new String(response.data,WebServicesManager.configuration.getResponseCodification());

            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS())
                Log.e("DATAMANAGER", "RESPONSE: " + path + " " + responseData);
            if (WebServicesManager.configuration.isSHOW_REQUEST_LOGS_FILE())
                writeLogInFile("RESPONSE: " + path + " " + responseData);

            VolleyError volleyError = WebServicesManager.configuration.checkError(responseData);
            if (volleyError != null) {
                return Response.error(volleyError);
            } else {
                return Response.success((T) parseResponse(responseData)
                        , HttpHeaderParser.parseCacheHeaders(response));
            }

        } catch (Exception e) {
            e.printStackTrace();
            return Response.error(new VolleyError(WebServicesManager.configuration.getDEFAULT_REQUEST_ERROR_MESSAGE()));
        }
    }

    /**
     * Function to process request from external WebServicesManagers
     * @param networkResponse
     */
    public void bridgeToParseNetWorkResponse(NetworkResponse networkResponse){
        Response response = parseNetworkResponse(networkResponse);
        if(response.error != null)
            deliverError(response.error);
        else
            deliverResponse((T) response.result);
    }

    protected Object parseResponse(String response) throws JSONException {
        return response;
    }

    /**
     * WRITE THE REQUESTS AND RESPONSES IN THE LOG FILE
     *
     * @param text log to write in the log
     */
    public static void writeLogInFile(String text) {
        File root = android.os.Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + WebServicesManager.configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, true);
            pw.append(text + "\n");
            pw.flush();
            pw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    // GETTERS AND SETTERS

    @Override
    public Priority getPriority() {
        if (priority == null)
            return super.getPriority();
        return priority;
    }


    @Override
    public Map<String, String> getHeaders() {

        Map<String, String> aux = null;
        try {
            if (headers != null) {
                aux = headers;
            } else {
                aux = super.getHeaders();
            }
        }catch (Exception a){
            aux = null;
        }

        return aux;
    }

    @Override
    public byte[] getBody() {
        if(getParams() != null){
            return encodeParameters(getParams());
        }else {
            try {
                return requestBody == null ? null : requestBody.getBytes(PROTOCOL_CHARSET);
            } catch (UnsupportedEncodingException uee) {
                return null;
            }
        }
    }

    private byte[] encodeParameters(Map<String, String> params) {
        try {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (postData.length() != 0)
                    postData.append('&');
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] data = postData.toString().getBytes("UTF-8");

            //return params
            return data;

        } catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + PROTOCOL_CHARSET, uee);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> aux = null;
        if (params != null) {
            aux = params;
        } else {
            try {
                aux = super.getParams();
            } catch (AuthFailureError e) {
                Log.e(REQUEST_EXCEPTION, "Error en las cabeceras");
            }
        }

        return aux;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }


    public Response.Listener getListener() {
        return listener;
    }

    public void setListener(Response.Listener listener) {
        this.listener = listener;
    }

    public String getPath() {
        return path;
    }

    @Override
    public String getUrl() {
        if(getMethod() == Method.POST)
            return super.getUrl();
        else
            return super.getUrl()+requestBody;
    }

    @Override
    public void cancel() {
        super.cancel();
        errorListener.onErrorResponse(new CancelError());
    }
}