package com.tm.datamanager.webservicesmanager.requests;

import com.tm.datamanager.webservicesmanager.intetrfaces.ListParallelRequestFinishedListener;

import java.util.ArrayList;

/**
 * Created by Navas on 23/06/15
 */
public class CustomRequestParallelList extends ArrayList<CustomRequest> {

    ListParallelRequestFinishedListener listParallelRequestFinishedListener;

    int requestCount = 0;

    @Override
    public boolean add(CustomRequest object) {
        requestCount++;
        return super.add(object);
    }

    /**
     * Take away one of the requests counter. When the requests counter gain 0 value, and the listParallelRequestFinishedListener isn't null
     * throw the onListParallelRequestFinish event.
     */
    public void finishRequest(){
        requestCount--;
        if(requestCount == 0
                && listParallelRequestFinishedListener != null)
            listParallelRequestFinishedListener.onListParallelRequestFinish();

    }

    public ListParallelRequestFinishedListener getListParallelRequestFinishedListener() {
        return listParallelRequestFinishedListener;
    }

    public void setListParallelRequestFinishedListener(ListParallelRequestFinishedListener listParallelRequestFinishedListener) {
        this.listParallelRequestFinishedListener = listParallelRequestFinishedListener;
    }
}
