package com.tm.datamanager.webservicesmanager.configurations;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.VolleyError;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.preferencesmanager.PreferencesConfigurations;
import com.tm.datamanager.webservicesmanager.certifieds.BaseCertified;

import org.json.JSONException;
import org.json.JSONObject;

import javax.net.ssl.X509TrustManager;

/**
 * Created by Navas on 19/06/15
 * This class contains all configuration for the calls to the services
 */
public abstract class WebServicesConfiguration {

    // ENVIRONMENT SELECTED
    private String environment;
    private String environmentName;

    /**
     * Check if the server return an error
     * @param response
     * @return null if the server hasn't returned an error or a VolleyError with the information of
     * the error.
     */
    public abstract  VolleyError checkError(String response);

    public abstract String[] getENVIRONMENTS();

    public abstract String[] getENVIRONMENTS_NAMES();

    public String getEnvironment(){
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getEnvironmentName(){
        return environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public abstract int getATTEMPTS();

    public abstract int getTIMEOUT();

    public abstract float getBACKOFFMULTIPLIER();

    /**
     * MESSAGE TO SHOW WHEN THE REQUEST THROWS AN ERROR
     * @return
     */
    public abstract String getDEFAULT_REQUEST_ERROR_MESSAGE();

    /**
     * ENABLE SHOW THE REQUESTS AND RESPONSES IN THE LOGCAT
     * @return
     */
    public abstract boolean isSHOW_REQUEST_LOGS();

    /**
     * ENABLE WRITE THE REQUESTS AND RESPONSES IN THE LOG FILE
     * @return
     */
    public abstract boolean isSHOW_REQUEST_LOGS_FILE();

    /**
     * NAME OF FILE LOG
     * @return
     */
    public abstract String getFILE_LOG();

    /**
     * ENABLE THE DUMMY RESPONSES, IF YOU SET TRUE, YOU HAVE TO ADD A RESPONSE FOR EACH REQUEST IN
     * DummyResponses FILE
     * @return
     */
    public abstract boolean isDUMMY();

    /**
     * Get certified to HTTPS request, only implement when if it necessary
     */
    public abstract BaseCertified getCertified();
}
