/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.webservicesmanager;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Environment;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.Volley;
import com.tm.datamanager.DataManager;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import com.tm.datamanager.webservicesmanager.requests.CustomRequest;
import com.tm.datamanager.webservicesmanager.requests.CustomRequestParallelList;
import com.tm.datamanager.webservicesmanager.requests.DummyRequestQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class WebServicesManager
implements RequestQueue.RequestFinishedListener {
    private Context context;
    private RequestQueue requestQueue;
    private LinkedList<Request> queue = new LinkedList();
    private ArrayList<RequestQueue> parallelRequestQueues = new ArrayList();
    public static Map<String, String> headers;
    public static WebServicesConfiguration configuration;

    public WebServicesManager(Context context, WebServicesConfiguration configuration, HashMap<String, String> dummyResponses) {
        this.context = context;
        WebServicesManager.configuration = configuration;
        if (dummyResponses != null) {
            DummyResponses.DUMMY_RESPONSES = dummyResponses;
        }
        headers = null;
        this.requestQueue = this.generateRequestQueue();
        if (configuration.isDUMMY()) {
            configuration.setEnvironment("");
            configuration.setEnvironmentName("DUMMY");
        } else {
            configuration.setEnvironment(configuration.getENVIRONMENTS()[DataManager.getPreferencesManagerInstance().getIntValue("ENVIRONMENT")]);
        }
        if (configuration.isSHOW_REQUEST_LOGS_FILE()) {
            this.generateLogFile();
        }
    }

    private void generateLogFile() {
        File root = Environment.getExternalStorageDirectory();
        File log = new File(root.getAbsolutePath() + "/" + configuration.getFILE_LOG());
        try {
            FileWriter pw = new FileWriter(log, false);
            pw.append("");
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private RequestQueue generateRequestQueue() {
        if (configuration.isDUMMY()) {
            return new DummyRequestQueue();
        }
        return Volley.newRequestQueue((Context)this.context.getApplicationContext());
    }

    public void onRequestFinished(Request request) {
        if (this.queue.size() != 0) {
            this.requestQueue.add(this.queue.removeFirst());
        }
    }

    public void addRequest(Request request, String tag) {
        request.setTag((Object)tag);
        this.configureRetryPolicy(request);
        if (this.queue.size() == 0) {
            this.requestQueue.add(request);
        } else {
            this.queue.addLast(request);
        }
    }

    public void addParallelRequest(Request request, String tag) {
        final RequestQueue requestQueue = this.generateRequestQueue();
        request.setTag((Object)tag);
        this.configureRetryPolicy(request);
        requestQueue.add(request);
        requestQueue.addRequestFinishedListener((RequestQueue.RequestFinishedListener)new RequestQueue.RequestFinishedListener<Object>(){

            public void onRequestFinished(Request<Object> request) {
                WebServicesManager.this.parallelRequestQueues.remove(requestQueue);
            }
        });
        this.parallelRequestQueues.add(requestQueue);
    }

    public void addParallelRequestList(final CustomRequestParallelList requestList, String tag) {
        for (CustomRequest request : requestList) {
            final RequestQueue requestQueue = this.generateRequestQueue();
            request.setTag(tag);
            this.configureRetryPolicy((Request)request);
            requestQueue.add((Request)request);
            requestQueue.addRequestFinishedListener((RequestQueue.RequestFinishedListener)new RequestQueue.RequestFinishedListener<Object>(){

                public void onRequestFinished(Request<Object> request) {
                    WebServicesManager.this.parallelRequestQueues.remove(requestQueue);
                    requestList.finishRequest();
                }
            });
            this.parallelRequestQueues.add(requestQueue);
        }
    }

    private void configureRetryPolicy(Request request) {
        if (request.getRetryPolicy() == null) {
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(configuration.getTIMEOUT(), configuration.getATTEMPTS(), configuration.getBACKOFFMULTIPLIER()));
        }
    }

    public void cancelRequest(String tag) {
        this.requestQueue.cancelAll((Object)tag);
        for (RequestQueue requestQueue : this.parallelRequestQueues) {
            requestQueue.cancelAll((Object)tag);
        }
        for (Request request : this.queue) {
            if (!request.getTag().equals(tag)) continue;
            this.queue.remove(request);
            break;
        }
    }

    public void configureEnvironment(final Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"ENVIRONMENTS");
        ArrayAdapter adapter = new ArrayAdapter(context, 17367058, (Object[])configuration.getENVIRONMENTS_NAMES());
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                configuration.setEnvironment(configuration.getENVIRONMENTS()[i]);
                configuration.setEnvironmentName(configuration.getENVIRONMENTS_NAMES()[i]);
                DataManager.getPreferencesManagerInstance().setValue(i, "ENVIRONMENT");
                Toast.makeText((Context)context, (CharSequence)configuration.getEnvironment(), (int)0).show();
            }
        });
        builder.create().show();
    }
}

