/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.core.GiphyCore;
import com.giphy.sdk.core.GiphyCoreUtils;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.response.ListMediaResponse;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.GPHSettings;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.GiphyLoadingProvider;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphGridViewBinding;
import com.giphy.sdk.ui.drawables.ImageFormat;
import com.giphy.sdk.ui.pagination.GPHContent;
import com.giphy.sdk.ui.themes.GPHTheme;
import com.giphy.sdk.ui.universallist.SmartItemData;
import com.giphy.sdk.ui.universallist.SmartItemType;
import com.giphy.sdk.ui.views.GPHEmojiDrawer;
import com.giphy.sdk.ui.views.GPHGridCallback;
import com.giphy.sdk.ui.views.GPHMediaPreviewDialog;
import com.giphy.sdk.ui.views.GPHSearchGridCallback;
import com.giphy.sdk.ui.views.GifView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 r2\u00020\u0001:\u0001rB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010N\u001a\u00020OH\u0002J\u0018\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002J\b\u0010T\u001a\u00020OH\u0014J\b\u0010U\u001a\u00020OH\u0014J\u0018\u0010V\u001a\u00020O2\u0006\u0010W\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002J\u0018\u0010X\u001a\u00020O2\u0006\u0010W\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002J\u0018\u0010Y\u001a\u00020O2\u0006\u0010W\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002J\u0012\u0010Z\u001a\u00020O2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0002J\u0012\u0010]\u001a\u00020O2\b\u0010^\u001a\u0004\u0018\u00010_H\u0014J\n\u0010`\u001a\u0004\u0018\u00010_H\u0014J\u0010\u0010a\u001a\u00020O2\u0006\u0010b\u001a\u00020$H\u0016J\u0012\u0010c\u001a\u00020O2\b\u0010d\u001a\u0004\u0018\u00010\\H\u0002J\u000e\u0010e\u001a\u00020O2\u0006\u0010f\u001a\u00020gJ:\u0010h\u001a\u00020O2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020R2\u000e\u0010l\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010n0m2\u0006\u0010S\u001a\u00020\u00072\b\b\u0002\u0010o\u001a\u00020$H\u0002J\b\u0010p\u001a\u00020OH\u0002J\u0018\u0010q\u001a\u00020O2\u0006\u0010W\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0002R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R$\u0010%\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010'\"\u0004\b.\u0010)R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u0002012\u0006\u0010\u000f\u001a\u000201@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00109\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010\u001aR\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR$\u0010B\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010'\"\u0004\bD\u0010)R$\u0010E\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010'\"\u0004\bG\u0010)R$\u0010H\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0012\"\u0004\bJ\u0010\u0014R\u001a\u0010K\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010'\"\u0004\bM\u0010)\u00a8\u0006s"}, d2={"Lcom/giphy/sdk/ui/views/GiphyGridView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "callback", "Lcom/giphy/sdk/ui/views/GPHGridCallback;", "getCallback", "()Lcom/giphy/sdk/ui/views/GPHGridCallback;", "setCallback", "(Lcom/giphy/sdk/ui/views/GPHGridCallback;)V", "value", "cellPadding", "getCellPadding", "()I", "setCellPadding", "(I)V", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "clipsPreviewRenditionType", "getClipsPreviewRenditionType", "()Lcom/giphy/sdk/core/models/enums/RenditionType;", "setClipsPreviewRenditionType", "(Lcom/giphy/sdk/core/models/enums/RenditionType;)V", "Lcom/giphy/sdk/ui/pagination/GPHContent;", "content", "getContent", "()Lcom/giphy/sdk/ui/pagination/GPHContent;", "setContent", "(Lcom/giphy/sdk/ui/pagination/GPHContent;)V", "direction", "getDirection", "setDirection", "", "enableDynamicText", "getEnableDynamicText", "()Z", "setEnableDynamicText", "(Z)V", "fetchEmojiVariationsJob", "Ljava/util/concurrent/Future;", "fixedSizeCells", "getFixedSizeCells", "setFixedSizeCells", "gridViewBinding", "Lcom/giphy/sdk/ui/databinding/GphGridViewBinding;", "Lcom/giphy/sdk/ui/drawables/ImageFormat;", "imageFormat", "getImageFormat", "()Lcom/giphy/sdk/ui/drawables/ImageFormat;", "setImageFormat", "(Lcom/giphy/sdk/ui/drawables/ImageFormat;)V", "previewDialog", "Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog;", "renditionType", "getRenditionType", "setRenditionType", "searchCallback", "Lcom/giphy/sdk/ui/views/GPHSearchGridCallback;", "getSearchCallback", "()Lcom/giphy/sdk/ui/views/GPHSearchGridCallback;", "setSearchCallback", "(Lcom/giphy/sdk/ui/views/GPHSearchGridCallback;)V", "showCheckeredBackground", "getShowCheckeredBackground", "setShowCheckeredBackground", "showViewOnGiphy", "getShowViewOnGiphy", "setShowViewOnGiphy", "spanCount", "getSpanCount", "setSpanCount", "useInExtensionMode", "getUseInExtensionMode", "setUseInExtensionMode", "applyRecyclerProperties", "", "deliverGif", "item", "Lcom/giphy/sdk/ui/universallist/SmartItemData;", "position", "onAttachedToWindow", "onDetachedFromWindow", "onEmojiSelected", "itemData", "onGifSelected", "onLongPressGif", "onRemoveRecentGif", "mediaId", "", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onWindowFocusChanged", "hasWindowFocus", "queryUsername", "username", "setGiphyLoadingProvider", "loadingProvider", "Lcom/giphy/sdk/ui/GiphyLoadingProvider;", "setup", "emojiDrawer", "Lcom/giphy/sdk/ui/views/GPHEmojiDrawer;", "defaultEmojiVariationItem", "emojiVariations", "", "Lcom/giphy/sdk/core/models/Media;", "shouldRequestVariations", "setupGifsRecycler", "showPreviewDialog", "Companion", "giphy-ui-2.3.4_release"})
public final class GiphyGridView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GphGridViewBinding gridViewBinding;
    @Nullable
    private GPHMediaPreviewDialog previewDialog;
    @Nullable
    private Future<?> fetchEmojiVariationsJob;
    @Nullable
    private GPHGridCallback callback;
    @Nullable
    private GPHSearchGridCallback searchCallback;
    private int direction;
    @Nullable
    private GPHContent content;
    private int cellPadding;
    private int spanCount;
    private boolean showCheckeredBackground;
    @NotNull
    private ImageFormat imageFormat;
    @Nullable
    private RenditionType renditionType;
    @Nullable
    private RenditionType clipsPreviewRenditionType;
    private boolean enableDynamicText;
    private boolean showViewOnGiphy;
    private boolean fixedSizeCells;
    private boolean useInExtensionMode;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    @JvmOverloads
    public GiphyGridView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.direction = 1;
        this.cellPadding = 10;
        this.spanCount = 2;
        this.showCheckeredBackground = true;
        this.imageFormat = ImageFormat.WEBP;
        this.showViewOnGiphy = true;
        Giphy.INSTANCE.setThemeUsed$giphy_ui_2_3_4_release(GPHTheme.Automatic.getThemeResources$giphy_ui_2_3_4_release(context));
        GphGridViewBinding gphGridViewBinding = GphGridViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)gphGridViewBinding, (String)"inflate(LayoutInflater.from(context), this)");
        this.gridViewBinding = gphGridViewBinding;
        this.setSaveEnabled(true);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GiphyGridView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026able.GiphyGridView, 0, 0)");
        TypedArray array = typedArray;
        this.setSpanCount(array.getInteger(R.styleable.GiphyGridView_gphSpanCount, this.spanCount));
        this.setCellPadding(array.getDimensionPixelSize(R.styleable.GiphyGridView_gphCellPadding, this.cellPadding));
        this.setDirection(array.getInteger(R.styleable.GiphyGridView_gphDirection, this.direction));
        this.setShowCheckeredBackground(array.getBoolean(R.styleable.GiphyGridView_gphShowCheckeredBackground, this.showCheckeredBackground));
        this.useInExtensionMode = array.getBoolean(R.styleable.GiphyGridView_gphUseInExtensions, this.useInExtensionMode);
        array.recycle();
        this.setupGifsRecycler();
    }

    public /* synthetic */ GiphyGridView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final GPHGridCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable GPHGridCallback gPHGridCallback) {
        this.callback = gPHGridCallback;
    }

    @Nullable
    public final GPHSearchGridCallback getSearchCallback() {
        return this.searchCallback;
    }

    public final void setSearchCallback(@Nullable GPHSearchGridCallback gPHSearchGridCallback) {
        this.searchCallback = gPHSearchGridCallback;
    }

    public final int getDirection() {
        return this.direction;
    }

    public final void setDirection(int value) {
        this.direction = value;
        this.applyRecyclerProperties();
    }

    @Nullable
    public final GPHContent getContent() {
        return this.content;
    }

    public final void setContent(@Nullable GPHContent value) {
        block6: {
            block5: {
                GPHContent gPHContent = this.content;
                GPHContent gPHContent2 = value;
                if (!Intrinsics.areEqual((Object)(gPHContent != null ? gPHContent.getSearchQuery() : null), (Object)(gPHContent2 != null ? gPHContent2.getSearchQuery() : null))) break block5;
                GPHContent gPHContent3 = this.content;
                GPHContent gPHContent4 = value;
                if ((gPHContent3 != null ? gPHContent3.getMediaType() : null) == (gPHContent4 != null ? gPHContent4.getMediaType() : null)) break block6;
            }
            this.content = value;
            if (value != null) {
                this.gridViewBinding.gifsRecycler.updateContent(value);
            } else {
                this.gridViewBinding.gifsRecycler.clear();
            }
        }
    }

    public final int getCellPadding() {
        return this.cellPadding;
    }

    public final void setCellPadding(int value) {
        this.cellPadding = value;
        this.applyRecyclerProperties();
    }

    public final int getSpanCount() {
        return this.spanCount;
    }

    public final void setSpanCount(int value) {
        this.spanCount = value;
        this.applyRecyclerProperties();
    }

    public final boolean getShowCheckeredBackground() {
        return this.showCheckeredBackground;
    }

    public final void setShowCheckeredBackground(boolean value) {
        this.showCheckeredBackground = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setShowCheckeredBackground(value);
    }

    @NotNull
    public final ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public final void setImageFormat(@NotNull ImageFormat value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.imageFormat = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setImageFormat(value);
    }

    @Nullable
    public final RenditionType getRenditionType() {
        return this.renditionType;
    }

    public final void setRenditionType(@Nullable RenditionType value) {
        this.renditionType = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setRenditionType(value);
    }

    @Nullable
    public final RenditionType getClipsPreviewRenditionType() {
        return this.clipsPreviewRenditionType;
    }

    public final void setClipsPreviewRenditionType(@Nullable RenditionType value) {
        this.clipsPreviewRenditionType = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setClipsPreviewRenditionType(value);
    }

    public final boolean getEnableDynamicText() {
        return this.enableDynamicText;
    }

    public final void setEnableDynamicText(boolean value) {
        this.enableDynamicText = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setGphSettings(new GPHSettings(null, null, false, false, null, null, null, null, false, 0, null, false, false, value, false, null, 57343, null));
    }

    public final boolean getShowViewOnGiphy() {
        return this.showViewOnGiphy;
    }

    public final void setShowViewOnGiphy(boolean value) {
        this.showViewOnGiphy = value;
        GPHMediaPreviewDialog gPHMediaPreviewDialog = this.previewDialog;
        if (gPHMediaPreviewDialog != null) {
            gPHMediaPreviewDialog.setShowViewOnGiphy(value);
        }
    }

    public final boolean getFixedSizeCells() {
        return this.fixedSizeCells;
    }

    public final void setFixedSizeCells(boolean value) {
        this.fixedSizeCells = value;
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setUseFixedSizeCells(value);
    }

    public final boolean getUseInExtensionMode() {
        return this.useInExtensionMode;
    }

    public final void setUseInExtensionMode(boolean bl) {
        this.useInExtensionMode = bl;
    }

    private final void setupGifsRecycler() {
        GphGridViewBinding gphGridViewBinding;
        block3: {
            block2: {
                if (this.useInExtensionMode) break block2;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                if (!GiphyCoreUtils.INSTANCE.runningInExtensionContext(context)) break block3;
            }
            Timber.d((String)"Using extensionsApiClient", (Object[])new Object[0]);
            this.gridViewBinding.gifsRecycler.setApiClient$giphy_ui_2_3_4_release(GiphyCore.INSTANCE.configureSecondaryApiClient("extensionApiClient", GiphyCore.INSTANCE.getApiClient().getApiKey(), false));
        }
        GphGridViewBinding $this$setupGifsRecycler_u24lambda_u2d0 = gphGridViewBinding = this.gridViewBinding;
        boolean bl = false;
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setCellPadding(this.cellPadding);
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setSpanCount(this.spanCount);
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setOrientation(this.direction);
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setOnResultsUpdateListener((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ GiphyGridView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                block0: {
                    GPHGridCallback gPHGridCallback = this.this$0.getCallback();
                    if (gPHGridCallback == null) break block0;
                    gPHGridCallback.contentDidUpdate(it);
                }
            }
        }));
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setOnItemSelectedListener((Function2<? super SmartItemData, ? super Integer, Unit>)((Function2)new Function2<SmartItemData, Integer, Unit>((Object)this){

            public final void invoke(@NotNull SmartItemData p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                GiphyGridView.access$onGifSelected((GiphyGridView)((Object)this.receiver), p0, p1);
            }
        }));
        $this$setupGifsRecycler_u24lambda_u2d0.gifsRecycler.setOnItemLongPressListener((Function2<? super SmartItemData, ? super Integer, Unit>)((Function2)new Function2<SmartItemData, Integer, Unit>((Object)this){

            public final void invoke(@NotNull SmartItemData p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                GiphyGridView.access$onLongPressGif((GiphyGridView)((Object)this.receiver), p0, p1);
            }
        }));
        this.gridViewBinding.gifsRecycler.addOnScrollListener(new RecyclerView.OnScrollListener(this){
            final /* synthetic */ GiphyGridView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    GPHSearchGridCallback gPHSearchGridCallback = this.this$0.getSearchCallback();
                    if (gPHSearchGridCallback == null) break block0;
                    gPHSearchGridCallback.didScroll(dx, dy);
                }
            }
        });
        this.applyRecyclerProperties();
    }

    private final void onGifSelected(SmartItemData itemData, int position) {
        block2: {
            Object object = itemData.getData();
            Media media = object instanceof Media ? (Media)object : null;
            if (media == null) break block2;
            Media media2 = media;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)MediaExtensionKt.isEmoji(media2), (Object)true)) {
                this.onEmojiSelected(itemData, position);
            } else {
                this.deliverGif(itemData, position);
            }
        }
    }

    private final void deliverGif(SmartItemData item, int position) {
        block3: {
            Media media = item.getMediaIfPresent();
            if (media != null) {
                Media it = media;
                boolean bl = false;
                Giphy.INSTANCE.getRecents().addMedia(it);
            }
            if (item.getViewType() != SmartItemType.Gif && item.getViewType() != SmartItemType.Video && item.getViewType() != SmartItemType.DynamicTextWithMoreByYou && item.getViewType() != SmartItemType.DynamicText) break block3;
            Object object = item.getData();
            Media media2 = object instanceof Media ? (Media)object : null;
            if (media2 != null) {
                Media media3 = media2;
                boolean bl = false;
                media3.setBottleData(null);
                GPHGridCallback gPHGridCallback = this.callback;
                if (gPHGridCallback != null) {
                    gPHGridCallback.didSelectMedia(media3);
                }
            }
        }
    }

    private final void onLongPressGif(SmartItemData itemData, int position) {
        Object object;
        GifView it;
        RecyclerView.ViewHolder viewHolder = this.gridViewBinding.gifsRecycler.findViewHolderForAdapterPosition(position);
        View cell = viewHolder != null ? viewHolder.itemView : null;
        GifView gifView = cell instanceof GifView ? (GifView)cell : null;
        if (gifView != null) {
            it = gifView;
            boolean bl = false;
            GPHSearchGridCallback gPHSearchGridCallback = this.searchCallback;
            if (gPHSearchGridCallback != null) {
                gPHSearchGridCallback.didLongPressCell(it);
            }
        }
        if ((object = cell) != null && (object = (GifView)object.findViewById(R.id.gifView)) != null) {
            it = object;
            boolean bl = false;
            GPHSearchGridCallback gPHSearchGridCallback = this.searchCallback;
            if (gPHSearchGridCallback != null) {
                gPHSearchGridCallback.didLongPressCell(it);
            }
        }
        this.showPreviewDialog(itemData, position);
    }

    private final void onEmojiSelected(SmartItemData itemData, int position) {
        Future<?> future = this.fetchEmojiVariationsJob;
        if (future != null) {
            future.cancel(true);
        }
        Media media = itemData.getMediaIfPresent();
        if (media == null) {
            return;
        }
        Media media2 = media;
        Integer n = media2.getVariationCount();
        if ((n != null ? n : 0) > 0) {
            GPHEmojiDrawer emojiDrawer = new GPHEmojiDrawer();
            Integer n2 = media2.getVariationCount();
            int n3 = n2 != null ? n2 : 0;
            ArrayList<Object> arrayList = new ArrayList<Object>(n3);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(null);
            }
            List list = arrayList;
            GiphyGridView.setup$default(this, emojiDrawer, itemData, list, position, false, 16, null);
            emojiDrawer.show();
        } else {
            this.deliverGif(itemData, position);
        }
    }

    private final void setup(GPHEmojiDrawer emojiDrawer, SmartItemData defaultEmojiVariationItem, List<Media> emojiVariations, int position, boolean shouldRequestVariations) {
        Future<?> future = this.fetchEmojiVariationsJob;
        if (future != null) {
            future.cancel(true);
        }
        Object object = defaultEmojiVariationItem.getData();
        Media media = object instanceof Media ? (Media)object : null;
        if (media == null) {
            return;
        }
        Media defaultEmojiVariation = media;
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Context c = context;
        RecyclerView.ViewHolder viewHolder = this.gridViewBinding.gifsRecycler.findViewHolderForAdapterPosition(position);
        View view = viewHolder != null ? viewHolder.itemView : null;
        GifView gifView = view instanceof GifView ? (GifView)view : null;
        if (gifView == null) {
            return;
        }
        GifView anchor = gifView;
        emojiDrawer.setup(c, (View)anchor, (int)((float)anchor.getWidth() * anchor.getScaleX()), (int)((float)anchor.getHeight() * anchor.getScaleY()), Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getEmojiDrawerDividerColor(), Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getEmojiDrawerBackgroundGradientTopColor(), Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getEmojiDrawerBackgroundGradientBottomColor(), CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)defaultEmojiVariation), (Iterable)emojiVariations), (Function0<Unit>)((Function0)new Function0<Unit>(shouldRequestVariations, this, defaultEmojiVariation, emojiDrawer){
            final /* synthetic */ boolean $shouldRequestVariations;
            final /* synthetic */ GiphyGridView this$0;
            final /* synthetic */ Media $defaultEmojiVariation;
            final /* synthetic */ GPHEmojiDrawer $emojiDrawer;
            {
                this.$shouldRequestVariations = $shouldRequestVariations;
                this.this$0 = $receiver;
                this.$defaultEmojiVariation = $defaultEmojiVariation;
                this.$emojiDrawer = $emojiDrawer;
                super(0);
            }

            public final void invoke() {
                if (this.$shouldRequestVariations) {
                    GiphyGridView.access$setFetchEmojiVariationsJob$p(this.this$0, GiphyCore.INSTANCE.getApiClient().emojiVariationsById(this.$defaultEmojiVariation.getId(), (CompletionHandler<? super ListMediaResponse>)new CompletionHandler<ListMediaResponse>(this.$emojiDrawer, this.$defaultEmojiVariation){
                        final /* synthetic */ GPHEmojiDrawer $emojiDrawer;
                        final /* synthetic */ Media $defaultEmojiVariation;
                        {
                            this.$emojiDrawer = $emojiDrawer;
                            this.$defaultEmojiVariation = $defaultEmojiVariation;
                        }

                        public void onComplete(@Nullable ListMediaResponse result, @Nullable Throwable e) {
                            Object resultValue;
                            Object object = result;
                            if (object == null || (object = ((ListMediaResponse)object).getData()) == null) {
                                object = CollectionsKt.emptyList();
                            }
                            if ((resultValue = object).isEmpty()) {
                                return;
                            }
                            this.$emojiDrawer.update(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.$defaultEmojiVariation), (Iterable)((Iterable)resultValue)));
                        }
                    }));
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GiphyGridView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Future future = GiphyGridView.access$getFetchEmojiVariationsJob$p(this.this$0);
                    if (future == null) break block0;
                    future.cancel(true);
                }
            }
        }), (Function1<? super Media, Unit>)((Function1)new Function1<Media, Unit>(this, defaultEmojiVariationItem, position){
            final /* synthetic */ GiphyGridView this$0;
            final /* synthetic */ SmartItemData $defaultEmojiVariationItem;
            final /* synthetic */ int $position;
            {
                this.this$0 = $receiver;
                this.$defaultEmojiVariationItem = $defaultEmojiVariationItem;
                this.$position = $position;
                super(1);
            }

            public final void invoke(@Nullable Media emoji) {
                if (emoji != null) {
                    GiphyGridView.access$getGridViewBinding$p((GiphyGridView)this.this$0).gifsRecycler.getGifTrackingManager$giphy_ui_2_3_4_release().trackMedia(emoji, ActionType.CLICK);
                    GiphyGridView.access$deliverGif(this.this$0, new SmartItemData(SmartItemType.Gif, emoji, this.$defaultEmojiVariationItem.getSpanCount()), this.$position);
                }
            }
        }), (Function1<? super Media, Unit>)((Function1)new Function1<Media, Unit>(emojiDrawer, this, defaultEmojiVariationItem, position){
            final /* synthetic */ GPHEmojiDrawer $emojiDrawer;
            final /* synthetic */ GiphyGridView this$0;
            final /* synthetic */ SmartItemData $defaultEmojiVariationItem;
            final /* synthetic */ int $position;
            {
                this.$emojiDrawer = $emojiDrawer;
                this.this$0 = $receiver;
                this.$defaultEmojiVariationItem = $defaultEmojiVariationItem;
                this.$position = $position;
                super(1);
            }

            public final void invoke(@Nullable Media emoji) {
                this.$emojiDrawer.hide();
                if (emoji != null) {
                    GiphyGridView.access$showPreviewDialog(this.this$0, new SmartItemData(SmartItemType.Gif, emoji, this.$defaultEmojiVariationItem.getSpanCount()), this.$position);
                }
            }
        }));
    }

    static /* synthetic */ void setup$default(GiphyGridView giphyGridView, GPHEmojiDrawer gPHEmojiDrawer, SmartItemData smartItemData, List list, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        giphyGridView.setup(gPHEmojiDrawer, smartItemData, list, n, bl);
    }

    private final void onRemoveRecentGif(String mediaId) {
        if (Intrinsics.areEqual((Object)this.content, (Object)GPHContent.Companion.getRecents())) {
            Giphy.INSTANCE.getRecents().removeGif(mediaId);
            this.gridViewBinding.gifsRecycler.updateContent(GPHContent.Companion.getRecents());
        }
    }

    private final void queryUsername(String username) {
        block1: {
            this.gridViewBinding.gifsRecycler.updateContent(GPHContent.Companion.searchQuery$default(GPHContent.Companion, '@' + username, null, null, 6, null));
            String string2 = username;
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            GPHSearchGridCallback gPHSearchGridCallback = this.searchCallback;
            if (gPHSearchGridCallback != null) {
                gPHSearchGridCallback.didTapUsername(username);
            }
        }
    }

    private final void applyRecyclerProperties() {
        GphGridViewBinding gphGridViewBinding;
        GphGridViewBinding $this$applyRecyclerProperties_u24lambda_u2d8 = gphGridViewBinding = this.gridViewBinding;
        boolean bl = false;
        $this$applyRecyclerProperties_u24lambda_u2d8.gifsRecycler.setCellPadding(this.cellPadding);
        $this$applyRecyclerProperties_u24lambda_u2d8.gifsRecycler.setSpanCount(this.spanCount);
        $this$applyRecyclerProperties_u24lambda_u2d8.gifsRecycler.setOrientation(this.direction);
    }

    private final void showPreviewDialog(SmartItemData itemData, int position) {
        Object object = itemData.getData();
        Media media = object instanceof Media ? (Media)object : null;
        if (media == null) {
            return;
        }
        Media media2 = media;
        Context context = this.getContext();
        FragmentActivity fragmentActivity = context instanceof FragmentActivity ? (FragmentActivity)context : null;
        if (fragmentActivity == null) {
            return;
        }
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"(context as? FragmentAct\u2026n).supportFragmentManager");
        FragmentManager fragmentManager2 = fragmentManager;
        GPHMediaPreviewDialog gPHMediaPreviewDialog = this.previewDialog = GPHMediaPreviewDialog.Companion.newInstance(media2, Intrinsics.areEqual((Object)this.content, (Object)GPHContent.Companion.getRecents()), this.showViewOnGiphy);
        if (gPHMediaPreviewDialog != null) {
            gPHMediaPreviewDialog.show(fragmentManager2, "attribution_quick_view");
        }
        GPHMediaPreviewDialog gPHMediaPreviewDialog2 = this.previewDialog;
        if (gPHMediaPreviewDialog2 != null) {
            gPHMediaPreviewDialog2.setOnShowMore((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

                public final void invoke(@Nullable String p0) {
                    GiphyGridView.access$queryUsername((GiphyGridView)((Object)this.receiver), p0);
                }
            }));
        }
        GPHMediaPreviewDialog gPHMediaPreviewDialog3 = this.previewDialog;
        if (gPHMediaPreviewDialog3 != null) {
            gPHMediaPreviewDialog3.setOnRemoveMedia((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

                public final void invoke(@Nullable String p0) {
                    GiphyGridView.access$onRemoveRecentGif((GiphyGridView)((Object)this.receiver), p0);
                }
            }));
        }
        GPHMediaPreviewDialog gPHMediaPreviewDialog4 = this.previewDialog;
        if (gPHMediaPreviewDialog4 != null) {
            gPHMediaPreviewDialog4.setOnSelectMedia((Function1<? super Media, Unit>)((Function1)new Function1<Media, Unit>(this, media2, itemData, position){
                final /* synthetic */ GiphyGridView this$0;
                final /* synthetic */ Media $media;
                final /* synthetic */ SmartItemData $itemData;
                final /* synthetic */ int $position;
                {
                    this.this$0 = $receiver;
                    this.$media = $media;
                    this.$itemData = $itemData;
                    this.$position = $position;
                    super(1);
                }

                public final void invoke(@NotNull Media it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    GiphyGridView.access$getGridViewBinding$p((GiphyGridView)this.this$0).gifsRecycler.getGifTrackingManager$giphy_ui_2_3_4_release().trackMedia(this.$media, ActionType.CLICK);
                    GiphyGridView.access$deliverGif(this.this$0, this.$itemData, this.$position);
                }
            }));
        }
        this.gridViewBinding.gifsRecycler.getGifTrackingManager$giphy_ui_2_3_4_release().trackMedia(media2, ActionType.LONGPRESS);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Timber.d((String)"onSaveInstanceState", (Object[])new Object[0]);
        return super.onSaveInstanceState();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Timber.d((String)"onAttachedToWindow", (Object[])new Object[0]);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Timber.d((String)"onDetachedFromWindow", (Object[])new Object[0]);
        this.gridViewBinding.gifsRecycler.getGifTrackingManager$giphy_ui_2_3_4_release().reset();
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Timber.d((String)"onRestoreInstanceState", (Object[])new Object[0]);
        super.onRestoreInstanceState(state);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        Timber.d((String)("onWindowFocusChanged " + hasWindowFocus), (Object[])new Object[0]);
        if (hasWindowFocus) {
            this.gridViewBinding.gifsRecycler.getGifTrackingManager$giphy_ui_2_3_4_release().updateTracking();
        }
    }

    public final void setGiphyLoadingProvider(@NotNull GiphyLoadingProvider loadingProvider) {
        Intrinsics.checkNotNullParameter((Object)loadingProvider, (String)"loadingProvider");
        this.gridViewBinding.gifsRecycler.getGifsAdapter().getAdapterHelper().setGifLoadingDrawableProvider(loadingProvider);
    }

    @JvmOverloads
    public GiphyGridView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GiphyGridView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setFetchEmojiVariationsJob$p(GiphyGridView $this, Future future) {
        $this.fetchEmojiVariationsJob = future;
    }

    public static final /* synthetic */ Future access$getFetchEmojiVariationsJob$p(GiphyGridView $this) {
        return $this.fetchEmojiVariationsJob;
    }

    public static final /* synthetic */ GphGridViewBinding access$getGridViewBinding$p(GiphyGridView $this) {
        return $this.gridViewBinding;
    }

    public static final /* synthetic */ void access$deliverGif(GiphyGridView $this, SmartItemData item, int position) {
        $this.deliverGif(item, position);
    }

    public static final /* synthetic */ void access$showPreviewDialog(GiphyGridView $this, SmartItemData itemData, int position) {
        $this.showPreviewDialog(itemData, position);
    }

    public static final /* synthetic */ void access$queryUsername(GiphyGridView $this, String username) {
        $this.queryUsername(username);
    }

    public static final /* synthetic */ void access$onRemoveRecentGif(GiphyGridView $this, String mediaId) {
        $this.onRemoveRecentGif(mediaId);
    }

    public static final /* synthetic */ void access$onGifSelected(GiphyGridView $this, SmartItemData itemData, int position) {
        $this.onGifSelected(itemData, position);
    }

    public static final /* synthetic */ void access$onLongPressGif(GiphyGridView $this, SmartItemData itemData, int position) {
        $this.onLongPressGif(itemData, position);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/giphy/sdk/ui/views/GiphyGridView$Companion;", "", "()V", "HORIZONTAL", "", "VERTICAL", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

