/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphVideoPlayerViewBinding;
import com.giphy.sdk.ui.utils.GPHAbstractVideoPlayer;
import com.giphy.sdk.ui.utils.GPHVideoPlayerState;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.utils.MediaExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010I\u001a\u00020\u001cH\u0002J\b\u0010J\u001a\u00020\u001cH\u0016J\u0006\u0010K\u001a\u00020\u001cJ\u0006\u0010L\u001a\u00020\u001cJ\b\u0010M\u001a\u00020\u001cH\u0016J\u0018\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u0007H\u0014J\u0006\u0010Q\u001a\u00020\u001cJ\u000e\u0010R\u001a\u00020\u001c2\u0006\u0010S\u001a\u000202J\u0006\u0010T\u001a\u00020\u001cJ\u000e\u0010U\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(J\u0018\u0010V\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u000200H\u0016J\b\u0010W\u001a\u00020\u001cH\u0016J\u0014\u0010X\u001a\u00020\u001c2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u001c0ZR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aj\u0002`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\u0013R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010,\"\u0004\b:\u0010.R(\u0010<\u001a\u0004\u0018\u0001002\b\u0010;\u001a\u0004\u0018\u0001008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R(\u0010B\u001a\u0004\u0018\u00010A2\b\u0010;\u001a\u0004\u0018\u00010A@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cornerRadius", "", "getCornerRadius", "()F", "setCornerRadius", "(F)V", "desiredHeight", "getDesiredHeight", "()I", "setDesiredHeight", "(I)V", "desiredWidth", "getDesiredWidth", "setDesiredWidth", "isFirstLoading", "", "listener", "Lkotlin/Function1;", "Lcom/giphy/sdk/ui/utils/GPHVideoPlayerState;", "", "Lcom/giphy/sdk/ui/utils/GPHPlayerStateListener;", "loopCount", "maxHeight", "getMaxHeight", "setMaxHeight", "maxLoopsBeforeMute", "getMaxLoopsBeforeMute", "setMaxLoopsBeforeMute", "measureAndLayout", "Ljava/lang/Runnable;", "media", "Lcom/giphy/sdk/core/models/Media;", "params", "Landroid/widget/FrameLayout$LayoutParams;", "getParams", "()Landroid/widget/FrameLayout$LayoutParams;", "setParams", "(Landroid/widget/FrameLayout$LayoutParams;)V", "player", "Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "prepareTime", "", "showControls", "getShowControls", "()Z", "setShowControls", "(Z)V", "titleParams", "getTitleParams", "setTitleParams", "value", "videoPlayer", "getVideoPlayer", "()Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "setVideoPlayer", "(Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;)V", "", "videoTitle", "getVideoTitle", "()Ljava/lang/String;", "setVideoTitle", "(Ljava/lang/String;)V", "viewBinding", "Lcom/giphy/sdk/ui/databinding/GphVideoPlayerViewBinding;", "addOutline", "didBecomeActiveByClick", "enterSharingMode", "exitSharingMode", "onDestroy", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPause", "onProgress", "position", "onResume", "preloadFirstFrame", "prepare", "requestLayout", "setPreviewMode", "onClick", "Lkotlin/Function0;", "giphy-ui-2.3.4_release"})
public class GPHVideoPlayerView
extends FrameLayout {
    private boolean isFirstLoading;
    private long prepareTime;
    private boolean showControls;
    private int loopCount;
    private int maxLoopsBeforeMute;
    private float cornerRadius;
    private int desiredWidth;
    private int desiredHeight;
    private int maxHeight;
    @Nullable
    private String videoTitle;
    private GPHAbstractVideoPlayer player;
    @Nullable
    private Media media;
    @NotNull
    private final Function1<GPHVideoPlayerState, Unit> listener;
    @NotNull
    private final GphVideoPlayerViewBinding viewBinding;
    @NotNull
    private final Runnable measureAndLayout;
    @NotNull
    private FrameLayout.LayoutParams params;
    @NotNull
    private FrameLayout.LayoutParams titleParams;

    @JvmOverloads
    public GPHVideoPlayerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        GradientDrawable gradientDrawable;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.showControls = true;
        this.maxLoopsBeforeMute = 3;
        this.cornerRadius = IntExtensionsKt.getPx(0);
        this.desiredWidth = IntExtensionsKt.getPx(200);
        this.desiredHeight = IntExtensionsKt.getPx(112);
        this.maxHeight = Integer.MAX_VALUE;
        this.listener = (Function1)new Function1<GPHVideoPlayerState, Unit>(this){
            final /* synthetic */ GPHVideoPlayerView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GPHVideoPlayerState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GPHAbstractVideoPlayer gPHAbstractVideoPlayer = GPHVideoPlayerView.access$getPlayer$p(this.this$0);
                if (gPHAbstractVideoPlayer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                    gPHAbstractVideoPlayer = null;
                }
                Media media = GPHVideoPlayerView.access$getMedia$p(this.this$0);
                if (Intrinsics.areEqual((Object)gPHAbstractVideoPlayer.getMedia().getId(), (Object)(media != null ? media.getId() : null))) {
                    GPHVideoPlayerState gPHVideoPlayerState = it;
                    if (gPHVideoPlayerState instanceof GPHVideoPlayerState.Error) {
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).bufferingAnimation.setVisibility(8);
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).videoControls.setVisibility(8);
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).errorView.setVisibility(0);
                    } else if (Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Ready.INSTANCE)) {
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).videoControls.setAlpha(1.0f);
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).bufferingAnimation.setVisibility(8);
                        if (GPHVideoPlayerView.access$isFirstLoading$p(this.this$0)) {
                            Timber.d((String)("initialLoadTime=" + (SystemClock.elapsedRealtime() - GPHVideoPlayerView.access$getPrepareTime$p(this.this$0))), (Object[])new Object[0]);
                            GPHVideoPlayerView.access$setFirstLoading$p(this.this$0, false);
                        }
                    } else if (Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Playing.INSTANCE)) {
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).videoControls.setAlpha(1.0f);
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).surfaceView.setVisibility(0);
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).initialImage.setVisibility(8);
                    } else if (Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Buffering.INSTANCE)) {
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).bufferingAnimation.setVisibility(0);
                    } else if (Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Repeated.INSTANCE)) {
                        if (GPHVideoPlayerView.access$getLoopCount$p(this.this$0) + 1 > this.this$0.getMaxLoopsBeforeMute() - 1) {
                            GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = GPHVideoPlayerView.access$getPlayer$p(this.this$0);
                            if (gPHAbstractVideoPlayer2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                                gPHAbstractVideoPlayer2 = null;
                            }
                            gPHAbstractVideoPlayer2.setVolume(0.0f);
                        } else {
                            GPHAbstractVideoPlayer gPHAbstractVideoPlayer3 = GPHVideoPlayerView.access$getPlayer$p(this.this$0);
                            if (gPHAbstractVideoPlayer3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                                gPHAbstractVideoPlayer3 = null;
                            }
                            if (gPHAbstractVideoPlayer3.getVolume() > 0.0f) {
                                GPHVideoPlayerView gPHVideoPlayerView = this.this$0;
                                GPHVideoPlayerView.access$setLoopCount$p(gPHVideoPlayerView, GPHVideoPlayerView.access$getLoopCount$p(gPHVideoPlayerView) + 1);
                            }
                        }
                    } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.MuteChanged) {
                        if (!((GPHVideoPlayerState.MuteChanged)it).getMuted()) {
                            GPHVideoPlayerView.access$setLoopCount$p(this.this$0, 0);
                        }
                    } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.CaptionsTextChanged) {
                        if (((CharSequence)((GPHVideoPlayerState.CaptionsTextChanged)it).getSubtitle()).length() == 0) {
                            GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).subtitles.setPadding(IntExtensionsKt.getPx(0), IntExtensionsKt.getPx(0), IntExtensionsKt.getPx(0), IntExtensionsKt.getPx(0));
                        } else {
                            GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).subtitles.setPadding(IntExtensionsKt.getPx(8), IntExtensionsKt.getPx(4), IntExtensionsKt.getPx(8), IntExtensionsKt.getPx(6));
                        }
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).subtitles.setText((CharSequence)((GPHVideoPlayerState.CaptionsTextChanged)it).getSubtitle());
                    } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.CaptionsVisibilityChanged) {
                        GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).subtitles.setVisibility(((GPHVideoPlayerState.CaptionsVisibilityChanged)it).getVisible() ? 0 : 4);
                    }
                } else if (it instanceof GPHVideoPlayerState.MediaChanged) {
                    GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).initialImage.setVisibility(0);
                    GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).surfaceView.setVisibility(8);
                    GPHVideoPlayerView.access$getViewBinding$p((GPHVideoPlayerView)this.this$0).bufferingAnimation.setVisibility(8);
                }
            }
        };
        GphVideoPlayerViewBinding gphVideoPlayerViewBinding = GphVideoPlayerViewBinding.bind(View.inflate((Context)context, (int)R.layout.gph_video_player_view, (ViewGroup)((ViewGroup)this)));
        Intrinsics.checkNotNullExpressionValue((Object)gphVideoPlayerViewBinding, (String)"bind(View.inflate(contex\u2026video_player_view, this))");
        this.viewBinding = gphVideoPlayerViewBinding;
        this.viewBinding.initialImage.setLegacyVisibilityHandlingEnabled(true);
        GradientDrawable $this$_init__u24lambda_u2d0 = gradientDrawable = new GradientDrawable();
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setShape(0);
        $this$_init__u24lambda_u2d0.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getCaptionsBackgroundColor());
        $this$_init__u24lambda_u2d0.setCornerRadius(8.0f);
        this.viewBinding.subtitles.setBackground((Drawable)$this$_init__u24lambda_u2d0);
        this.viewBinding.subtitles.setTextSize(13.0f);
        this.viewBinding.title.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        this.viewBinding.title.setTextColor(-6579301);
        this.viewBinding.title.setTextSize(18.0f);
        this.viewBinding.titleView.setVisibility(this.videoTitle != null ? 0 : 8);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.GPHVideoPlayerView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026GPHVideoPlayerView, 0, 0)");
        TypedArray array = typedArray;
        this.showControls = array.getBoolean(R.styleable.GPHVideoPlayerView_gphShowControls, true);
        this.viewBinding.videoControls.setVisibility(this.showControls ? 0 : 8);
        array.recycle();
        this.measureAndLayout = () -> GPHVideoPlayerView.measureAndLayout$lambda-1(this);
        this.params = new FrameLayout.LayoutParams(0, 0, 17);
        this.titleParams = new FrameLayout.LayoutParams(0, 0, 17);
    }

    public /* synthetic */ GPHVideoPlayerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getShowControls() {
        return this.showControls;
    }

    public final void setShowControls(boolean bl) {
        this.showControls = bl;
    }

    public final int getMaxLoopsBeforeMute() {
        return this.maxLoopsBeforeMute;
    }

    public final void setMaxLoopsBeforeMute(int n) {
        this.maxLoopsBeforeMute = n;
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(float f) {
        this.cornerRadius = f;
    }

    public final int getDesiredWidth() {
        return this.desiredWidth;
    }

    public final void setDesiredWidth(int n) {
        this.desiredWidth = n;
    }

    public final int getDesiredHeight() {
        return this.desiredHeight;
    }

    public final void setDesiredHeight(int n) {
        this.desiredHeight = n;
    }

    public final int getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    @Nullable
    public final String getVideoTitle() {
        return this.videoTitle;
    }

    public final void setVideoTitle(@Nullable String value) {
        this.videoTitle = value;
        this.requestLayout();
        this.viewBinding.title.setText((CharSequence)value);
        this.viewBinding.titleView.setVisibility(value != null ? 0 : 8);
    }

    @Nullable
    public final GPHAbstractVideoPlayer getVideoPlayer() {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer;
        if (this.player != null) {
            gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
        } else {
            gPHAbstractVideoPlayer = null;
        }
        return gPHAbstractVideoPlayer;
    }

    public final void setVideoPlayer(@Nullable GPHAbstractVideoPlayer value) {
        if (value == null) {
            throw new NullPointerException("videoPlayer must not be null");
        }
        this.player = value;
    }

    public final void preloadFirstFrame(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.media = media;
        Image image = media.getImages().getOriginalStill();
        Timber.d((String)("preloadFirstFrame " + (image != null ? image.getGifUrl() : null)), (Object[])new Object[0]);
        Image image2 = media.getImages().getOriginalStill();
        this.viewBinding.initialImage.setImageURI(image2 != null ? image2.getGifUrl() : null);
        this.viewBinding.initialImage.setVisibility(0);
    }

    public void prepare(@NotNull Media media, @NotNull GPHAbstractVideoPlayer player) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.loopCount = 0;
        this.player = player;
        this.media = media;
        this.prepareTime = SystemClock.elapsedRealtime();
        player.setVideoSurfaceView(this.viewBinding.surfaceView);
        this.isFirstLoading = true;
        this.viewBinding.subtitles.setText((CharSequence)"");
        this.viewBinding.errorView.setVisibility(8);
        this.viewBinding.bufferingAnimation.setVisibility(8);
        this.viewBinding.videoControls.setAlpha(0.0f);
        this.viewBinding.initialImage.setVisibility(0);
        this.requestLayout();
        player.addListener(this.listener);
        this.viewBinding.subtitles.setVisibility(player.getShowCaptions() ? 0 : 4);
        if (this.showControls) {
            this.viewBinding.videoControls.prepare(media, player, this);
        }
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    @NotNull
    public final FrameLayout.LayoutParams getParams() {
        return this.params;
    }

    public final void setParams(@NotNull FrameLayout.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<set-?>");
        this.params = layoutParams;
    }

    @NotNull
    public final FrameLayout.LayoutParams getTitleParams() {
        return this.titleParams;
    }

    public final void setTitleParams(@NotNull FrameLayout.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<set-?>");
        this.titleParams = layoutParams;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.media == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        Media media = this.media;
        float aspectRatio = media != null ? MediaExtensionKt.getVideoAspectRatio(media) : 1.7777778f;
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = (int)((float)height * aspectRatio);
        if (height == 0) {
            if (width == 0) {
                width = this.desiredWidth;
            }
            height = (int)((float)width / aspectRatio);
        } else if (width == 0) {
            if (height == 0) {
                height = this.desiredHeight;
            }
            width = (int)((float)height * aspectRatio);
        }
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (width > measureWidth && measureWidth > 0) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            height = (int)((float)width / aspectRatio);
        }
        if (height > this.maxHeight) {
            height = this.maxHeight;
            width = (int)((float)height * aspectRatio);
        }
        if (width < 600) {
            this.viewBinding.subtitles.setTextSize(6.0f);
        } else {
            this.viewBinding.subtitles.setTextSize(13.0f);
        }
        if (this.videoTitle != null && height >= width) {
            this.params.height = height - IntExtensionsKt.getPx(55);
            this.params.width = (int)((float)this.params.height * aspectRatio);
        } else {
            this.params.height = height;
            this.params.width = width;
        }
        this.viewBinding.surfaceView.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.viewBinding.initialImage.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.viewBinding.bufferingAnimation.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.viewBinding.videoControls.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.viewBinding.errorView.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.viewBinding.subtitlesView.setLayoutParams((ViewGroup.LayoutParams)this.params);
        if (this.videoTitle != null) {
            this.titleParams.height = height >= width ? height : height + IntExtensionsKt.getPx(55);
            this.titleParams.width = width;
            this.viewBinding.titleView.setLayoutParams((ViewGroup.LayoutParams)this.titleParams);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        this.addOutline();
    }

    private final void addOutline() {
        if (Build.VERSION.SDK_INT >= 21 && this.cornerRadius > 0.0f) {
            this.setOutlineProvider(new ViewOutlineProvider(this){
                final /* synthetic */ GPHVideoPlayerView this$0;
                {
                    this.this$0 = $receiver;
                }

                public void getOutline(@NotNull View view, @NotNull Outline outline) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                    outline.setRoundRect(0, 0, this.this$0.getWidth(), this.this$0.getHeight(), this.this$0.getCornerRadius());
                }
            });
            this.setClipToOutline(true);
        }
    }

    public final void onProgress(long position) {
        this.viewBinding.videoControls.updateProgress(position);
    }

    public final void enterSharingMode() {
        this.viewBinding.videoControls.setVisibility(8);
    }

    public final void exitSharingMode() {
        this.viewBinding.videoControls.setVisibility(0);
    }

    public final void onResume() {
        this.viewBinding.videoControls.setVisibility(0);
        this.viewBinding.videoControls.onResume();
    }

    public void onDestroy() {
        if (this.player != null) {
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
            gPHAbstractVideoPlayer.removeListener(this.listener);
        }
    }

    public final void onPause() {
        this.viewBinding.videoControls.onPause();
    }

    public void didBecomeActiveByClick() {
    }

    public final void setPreviewMode(@NotNull Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.viewBinding.videoControls.setPreviewMode(onClick);
    }

    @JvmOverloads
    public GPHVideoPlayerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GPHVideoPlayerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void measureAndLayout$lambda-1(GPHVideoPlayerView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.measure(View.MeasureSpec.makeMeasureSpec((int)this$0.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this$0.getHeight(), (int)0x40000000));
        this$0.layout(this$0.getLeft(), this$0.getTop(), this$0.getRight(), this$0.getBottom());
    }

    public static final /* synthetic */ GPHAbstractVideoPlayer access$getPlayer$p(GPHVideoPlayerView $this) {
        return $this.player;
    }

    public static final /* synthetic */ Media access$getMedia$p(GPHVideoPlayerView $this) {
        return $this.media;
    }

    public static final /* synthetic */ GphVideoPlayerViewBinding access$getViewBinding$p(GPHVideoPlayerView $this) {
        return $this.viewBinding;
    }

    public static final /* synthetic */ boolean access$isFirstLoading$p(GPHVideoPlayerView $this) {
        return $this.isFirstLoading;
    }

    public static final /* synthetic */ long access$getPrepareTime$p(GPHVideoPlayerView $this) {
        return $this.prepareTime;
    }

    public static final /* synthetic */ void access$setFirstLoading$p(GPHVideoPlayerView $this, boolean bl) {
        $this.isFirstLoading = bl;
    }

    public static final /* synthetic */ int access$getLoopCount$p(GPHVideoPlayerView $this) {
        return $this.loopCount;
    }

    public static final /* synthetic */ void access$setLoopCount$p(GPHVideoPlayerView $this, int n) {
        $this.loopCount = n;
    }
}

