/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphVideoControlsViewBinding;
import com.giphy.sdk.ui.utils.GPHAbstractVideoPlayer;
import com.giphy.sdk.ui.utils.GPHVideoPlayerState;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 A2\u00020\u0001:\u0001AB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\"\u001a\u00020\u0016H\u0002J\u0012\u0010#\u001a\u00020\u00162\b\b\u0002\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0016H\u0014J\u0006\u0010'\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020\u0016J\b\u0010)\u001a\u00020\u0016H\u0002J\u001e\u0010*\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010+\u001a\u00020\u0016H\u0002J\b\u0010,\u001a\u00020\u0016H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020%H\u0002J\u0010\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0002J\u0014\u00102\u001a\u00020\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001604J\b\u00105\u001a\u00020\u0016H\u0003J\b\u00106\u001a\u00020\u0016H\u0002J0\u00107\u001a\u00020\u00162\b\b\u0002\u00108\u001a\u00020\f2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010,\u001a\u00020\f2\b\b\u0002\u0010:\u001a\u00020\fH\u0002J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\fH\u0002J\u0010\u0010=\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020%J\b\u0010@\u001a\u00020\u0016H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u0002`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/giphy/sdk/ui/views/GPHVideoControls;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "clickJob", "Lkotlinx/coroutines/Job;", "firstStart", "", "hideControlsAnimation", "Landroidx/core/view/ViewPropertyAnimatorCompat;", "hideSeekOverlayAnimation", "isDoubleClickPossible", "lastTouchX", "", "listener", "Lkotlin/Function1;", "Lcom/giphy/sdk/ui/utils/GPHVideoPlayerState;", "", "Lcom/giphy/sdk/ui/utils/GPHPlayerStateListener;", "media", "Lcom/giphy/sdk/core/models/Media;", "pause", "player", "Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "playerView", "Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "previewMode", "viewBinding", "Lcom/giphy/sdk/ui/databinding/GphVideoControlsViewBinding;", "fastForward", "hideControls", "delay", "", "onAttachedToWindow", "onPause", "onResume", "performOnClick", "prepare", "resumeVideo", "rewind", "seek", "position", "sendAnalytics", "event", "", "setPreviewMode", "onClick", "Lkotlin/Function0;", "setupTouchListeners", "showAndHideSeekOverlay", "showControls", "progress", "sound", "forward", "updateCaptionsIcon", "visible", "updatePauseState", "updateProgress", "milliseconds", "updateSoundModeIcon", "Companion", "giphy-ui-2.3.4_release"})
public final class GPHVideoControls
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean firstStart;
    private boolean previewMode;
    private GPHAbstractVideoPlayer player;
    private Media media;
    @Nullable
    private ViewPropertyAnimatorCompat hideControlsAnimation;
    @Nullable
    private ViewPropertyAnimatorCompat hideSeekOverlayAnimation;
    private float lastTouchX;
    private boolean isDoubleClickPossible;
    @Nullable
    private Job clickJob;
    private boolean pause;
    @Nullable
    private GPHVideoPlayerView playerView;
    @NotNull
    private final GphVideoControlsViewBinding viewBinding;
    @NotNull
    private final Function1<GPHVideoPlayerState, Unit> listener;
    private static final int FOWARD_REWIND_INTERVAL = 5000;
    private static final long DOUBLE_TOUCH_INTERVAL = 250L;
    private static final long HIDE_CONTROLS_DELAY = 2000L;
    private static final long HIDE_CONTROLS_INITIAL_DELAY = 3000L;
    private static final long HIDE_CONTROLS_DURATION = 400L;

    @JvmOverloads
    public GPHVideoControls(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.pause = true;
        GphVideoControlsViewBinding gphVideoControlsViewBinding = GphVideoControlsViewBinding.bind(ConstraintLayout.inflate((Context)context, (int)R.layout.gph_video_controls_view, (ViewGroup)((ViewGroup)this)));
        Intrinsics.checkNotNullExpressionValue((Object)gphVideoControlsViewBinding, (String)"bind(\n            Constr\u2026s\n            )\n        )");
        this.viewBinding = gphVideoControlsViewBinding;
        this.listener = (Function1)new Function1<GPHVideoPlayerState, Unit>(this){
            final /* synthetic */ GPHVideoControls this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GPHVideoPlayerState playerState) {
                Intrinsics.checkNotNullParameter((Object)playerState, (String)"playerState");
                GPHVideoPlayerState gPHVideoPlayerState = playerState;
                if ((Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Idle.INSTANCE) ? true : Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Buffering.INSTANCE)) ? true : Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Ended.INSTANCE)) {
                    GPHVideoControls.access$getViewBinding$p((GPHVideoControls)this.this$0).progressBar.setVisibility(4);
                } else if (Intrinsics.areEqual((Object)gPHVideoPlayerState, (Object)GPHVideoPlayerState.Playing.INSTANCE)) {
                    GPHVideoControls.access$setPause$p(this.this$0, false);
                    GPHVideoControls.access$getViewBinding$p((GPHVideoControls)this.this$0).progressBar.setVisibility(0);
                    if (GPHVideoControls.access$getFirstStart$p(this.this$0)) {
                        GPHVideoControls.access$setFirstStart$p(this.this$0, false);
                        GPHVideoControls.access$hideControls(this.this$0, 3000L);
                    } else {
                        GPHVideoControls.hideControls$default(this.this$0, 0L, 1, null);
                    }
                } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.TimelineChanged) {
                    if (((GPHVideoPlayerState.TimelineChanged)playerState).getDuration() > 0L) {
                        ProgressBar progressBar = GPHVideoControls.access$getViewBinding$p((GPHVideoControls)this.this$0).progressBar;
                        long l = (long)100 * ((GPHVideoPlayerState.TimelineChanged)playerState).getDuration();
                        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = GPHVideoControls.access$getPlayer$p(this.this$0);
                        if (gPHAbstractVideoPlayer == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                            gPHAbstractVideoPlayer = null;
                        }
                        progressBar.setProgress((int)(l / gPHAbstractVideoPlayer.getDuration()));
                    }
                } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.MuteChanged) {
                    GPHVideoControls.access$updateSoundModeIcon(this.this$0);
                } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.CaptionsVisibilityChanged) {
                    GPHVideoControls.access$updateCaptionsIcon(this.this$0, ((GPHVideoPlayerState.CaptionsVisibilityChanged)playerState).getVisible());
                } else if (gPHVideoPlayerState instanceof GPHVideoPlayerState.CaptionsTextChanged) {
                    GPHVideoControls.access$getViewBinding$p((GPHVideoControls)this.this$0).captionsButton.setVisibility(0);
                }
            }
        };
        this.setupTouchListeners();
        this.viewBinding.soundButton.setClickable(false);
        this.viewBinding.soundButtonOff.setClickable(false);
        this.viewBinding.captionsButton.setOnClickListener(arg_0 -> GPHVideoControls._init_$lambda-0(this, arg_0));
    }

    public /* synthetic */ GPHVideoControls(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void prepare(@NotNull Media media, @NotNull GPHAbstractVideoPlayer player, @NotNull GPHVideoPlayerView playerView) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)playerView), (String)"playerView");
        this.viewBinding.captionsButton.setVisibility(8);
        this.media = media;
        this.player = player;
        this.firstStart = true;
        this.playerView = playerView;
        this.updateSoundModeIcon();
        this.updateCaptionsIcon(player.getShowCaptions());
        player.addListener(this.listener);
        GPHVideoControls.showControls$default(this, true, true, false, false, 12, null);
    }

    private final void resumeVideo() {
        this.pause = false;
        this.updatePauseState(this.pause);
        Job job = this.clickJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.clickJob = null;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void setupTouchListeners() {
        this.setOnClickListener(arg_0 -> GPHVideoControls.setupTouchListeners$lambda-1(this, arg_0));
    }

    public final void onPause() {
        this.pause = true;
    }

    public final void onResume() {
        this.pause = false;
    }

    private final void updatePauseState(boolean pause) {
        if (this.player == null) {
            return;
        }
        if (pause) {
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
            gPHAbstractVideoPlayer.onPause();
        } else {
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
            gPHAbstractVideoPlayer.onResume();
        }
    }

    private final void sendAnalytics(String event) {
    }

    private final void performOnClick() {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer;
        this.isDoubleClickPossible = false;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
        if (gPHAbstractVideoPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer2 = null;
        }
        if ((gPHAbstractVideoPlayer = this.player) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        gPHAbstractVideoPlayer2.setVolume(gPHAbstractVideoPlayer.getVolume() > 0.0f ? 0.0f : 1.0f);
        GPHVideoControls.showControls$default(this, true, true, false, false, 12, null);
    }

    private final void rewind() {
        this.viewBinding.rewindIcon.playAnimation();
        long l = 0L;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        long l2 = gPHAbstractVideoPlayer.getCurrentPosition() - (long)5000;
        this.seek(Math.max(l, l2));
        GPHVideoControls.showControls$default(this, true, false, true, false, 10, null);
    }

    private final void fastForward() {
        this.viewBinding.forwardIcon.playAnimation();
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        long l = gPHAbstractVideoPlayer.getDuration();
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
        if (gPHAbstractVideoPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer2 = null;
        }
        long l2 = gPHAbstractVideoPlayer2.getCurrentPosition() + (long)5000;
        this.seek(Math.min(l, l2));
        GPHVideoControls.showControls$default(this, true, false, false, true, 6, null);
    }

    private final void seek(long position) {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        gPHAbstractVideoPlayer.seekTo(position);
        ProgressBar progressBar = this.viewBinding.progressBar;
        long l = 100;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
        if (gPHAbstractVideoPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer2 = null;
        }
        long l2 = l * gPHAbstractVideoPlayer2.getCurrentPosition();
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer3 = this.player;
        if (gPHAbstractVideoPlayer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer3 = null;
        }
        progressBar.setProgress((int)(l2 / gPHAbstractVideoPlayer3.getDuration()));
        this.showAndHideSeekOverlay();
    }

    private final void showAndHideSeekOverlay() {
        block1: {
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = this.hideSeekOverlayAnimation;
            if (viewPropertyAnimatorCompat != null) {
                viewPropertyAnimatorCompat.cancel();
            }
            this.viewBinding.seekOverlay.setVisibility(0);
            this.viewBinding.seekOverlay.setAlpha(1.0f);
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat2 = this.hideSeekOverlayAnimation = ViewCompat.animate((View)this.viewBinding.seekOverlay).alpha(0.0f).withEndAction(() -> GPHVideoControls.showAndHideSeekOverlay$lambda-2(this)).setDuration(250L).setStartDelay(1000L);
            if (viewPropertyAnimatorCompat2 == null) break block1;
            viewPropertyAnimatorCompat2.start();
        }
    }

    public final void setPreviewMode(@NotNull Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.previewMode = true;
        this.setOnClickListener(arg_0 -> GPHVideoControls.setPreviewMode$lambda-3(onClick, arg_0));
        this.setOnTouchListener(GPHVideoControls::setPreviewMode$lambda-4);
        GPHVideoControls.showControls$default(this, false, true, false, false, 13, null);
    }

    private final void showControls(boolean progress, boolean sound, boolean rewind, boolean forward) {
        Timber.d((String)"showControls", (Object[])new Object[0]);
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = this.hideControlsAnimation;
        if (viewPropertyAnimatorCompat != null) {
            viewPropertyAnimatorCompat.cancel();
        }
        this.hideControlsAnimation = null;
        this.viewBinding.controls.setAlpha(1.0f);
        this.viewBinding.controls.setVisibility(0);
        this.viewBinding.soundButton.setVisibility(sound ? 0 : 8);
        this.viewBinding.progressBar.setVisibility(progress ? 0 : 8);
        this.viewBinding.rewindIcon.setVisibility(rewind ? 0 : 8);
        this.viewBinding.forwardIcon.setVisibility(forward ? 0 : 8);
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        if (gPHAbstractVideoPlayer.isPlaying()) {
            GPHVideoControls.hideControls$default(this, 0L, 1, null);
        }
    }

    static /* synthetic */ void showControls$default(GPHVideoControls gPHVideoControls, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        gPHVideoControls.showControls(bl, bl2, bl3, bl4);
    }

    private final void hideControls(long delay) {
        block2: {
            Timber.d((String)"hideControls", (Object[])new Object[0]);
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = this.hideControlsAnimation;
            if (viewPropertyAnimatorCompat != null) {
                viewPropertyAnimatorCompat.cancel();
            }
            this.hideControlsAnimation = null;
            if (this.previewMode) {
                return;
            }
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat2 = this.hideControlsAnimation = ViewCompat.animate((View)((View)this.viewBinding.controls)).alpha(0.0f).withEndAction(() -> GPHVideoControls.hideControls$lambda-5(this)).setDuration(400L).setStartDelay(delay);
            if (viewPropertyAnimatorCompat2 == null) break block2;
            viewPropertyAnimatorCompat2.start();
        }
    }

    static /* synthetic */ void hideControls$default(GPHVideoControls gPHVideoControls, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2000L;
        }
        gPHVideoControls.hideControls(l);
    }

    public final void updateProgress(long milliseconds) {
        ProgressBar progressBar = this.viewBinding.progressBar;
        long l = (long)100 * milliseconds;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        progressBar.setProgress((int)(l / gPHAbstractVideoPlayer.getDuration()));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateSoundModeIcon();
    }

    private final void updateSoundModeIcon() {
        if (this.player != null) {
            ImageButton imageButton = this.viewBinding.soundButton;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
            imageButton.setImageResource(gPHAbstractVideoPlayer.getVolume() > 0.0f ? R.drawable.gph_ic_sound : R.drawable.gph_ic_no_sound);
            ImageButton imageButton2 = this.viewBinding.soundButtonOff;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
            if (gPHAbstractVideoPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer2 = null;
            }
            imageButton2.setVisibility(gPHAbstractVideoPlayer2.getVolume() == 0.0f ? 0 : 8);
        }
    }

    private final void updateCaptionsIcon(boolean visible) {
        this.viewBinding.captionsButton.setImageResource(visible ? R.drawable.gph_ic_caption_on : R.drawable.gph_ic_caption_off);
    }

    @JvmOverloads
    public GPHVideoControls(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GPHVideoControls(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _init_$lambda-0(GPHVideoControls this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.player != null) {
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this$0.player;
            if (gPHAbstractVideoPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer2 = null;
            }
            if ((gPHAbstractVideoPlayer = this$0.player) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer = null;
            }
            gPHAbstractVideoPlayer2.setShowCaptions(!gPHAbstractVideoPlayer.getShowCaptions());
            GPHVideoControls.showControls$default(this$0, true, true, false, false, 12, null);
        }
    }

    private static final void setupTouchListeners$lambda-1(GPHVideoControls this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this$0.player;
        if (gPHAbstractVideoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            gPHAbstractVideoPlayer = null;
        }
        String string2 = gPHAbstractVideoPlayer.getMedia().getId();
        Media media = this$0.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        if (!Intrinsics.areEqual((Object)string2, (Object)media.getId())) {
            Media media2;
            GPHVideoPlayerView gPHVideoPlayerView = this$0.playerView;
            if (gPHVideoPlayerView != null) {
                gPHVideoPlayerView.didBecomeActiveByClick();
            }
            this$0.pause = false;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this$0.player;
            if (gPHAbstractVideoPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer2 = null;
            }
            if ((media2 = this$0.media) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"media");
                media2 = null;
            }
            GPHVideoPlayerView gPHVideoPlayerView2 = this$0.playerView;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer3 = this$0.player;
            if (gPHAbstractVideoPlayer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                gPHAbstractVideoPlayer3 = null;
            }
            GPHAbstractVideoPlayer.loadMedia$default(gPHAbstractVideoPlayer2, media2, false, gPHVideoPlayerView2, gPHAbstractVideoPlayer3.getRepeatable(), 2, null);
            return;
        }
        if (this$0.pause) {
            this$0.resumeVideo();
            return;
        }
        int doubleTouchSize = this$0.getWidth() / 3;
        if (this$0.lastTouchX < (float)doubleTouchSize || this$0.lastTouchX > (float)(this$0.getWidth() - doubleTouchSize)) {
            if (this$0.isDoubleClickPossible) {
                if (this$0.lastTouchX < (float)doubleTouchSize) {
                    this$0.rewind();
                } else {
                    this$0.fastForward();
                }
                Job job = this$0.clickJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                }
                this$0.clickJob = null;
            } else {
                this$0.clickJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                    int label;
                    final /* synthetic */ GPHVideoControls this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay((long)250L, (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                GPHVideoControls.access$performOnClick(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            this$0.isDoubleClickPossible = !this$0.isDoubleClickPossible;
        } else {
            Job job = this$0.clickJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this$0.clickJob = null;
            this$0.isDoubleClickPossible = false;
            this$0.performOnClick();
        }
    }

    private static final void showAndHideSeekOverlay$lambda-2(GPHVideoControls this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.viewBinding.seekOverlay.setVisibility(8);
    }

    private static final void setPreviewMode$lambda-3(Function0 $onClick, View it) {
        Intrinsics.checkNotNullParameter((Object)$onClick, (String)"$onClick");
        $onClick.invoke();
    }

    private static final boolean setPreviewMode$lambda-4(View view, MotionEvent motionEvent) {
        return false;
    }

    private static final void hideControls$lambda-5(GPHVideoControls this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.viewBinding.controls.setVisibility(8);
    }

    public static final /* synthetic */ void access$performOnClick(GPHVideoControls $this) {
        $this.performOnClick();
    }

    public static final /* synthetic */ GphVideoControlsViewBinding access$getViewBinding$p(GPHVideoControls $this) {
        return $this.viewBinding;
    }

    public static final /* synthetic */ void access$setPause$p(GPHVideoControls $this, boolean bl) {
        $this.pause = bl;
    }

    public static final /* synthetic */ boolean access$getFirstStart$p(GPHVideoControls $this) {
        return $this.firstStart;
    }

    public static final /* synthetic */ void access$setFirstStart$p(GPHVideoControls $this, boolean bl) {
        $this.firstStart = bl;
    }

    public static final /* synthetic */ void access$hideControls(GPHVideoControls $this, long delay) {
        $this.hideControls(delay);
    }

    public static final /* synthetic */ GPHAbstractVideoPlayer access$getPlayer$p(GPHVideoControls $this) {
        return $this.player;
    }

    public static final /* synthetic */ void access$updateSoundModeIcon(GPHVideoControls $this) {
        $this.updateSoundModeIcon();
    }

    public static final /* synthetic */ void access$updateCaptionsIcon(GPHVideoControls $this, boolean visible) {
        $this.updateCaptionsIcon(visible);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/giphy/sdk/ui/views/GPHVideoControls$Companion;", "", "()V", "DOUBLE_TOUCH_INTERVAL", "", "FOWARD_REWIND_INTERVAL", "", "HIDE_CONTROLS_DELAY", "HIDE_CONTROLS_DURATION", "HIDE_CONTROLS_INITIAL_DELAY", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

