/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.ConstantsKt;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphMediaPreviewDialogBinding;
import com.giphy.sdk.ui.utils.GPHAbstractVideoPlayer;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHMediaPreviewDialog;
import com.giphy.sdk.ui.views.GPHMediaView;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000fH\u0002J$\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020.H\u0016J\u001a\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020(2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u00109\u001a\u00020\u000fH\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020;H\u0002J\"\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u000e2\b\u0010A\u001a\u0004\u0018\u00010BJ\b\u0010C\u001a\u00020;H\u0002J\b\u0010D\u001a\u00020;H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R(\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006F"}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog;", "Landroidx/fragment/app/DialogFragment;", "()V", "_binding", "Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "binding", "getBinding", "()Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "dismissListener", "Landroid/content/DialogInterface$OnDismissListener;", "media", "Lcom/giphy/sdk/core/models/Media;", "onRemoveMedia", "Lkotlin/Function1;", "", "", "getOnRemoveMedia", "()Lkotlin/jvm/functions/Function1;", "setOnRemoveMedia", "(Lkotlin/jvm/functions/Function1;)V", "onSelectMedia", "getOnSelectMedia", "setOnSelectMedia", "onShowMore", "getOnShowMore", "setOnShowMore", "player", "Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "showRemoveOption", "", "value", "showViewOnGiphy", "getShowViewOnGiphy", "()Z", "setShowViewOnGiphy", "(Z)V", "getTheme", "", "initUI", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onDismiss", "dialog", "Landroid/content/DialogInterface;", "onPause", "onResume", "onSaveInstanceState", "outState", "onViewCreated", "view", "prepareVideo", "removeFromRecentsAction", "Landroid/view/View$OnClickListener;", "selectMediaAction", "show", "manager", "Landroidx/fragment/app/FragmentManager;", "tag", "listener", "", "showMoreAction", "viewOnGiphyAction", "Companion", "giphy-ui-2.3.4_release"})
public final class GPHMediaPreviewDialog
extends DialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GphMediaPreviewDialogBinding _binding;
    private Media media;
    private boolean showRemoveOption;
    private boolean showViewOnGiphy = true;
    @Nullable
    private GPHAbstractVideoPlayer player;
    @Nullable
    private DialogInterface.OnDismissListener dismissListener;
    @NotNull
    private Function1<? super String, Unit> onShowMore = onShowMore.1.INSTANCE;
    @NotNull
    private Function1<? super String, Unit> onRemoveMedia = onRemoveMedia.1.INSTANCE;
    @NotNull
    private Function1<? super Media, Unit> onSelectMedia = onSelectMedia.1.INSTANCE;
    @NotNull
    private static final String MEDIA_KEY = "gph_media_preview_dialog_media";
    @NotNull
    private static final String REMOVE_ACTION_VISIBILITY_KEY = "gph_media_preview_remove_action_show";
    @NotNull
    private static final String SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY = "gph_show_on_giphy_action_show";

    private final GphMediaPreviewDialogBinding getBinding() {
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this._binding;
        Intrinsics.checkNotNull((Object)gphMediaPreviewDialogBinding);
        return gphMediaPreviewDialogBinding;
    }

    public final boolean getShowViewOnGiphy() {
        return this.showViewOnGiphy;
    }

    public final void setShowViewOnGiphy(boolean value) {
        block0: {
            this.showViewOnGiphy = value;
            GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this._binding;
            if (gphMediaPreviewDialogBinding == null) break block0;
            GphMediaPreviewDialogBinding it = gphMediaPreviewDialogBinding;
            boolean bl = false;
            it.gphActionViewGiphy.setVisibility(value ? 0 : 8);
        }
    }

    @NotNull
    public final Function1<String, Unit> getOnShowMore() {
        return this.onShowMore;
    }

    public final void setOnShowMore(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onShowMore = function1;
    }

    @NotNull
    public final Function1<String, Unit> getOnRemoveMedia() {
        return this.onRemoveMedia;
    }

    public final void setOnRemoveMedia(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onRemoveMedia = function1;
    }

    @NotNull
    public final Function1<Media, Unit> getOnSelectMedia() {
        return this.onSelectMedia;
    }

    public final void setOnSelectMedia(@NotNull Function1<? super Media, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onSelectMedia = function1;
    }

    public int getTheme() {
        return R.style.GiphyDialogStyle;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        this._binding = GphMediaPreviewDialogBinding.inflate(inflater, container, false);
        FrameLayout frameLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        return (View)frameLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Parcelable parcelable = this.requireArguments().getParcelable(MEDIA_KEY);
        Intrinsics.checkNotNull((Object)parcelable);
        this.media = (Media)parcelable;
        this.showRemoveOption = this.requireArguments().getBoolean(REMOVE_ACTION_VISIBILITY_KEY);
        this.setShowViewOnGiphy(this.requireArguments().getBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY));
        this.initUI();
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            bundle.putBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY, this.showViewOnGiphy);
        }
        super.onSaveInstanceState(outState);
    }

    public void onDestroyView() {
        this._binding = null;
        super.onDestroyView();
    }

    private final void initUI() {
        Unit unit;
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding;
        GphMediaPreviewDialogBinding $this$initUI_u24lambda_u2d7 = gphMediaPreviewDialogBinding = this.getBinding();
        boolean bl = false;
        $this$initUI_u24lambda_u2d7.gphActionRemove.setVisibility(this.showRemoveOption ? 0 : 8);
        $this$initUI_u24lambda_u2d7.gphActionViewGiphy.setVisibility(this.showViewOnGiphy ? 0 : 8);
        $this$initUI_u24lambda_u2d7.actionsContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        $this$initUI_u24lambda_u2d7.dialogContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getDialogOverlayBackgroundColor());
        GradientDrawable shape = new GradientDrawable();
        shape.setCornerRadius((float)IntExtensionsKt.getPx(12));
        shape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        $this$initUI_u24lambda_u2d7.dialogBody.setBackground((Drawable)shape);
        GradientDrawable buttonShape = new GradientDrawable();
        buttonShape.setCornerRadius((float)IntExtensionsKt.getPx(2));
        buttonShape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        ConstraintLayout constraintLayout = new ConstraintLayout[]{$this$initUI_u24lambda_u2d7.channelName, $this$initUI_u24lambda_u2d7.gphActionRemoveText, $this$initUI_u24lambda_u2d7.gphActionSelectText, $this$initUI_u24lambda_u2d7.gphActionViewGiphyText};
        ConstraintLayout $this$forEach$iv = constraintLayout;
        boolean $i$f$forEach = false;
        int n = ((TextView[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            TextView element$iv;
            TextView it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            it.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getTextColor());
        }
        Media media = this.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        User user = media.getUser();
        if (user != null) {
            User it = user;
            boolean bl3 = false;
            $this$initUI_u24lambda_u2d7.channelName.setText((CharSequence)('@' + it.getUsername()));
            $this$initUI_u24lambda_u2d7.verifiedBadge.setVisibility(it.getVerified() ? 0 : 8);
            $this$initUI_u24lambda_u2d7.userChannelGifAvatar.loadAsset(it.getAvatarUrl());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            GphMediaPreviewDialogBinding $this$initUI_u24lambda_u2d7_u24lambda_u2d3 = $this$initUI_u24lambda_u2d7;
            boolean bl4 = false;
            $this$initUI_u24lambda_u2d7_u24lambda_u2d3.userAttrContainer.setVisibility(8);
        }
        $this$initUI_u24lambda_u2d7.mainGif.setAdjustViewBounds(true);
        GPHMediaView gPHMediaView = $this$initUI_u24lambda_u2d7.mainGif;
        Media media2 = this.media;
        if (media2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media2 = null;
        }
        gPHMediaView.setMedia(media2, RenditionType.original, (Drawable)new ColorDrawable(ConstantsKt.getPlaceholderColor()));
        $this$initUI_u24lambda_u2d7.dialogContainer.setOnClickListener(arg_0 -> GPHMediaPreviewDialog.initUI$lambda-7$lambda-4(this, arg_0));
        $this$initUI_u24lambda_u2d7.mainGif.setOnClickListener(arg_0 -> GPHMediaPreviewDialog.initUI$lambda-7$lambda-5(this, arg_0));
        ConstraintLayout $this$initUI_u24lambda_u2d7_u24lambda_u2d6 = constraintLayout = $this$initUI_u24lambda_u2d7.dialogBody;
        boolean bl5 = false;
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setScaleX(0.7f);
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setScaleY(0.7f);
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setTranslationY((float)IntExtensionsKt.getPx(200));
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.animate().scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$initUI_u24lambda_u2d7.userAttrContainer.setOnClickListener(this.showMoreAction());
        $this$initUI_u24lambda_u2d7.gphActionRemove.setOnClickListener(this.removeFromRecentsAction());
        $this$initUI_u24lambda_u2d7.gphActionSelect.setOnClickListener(this.selectMediaAction());
        $this$initUI_u24lambda_u2d7.gphActionViewGiphy.setOnClickListener(this.viewOnGiphyAction());
        Media media3 = this.media;
        if (media3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media3 = null;
        }
        if (MediaExtensionKt.isVideo(media3)) {
            this.prepareVideo();
        }
    }

    public void onDismiss(@NotNull DialogInterface dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer != null) {
            gPHAbstractVideoPlayer.onDestroy();
        }
        DialogInterface.OnDismissListener onDismissListener = this.dismissListener;
        if (onDismissListener != null) {
            onDismissListener.onDismiss(dialog);
        }
        super.onDismiss(dialog);
    }

    public void onPause() {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
        if (gPHAbstractVideoPlayer != null) {
            gPHAbstractVideoPlayer.onPause();
        }
        super.onPause();
    }

    public void onResume() {
        block0: {
            super.onResume();
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) break block0;
            gPHAbstractVideoPlayer.onResume();
        }
    }

    public final void show(@NotNull FragmentManager manager, @Nullable String tag, @Nullable Object listener2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (listener2 instanceof DialogInterface.OnDismissListener) {
            this.dismissListener = (DialogInterface.OnDismissListener)listener2;
        }
        super.show(manager, tag);
    }

    private final void prepareVideo() {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer;
        GPHVideoPlayerView gPHVideoPlayerView = this.getBinding().videoPlayerView;
        Media media = this.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        Image image = media.getImages().getOriginal();
        gPHVideoPlayerView.setMaxHeight(image != null ? IntExtensionsKt.getPx(image.getHeight()) : Integer.MAX_VALUE);
        this.getBinding().mainGif.setVisibility(4);
        this.getBinding().videoPlayerView.setVisibility(0);
        GPHMediaPreviewDialog gPHMediaPreviewDialog = this;
        Function3<GPHVideoPlayerView, Boolean, Boolean, GPHAbstractVideoPlayer> function3 = Giphy.INSTANCE.getVideoPlayer();
        if (function3 != null) {
            Function3<GPHVideoPlayerView, Boolean, Boolean, GPHAbstractVideoPlayer> player = function3;
            GPHMediaPreviewDialog gPHMediaPreviewDialog2 = gPHMediaPreviewDialog;
            boolean bl = false;
            gPHAbstractVideoPlayer = (GPHAbstractVideoPlayer)player.invoke((Object)this.getBinding().videoPlayerView, (Object)true, (Object)true);
            gPHMediaPreviewDialog = gPHMediaPreviewDialog2;
        } else {
            gPHAbstractVideoPlayer = null;
        }
        gPHMediaPreviewDialog.player = gPHAbstractVideoPlayer;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
        if (gPHAbstractVideoPlayer2 != null) {
            Media media2 = this.media;
            if (media2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"media");
                media2 = null;
            }
            GPHAbstractVideoPlayer.loadMedia$default(gPHAbstractVideoPlayer2, media2, true, null, null, 12, null);
        }
        GPHVideoPlayerView cfr_ignored_0 = this.getBinding().videoPlayerView;
        this.getBinding().videoPlayerView.setPreviewMode((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GPHMediaPreviewDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.dismiss();
            }
        }));
    }

    private final View.OnClickListener showMoreAction() {
        return arg_0 -> GPHMediaPreviewDialog.showMoreAction$lambda-10(this, arg_0);
    }

    private final View.OnClickListener selectMediaAction() {
        return arg_0 -> GPHMediaPreviewDialog.selectMediaAction$lambda-11(this, arg_0);
    }

    private final View.OnClickListener removeFromRecentsAction() {
        return arg_0 -> GPHMediaPreviewDialog.removeFromRecentsAction$lambda-12(this, arg_0);
    }

    private final View.OnClickListener viewOnGiphyAction() {
        return arg_0 -> GPHMediaPreviewDialog.viewOnGiphyAction$lambda-13(this, arg_0);
    }

    private static final void initUI$lambda-7$lambda-4(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void initUI$lambda-7$lambda-5(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void showMoreAction$lambda-10(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Media media = this$0.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        User user = media.getUser();
        if (user != null) {
            User it2 = user;
            boolean bl = false;
            this$0.onShowMore.invoke((Object)it2.getUsername());
        }
        this$0.dismiss();
    }

    private static final void selectMediaAction$lambda-11(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function1<? super Media, Unit> function1 = this$0.onSelectMedia;
        Media media = this$0.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        function1.invoke((Object)media);
        this$0.dismiss();
    }

    private static final void removeFromRecentsAction$lambda-12(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Function1<? super String, Unit> function1 = this$0.onRemoveMedia;
        Media media = this$0.media;
        if (media == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"media");
            media = null;
        }
        function1.invoke((Object)media.getId());
        this$0.dismiss();
    }

    private static final void viewOnGiphyAction$lambda-13(GPHMediaPreviewDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        if (context != null) {
            Media media = this$0.media;
            if (media == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"media");
                media = null;
            }
            context.startActivity(GifUtils.INSTANCE.getViewGifIntent(media));
        }
        this$0.dismiss();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog$Companion;", "", "()V", "MEDIA_KEY", "", "REMOVE_ACTION_VISIBILITY_KEY", "SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY", "newInstance", "Lcom/giphy/sdk/ui/views/GPHMediaPreviewDialog;", "media", "Lcom/giphy/sdk/core/models/Media;", "showRemoveOption", "", "showOnGiphyOption", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GPHMediaPreviewDialog newInstance(@NotNull Media media, boolean showRemoveOption, boolean showOnGiphyOption) {
            void $this$newInstance_u24lambda_u2d1_u24lambda_u2d0;
            Bundle bundle;
            GPHMediaPreviewDialog gPHMediaPreviewDialog;
            Intrinsics.checkNotNullParameter((Object)media, (String)"media");
            GPHMediaPreviewDialog $this$newInstance_u24lambda_u2d1 = gPHMediaPreviewDialog = new GPHMediaPreviewDialog();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            GPHMediaPreviewDialog gPHMediaPreviewDialog2 = $this$newInstance_u24lambda_u2d1;
            boolean bl2 = false;
            $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putParcelable(MEDIA_KEY, (Parcelable)media);
            $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putBoolean(REMOVE_ACTION_VISIBILITY_KEY, showRemoveOption);
            $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putBoolean(SHOW_ON_GIPHY_ACTION_VISIBILITY_KEY, showOnGiphyOption);
            gPHMediaPreviewDialog2.setArguments(bundle);
            return gPHMediaPreviewDialog;
        }

        public static /* synthetic */ GPHMediaPreviewDialog newInstance$default(Companion companion, Media media, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.newInstance(media, bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

