/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.ConstantsKt;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphMediaPreviewDialogBinding;
import com.giphy.sdk.ui.utils.GPHAbstractVideoPlayer;
import com.giphy.sdk.ui.utils.GifUtils;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHMediaPreview;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u0018H\u0002J\b\u0010'\u001a\u00020\u0018H\u0002J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020)H\u0002J\b\u0010+\u001a\u00020)H\u0002J\b\u0010,\u001a\u00020)H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR(\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/giphy/sdk/ui/views/GPHMediaPreview;", "Landroid/widget/PopupWindow;", "context", "Landroid/content/Context;", "media", "Lcom/giphy/sdk/core/models/Media;", "showRemoveOption", "", "showOnGiphyOption", "(Landroid/content/Context;Lcom/giphy/sdk/core/models/Media;ZZ)V", "_binding", "Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "binding", "getBinding", "()Lcom/giphy/sdk/ui/databinding/GphMediaPreviewDialogBinding;", "getContext", "()Landroid/content/Context;", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "onRemoveMedia", "Lkotlin/Function1;", "", "", "getOnRemoveMedia", "()Lkotlin/jvm/functions/Function1;", "setOnRemoveMedia", "(Lkotlin/jvm/functions/Function1;)V", "onSelectMedia", "getOnSelectMedia", "setOnSelectMedia", "onShowMore", "getOnShowMore", "setOnShowMore", "player", "Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "initUI", "onDismiss", "prepareVideo", "removeFromRecentsAction", "Landroid/view/View$OnClickListener;", "selectMediaAction", "showMoreAction", "viewOnGiphyAction", "giphy-ui-2.3.4_release"})
public final class GPHMediaPreview
extends PopupWindow {
    @Nullable
    private final Context context;
    @NotNull
    private Media media;
    private final boolean showRemoveOption;
    private final boolean showOnGiphyOption;
    @Nullable
    private GphMediaPreviewDialogBinding _binding;
    @Nullable
    private GPHAbstractVideoPlayer player;
    @NotNull
    private Function1<? super String, Unit> onShowMore;
    @NotNull
    private Function1<? super String, Unit> onRemoveMedia;
    @NotNull
    private Function1<? super Media, Unit> onSelectMedia;

    public GPHMediaPreview(@Nullable Context context, @NotNull Media media, boolean showRemoveOption, boolean showOnGiphyOption) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        this.context = context;
        this.media = media;
        this.showRemoveOption = showRemoveOption;
        this.showOnGiphyOption = showOnGiphyOption;
        this.onShowMore = onShowMore.1.INSTANCE;
        this.onRemoveMedia = onRemoveMedia.1.INSTANCE;
        this.onSelectMedia = onSelectMedia.1.INSTANCE;
        this.setContentView(View.inflate((Context)this.context, (int)R.layout.gph_media_preview_dialog, null));
        this._binding = GphMediaPreviewDialogBinding.bind(this.getContentView());
        this.setWidth(-1);
        this.setHeight(-1);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setOverlapAnchor(true);
        }
        this.getBinding().gphActionViewGiphy.setVisibility(this.showOnGiphyOption ? 0 : 8);
        this.setOutsideTouchable(true);
        this.initUI();
        this.setOnDismissListener(() -> GPHMediaPreview._init_$lambda-0(this));
    }

    public /* synthetic */ GPHMediaPreview(Context context, Media media, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(context, media, bl, bl2);
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Media getMedia() {
        return this.media;
    }

    public final void setMedia(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"<set-?>");
        this.media = media;
    }

    private final GphMediaPreviewDialogBinding getBinding() {
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding = this._binding;
        Intrinsics.checkNotNull((Object)gphMediaPreviewDialogBinding);
        return gphMediaPreviewDialogBinding;
    }

    @NotNull
    public final Function1<String, Unit> getOnShowMore() {
        return this.onShowMore;
    }

    public final void setOnShowMore(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onShowMore = function1;
    }

    @NotNull
    public final Function1<String, Unit> getOnRemoveMedia() {
        return this.onRemoveMedia;
    }

    public final void setOnRemoveMedia(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onRemoveMedia = function1;
    }

    @NotNull
    public final Function1<Media, Unit> getOnSelectMedia() {
        return this.onSelectMedia;
    }

    public final void setOnSelectMedia(@NotNull Function1<? super Media, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onSelectMedia = function1;
    }

    private final void onDismiss() {
        block0: {
            this._binding = null;
            GPHAbstractVideoPlayer gPHAbstractVideoPlayer = this.player;
            if (gPHAbstractVideoPlayer == null) break block0;
            gPHAbstractVideoPlayer.onDestroy();
        }
    }

    private final void initUI() {
        Unit unit;
        GphMediaPreviewDialogBinding gphMediaPreviewDialogBinding;
        GphMediaPreviewDialogBinding $this$initUI_u24lambda_u2d7 = gphMediaPreviewDialogBinding = this.getBinding();
        boolean bl = false;
        $this$initUI_u24lambda_u2d7.gphActionRemove.setVisibility(this.showRemoveOption ? 0 : 8);
        $this$initUI_u24lambda_u2d7.gphActionViewGiphy.setVisibility(this.showOnGiphyOption ? 0 : 8);
        $this$initUI_u24lambda_u2d7.actionsContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        $this$initUI_u24lambda_u2d7.dialogContainer.setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getDialogOverlayBackgroundColor());
        GradientDrawable shape = new GradientDrawable();
        shape.setCornerRadius((float)IntExtensionsKt.getPx(12));
        shape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        $this$initUI_u24lambda_u2d7.dialogBody.setBackground((Drawable)shape);
        GradientDrawable buttonShape = new GradientDrawable();
        buttonShape.setCornerRadius((float)IntExtensionsKt.getPx(2));
        buttonShape.setColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getBackgroundColor());
        ConstraintLayout constraintLayout = new ConstraintLayout[]{$this$initUI_u24lambda_u2d7.channelName, $this$initUI_u24lambda_u2d7.gphActionRemoveText, $this$initUI_u24lambda_u2d7.gphActionSelectText, $this$initUI_u24lambda_u2d7.gphActionViewGiphyText};
        ConstraintLayout $this$forEach$iv = constraintLayout;
        boolean $i$f$forEach = false;
        int n = ((TextView[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            TextView element$iv;
            TextView it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            it.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_4_release().getTextColor());
        }
        User user = this.media.getUser();
        if (user != null) {
            User it = user;
            boolean bl3 = false;
            $this$initUI_u24lambda_u2d7.channelName.setText((CharSequence)('@' + it.getUsername()));
            $this$initUI_u24lambda_u2d7.verifiedBadge.setVisibility(it.getVerified() ? 0 : 8);
            $this$initUI_u24lambda_u2d7.userChannelGifAvatar.loadAsset(it.getAvatarUrl());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            GphMediaPreviewDialogBinding $this$initUI_u24lambda_u2d7_u24lambda_u2d3 = $this$initUI_u24lambda_u2d7;
            boolean bl4 = false;
            $this$initUI_u24lambda_u2d7_u24lambda_u2d3.userAttrContainer.setVisibility(8);
        }
        $this$initUI_u24lambda_u2d7.mainGif.setAdjustViewBounds(true);
        $this$initUI_u24lambda_u2d7.mainGif.setMedia(this.media, RenditionType.original, (Drawable)new ColorDrawable(ConstantsKt.getPlaceholderColor()));
        $this$initUI_u24lambda_u2d7.dialogContainer.setOnClickListener(arg_0 -> GPHMediaPreview.initUI$lambda-7$lambda-4(this, arg_0));
        $this$initUI_u24lambda_u2d7.mainGif.setOnClickListener(arg_0 -> GPHMediaPreview.initUI$lambda-7$lambda-5(this, arg_0));
        ConstraintLayout $this$initUI_u24lambda_u2d7_u24lambda_u2d6 = constraintLayout = $this$initUI_u24lambda_u2d7.dialogBody;
        boolean bl5 = false;
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setScaleX(0.7f);
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setScaleY(0.7f);
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.setTranslationY((float)IntExtensionsKt.getPx(200));
        $this$initUI_u24lambda_u2d7_u24lambda_u2d6.animate().scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$initUI_u24lambda_u2d7.userAttrContainer.setOnClickListener(this.showMoreAction());
        $this$initUI_u24lambda_u2d7.gphActionRemove.setOnClickListener(this.removeFromRecentsAction());
        $this$initUI_u24lambda_u2d7.gphActionSelect.setOnClickListener(this.selectMediaAction());
        $this$initUI_u24lambda_u2d7.gphActionViewGiphy.setOnClickListener(this.viewOnGiphyAction());
        if (MediaExtensionKt.isVideo(this.media)) {
            this.prepareVideo();
        }
    }

    private final void prepareVideo() {
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer;
        Image image = this.media.getImages().getOriginal();
        this.getBinding().videoPlayerView.setMaxHeight(image != null ? IntExtensionsKt.getPx(image.getHeight()) : Integer.MAX_VALUE);
        this.getBinding().mainGif.setVisibility(4);
        this.getBinding().videoPlayerView.setVisibility(0);
        GPHMediaPreview gPHMediaPreview = this;
        Function3<GPHVideoPlayerView, Boolean, Boolean, GPHAbstractVideoPlayer> function3 = Giphy.INSTANCE.getVideoPlayer();
        if (function3 != null) {
            Function3<GPHVideoPlayerView, Boolean, Boolean, GPHAbstractVideoPlayer> player = function3;
            GPHMediaPreview gPHMediaPreview2 = gPHMediaPreview;
            boolean bl = false;
            gPHAbstractVideoPlayer = (GPHAbstractVideoPlayer)player.invoke((Object)this.getBinding().videoPlayerView, (Object)true, (Object)true);
            gPHMediaPreview = gPHMediaPreview2;
        } else {
            gPHAbstractVideoPlayer = null;
        }
        gPHMediaPreview.player = gPHAbstractVideoPlayer;
        GPHAbstractVideoPlayer gPHAbstractVideoPlayer2 = this.player;
        if (gPHAbstractVideoPlayer2 != null) {
            GPHAbstractVideoPlayer.loadMedia$default(gPHAbstractVideoPlayer2, this.media, true, null, null, 12, null);
        }
        GPHVideoPlayerView cfr_ignored_0 = this.getBinding().videoPlayerView;
        this.getBinding().videoPlayerView.setPreviewMode((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GPHMediaPreview this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.dismiss();
            }
        }));
    }

    private final View.OnClickListener showMoreAction() {
        return arg_0 -> GPHMediaPreview.showMoreAction$lambda-10(this, arg_0);
    }

    private final View.OnClickListener selectMediaAction() {
        return arg_0 -> GPHMediaPreview.selectMediaAction$lambda-11(this, arg_0);
    }

    private final View.OnClickListener removeFromRecentsAction() {
        return arg_0 -> GPHMediaPreview.removeFromRecentsAction$lambda-12(this, arg_0);
    }

    private final View.OnClickListener viewOnGiphyAction() {
        return arg_0 -> GPHMediaPreview.viewOnGiphyAction$lambda-13(this, arg_0);
    }

    private static final void _init_$lambda-0(GPHMediaPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onDismiss();
    }

    private static final void initUI$lambda-7$lambda-4(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void initUI$lambda-7$lambda-5(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void showMoreAction$lambda-10(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        User user = this$0.media.getUser();
        if (user != null) {
            User it2 = user;
            boolean bl = false;
            this$0.onShowMore.invoke((Object)it2.getUsername());
        }
        this$0.dismiss();
    }

    private static final void selectMediaAction$lambda-11(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onSelectMedia.invoke((Object)this$0.media);
        this$0.dismiss();
    }

    private static final void removeFromRecentsAction$lambda-12(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onRemoveMedia.invoke((Object)this$0.media.getId());
        this$0.dismiss();
    }

    private static final void viewOnGiphyAction$lambda-13(GPHMediaPreview this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.context;
        if (context != null) {
            context.startActivity(GifUtils.INSTANCE.getViewGifIntent(this$0.media));
        }
        this$0.dismiss();
    }
}

