/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.utils;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Images;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.ui.drawables.ImageFormat;
import com.giphy.sdk.ui.drawables.ImageUriInfo;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lcom/giphy/sdk/ui/utils/GifUtils;", "", "()V", "getImageDataForType", "Lcom/giphy/sdk/core/models/Image;", "gif", "Lcom/giphy/sdk/core/models/Media;", "imageType", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "getImageToLoad", "Lcom/giphy/sdk/ui/drawables/ImageUriInfo;", "imageData", "imageFormat", "Lcom/giphy/sdk/ui/drawables/ImageFormat;", "getViewGifIntent", "Landroid/content/Intent;", "media", "imageToImageUriInfo", "image", "giphy-ui-2.3.4_release"})
public final class GifUtils {
    @NotNull
    public static final GifUtils INSTANCE = new GifUtils();

    private GifUtils() {
    }

    @Nullable
    public final Image getImageDataForType(@Nullable Media gif, @NotNull RenditionType imageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        switch (WhenMappings.$EnumSwitchMapping$0[imageType.ordinal()]) {
            case 1: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getOriginal() : null;
            }
            case 2: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getDownsized() : null;
            }
            case 3: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getDownsizedMedium() : null;
            }
            case 4: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getDownsizedLarge() : null;
            }
            case 5: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getFixedWidth() : null;
            }
            case 6: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getFixedWidthDownsampled() : null;
            }
            case 7: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getFixedWidthStill() : null;
            }
            case 8: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getLooping() : null;
            }
            case 9: {
                Object object = gif;
                return object != null && (object = ((Media)object).getImages()) != null ? ((Images)object).getFixedHeight() : null;
            }
        }
        return null;
    }

    @Nullable
    public final ImageUriInfo imageToImageUriInfo(@Nullable Image image, @NotNull ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageFormat), (String)"imageFormat");
        ImageUriInfo imageUriInfo = null;
        switch (WhenMappings.$EnumSwitchMapping$1[imageFormat.ordinal()]) {
            case 1: {
                ImageUriInfo imageUriInfo2;
                Image image2 = image;
                Intrinsics.checkNotNull((Object)image2);
                if (image2.getWebPUrl() != null) {
                    Uri uri = Uri.parse((String)image.getWebPUrl());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.webPUrl)");
                    imageUriInfo2 = new ImageUriInfo(uri, image.getWebPSize(), imageFormat);
                } else {
                    imageUriInfo2 = null;
                }
                imageUriInfo = imageUriInfo2;
                break;
            }
            case 2: {
                ImageUriInfo imageUriInfo3;
                Image image3 = image;
                Intrinsics.checkNotNull((Object)image3);
                if (image3.getMp4Url() != null) {
                    Uri uri = Uri.parse((String)image.getMp4Url());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.mp4Url)");
                    imageUriInfo3 = new ImageUriInfo(uri, image.getMp4Size(), imageFormat);
                } else {
                    imageUriInfo3 = null;
                }
                imageUriInfo = imageUriInfo3;
                break;
            }
            case 3: {
                ImageUriInfo imageUriInfo4;
                Image image4 = image;
                Intrinsics.checkNotNull((Object)image4);
                if (image4.getGifUrl() != null) {
                    Uri uri = Uri.parse((String)image.getGifUrl());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.gifUrl)");
                    imageUriInfo4 = new ImageUriInfo(uri, image.getGifSize(), imageFormat);
                } else {
                    imageUriInfo4 = null;
                }
                imageUriInfo = imageUriInfo4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return imageUriInfo;
    }

    @Nullable
    public final ImageUriInfo getImageToLoad(@NotNull Image imageData, @Nullable ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        if (imageFormat != null) {
            return this.imageToImageUriInfo(imageData, imageFormat);
        }
        return TextUtils.isEmpty((CharSequence)imageData.getWebPUrl()) ? this.imageToImageUriInfo(imageData, ImageFormat.GIF) : this.imageToImageUriInfo(imageData, ImageFormat.WEBP);
    }

    @NotNull
    public final Intent getViewGifIntent(@Nullable Media media) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Media media2 = media;
        intent.setData(Uri.parse((String)(media2 != null ? media2.getUrl() : null)));
        intent.setFlags(0x10000000);
        return intent;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenditionType.values().length];
            nArray[RenditionType.original.ordinal()] = 1;
            nArray[RenditionType.downsized.ordinal()] = 2;
            nArray[RenditionType.downsizedMedium.ordinal()] = 3;
            nArray[RenditionType.downsizedLarge.ordinal()] = 4;
            nArray[RenditionType.fixedWidth.ordinal()] = 5;
            nArray[RenditionType.fixedWidthDownsampled.ordinal()] = 6;
            nArray[RenditionType.fixedWidthStill.ordinal()] = 7;
            nArray[RenditionType.looping.ordinal()] = 8;
            nArray[RenditionType.fixedHeight.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageFormat.values().length];
            nArray[ImageFormat.WEBP.ordinal()] = 1;
            nArray[ImageFormat.MP4.ordinal()] = 2;
            nArray[ImageFormat.GIF.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

