/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.utils;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.SurfaceView;
import com.giphy.sdk.core.models.Images;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.ui.utils.GPHAbstractVideoPlayer;
import com.giphy.sdk.ui.utils.GPHVideoPlayerState;
import com.giphy.sdk.ui.views.GPHVideoPlayerView;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010;\u001a\u00020\"2\u0016\u0010<\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#J\b\u0010=\u001a\u00020\"H&J\b\u0010>\u001a\u00020?H&J\u0006\u0010@\u001a\u00020\u0005J5\u0010A\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00192\b\b\u0002\u0010B\u001a\u00020\u00052\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010DJ\u0006\u0010E\u001a\u00020\"J\u0006\u0010F\u001a\u00020\"J\u0006\u0010G\u001a\u00020\"J\b\u0010H\u001a\u00020\"H\u0002J\b\u0010I\u001a\u00020\"H&J\b\u0010J\u001a\u00020\"H\u0002J\u001e\u0010K\u001a\u00020\"2\u0016\u0010<\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#J\u0010\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020\rH&J\u0012\u0010N\u001a\u00020\"2\b\u0010O\u001a\u0004\u0018\u00010PH&J\u0010\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020?H&J\u0018\u0010S\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u0005H&J\b\u0010T\u001a\u00020\"H\u0004J\b\u0010U\u001a\u00020\"H\u0004J\b\u0010V\u001a\u00020\"H\u0004J\b\u0010W\u001a\u00020\"H\u0002J\u0010\u0010X\u001a\u00020\"2\u0006\u0010M\u001a\u00020\rH\u0004J\b\u0010Y\u001a\u00020\"H$R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#0\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0014\"\u0004\b-\u0010\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0014\"\u0004\b7\u0010\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0014\"\u0004\b:\u0010\u0016\u00a8\u0006Z"}, d2={"Lcom/giphy/sdk/ui/utils/GPHAbstractVideoPlayer;", "", "playerView", "Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "repeatable", "", "showCaptions", "(Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;ZZ)V", "audioManager", "Landroid/media/AudioManager;", "contentObserver", "Landroid/database/ContentObserver;", "currentPosition", "", "getCurrentPosition", "()J", "duration", "getDuration", "isDestroyed", "isDeviceMuted", "()Z", "setDeviceMuted", "(Z)V", "isPlaying", "lastMedia", "Lcom/giphy/sdk/core/models/Media;", "lastProgress", "getLastProgress", "setLastProgress", "(J)V", "listeners", "", "Lkotlin/Function1;", "Lcom/giphy/sdk/ui/utils/GPHVideoPlayerState;", "", "Lcom/giphy/sdk/ui/utils/GPHPlayerStateListener;", "getListeners", "()Ljava/util/Set;", "media", "getMedia", "()Lcom/giphy/sdk/core/models/Media;", "setMedia", "(Lcom/giphy/sdk/core/models/Media;)V", "paused", "getPaused", "setPaused", "getPlayerView", "()Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;", "setPlayerView", "(Lcom/giphy/sdk/ui/views/GPHVideoPlayerView;)V", "progressTimer", "Ljava/util/Timer;", "progressTimerTask", "Ljava/util/TimerTask;", "getRepeatable", "setRepeatable", "value", "getShowCaptions", "setShowCaptions", "addListener", "listener", "destroyPlayer", "getVolume", "", "isActive", "loadMedia", "autoPlay", "view", "(Lcom/giphy/sdk/core/models/Media;ZLcom/giphy/sdk/ui/views/GPHVideoPlayerView;Ljava/lang/Boolean;)V", "onDestroy", "onPause", "onResume", "onStopPlaying", "play", "releasePlayer", "removeListener", "seekTo", "position", "setVideoSurfaceView", "surfaceView", "Landroid/view/SurfaceView;", "setVolume", "audioVolume", "setupExoPlayer", "startListeningToDeviceVolume", "startProgressTimer", "stopListeningToDeviceVolume", "stopProgressTimer", "updateProgress", "updateRepeatMode", "giphy-ui-2.3.4_release"})
public abstract class GPHAbstractVideoPlayer {
    @Nullable
    private GPHVideoPlayerView playerView;
    private boolean repeatable;
    private boolean showCaptions;
    @NotNull
    private final Set<Function1<GPHVideoPlayerState, Unit>> listeners;
    @Nullable
    private Timer progressTimer;
    @Nullable
    private TimerTask progressTimerTask;
    @Nullable
    private ContentObserver contentObserver;
    @NotNull
    private Media media;
    private boolean isDestroyed;
    @Nullable
    private AudioManager audioManager;
    private boolean isDeviceMuted;
    private long lastProgress;
    @Nullable
    private Media lastMedia;
    private boolean paused;

    @Nullable
    public final GPHVideoPlayerView getPlayerView() {
        return this.playerView;
    }

    public final void setPlayerView(@Nullable GPHVideoPlayerView gPHVideoPlayerView) {
        this.playerView = gPHVideoPlayerView;
    }

    public final boolean getRepeatable() {
        return this.repeatable;
    }

    public final void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public final boolean getShowCaptions() {
        return this.showCaptions;
    }

    public final void setShowCaptions(boolean value) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)new GPHVideoPlayerState.CaptionsVisibilityChanged(value));
        }
        this.showCaptions = value;
    }

    public GPHAbstractVideoPlayer(@Nullable GPHVideoPlayerView playerView, boolean repeatable, boolean showCaptions) {
        this.listeners = new LinkedHashSet();
        this.media = new Media("", null, null, null, null, null, null, null, null, null, null, null, null, null, new Images(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 1048575, null), null, null, null, null, null, null, null, null, false, false, false, false, false, false, false, false, false, null, null, null, false, null, null, null, -16386, 127, null);
        this.startListeningToDeviceVolume();
        this.playerView = playerView;
        this.repeatable = repeatable;
        this.setShowCaptions(showCaptions);
    }

    public /* synthetic */ GPHAbstractVideoPlayer(GPHVideoPlayerView gPHVideoPlayerView, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(gPHVideoPlayerView, bl, bl2);
    }

    @NotNull
    protected final Set<Function1<GPHVideoPlayerState, Unit>> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Media getMedia() {
        return this.media;
    }

    public final void setMedia(@NotNull Media media) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"<set-?>");
        this.media = media;
    }

    public abstract long getDuration();

    public abstract long getCurrentPosition();

    public abstract boolean isPlaying();

    protected final boolean isDeviceMuted() {
        return this.isDeviceMuted;
    }

    protected final void setDeviceMuted(boolean bl) {
        this.isDeviceMuted = bl;
    }

    protected final void startListeningToDeviceVolume() {
        if (this.playerView == null) {
            return;
        }
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView));
        Object object = gPHVideoPlayerView.getContext().getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object;
        GPHAbstractVideoPlayer.startListeningToDeviceVolume$setVolumeValue(this);
        Handler handler = new Handler(Looper.getMainLooper());
        this.contentObserver = new ContentObserver(this, handler){
            final /* synthetic */ GPHAbstractVideoPlayer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                GPHAbstractVideoPlayer.access$startListeningToDeviceVolume$setVolumeValue(this.this$0);
            }
        };
        GPHVideoPlayerView gPHVideoPlayerView2 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView2));
        ContentResolver contentResolver = gPHVideoPlayerView2.getContext().getContentResolver();
        ContentObserver contentObserver = this.contentObserver;
        Intrinsics.checkNotNull((Object)contentObserver);
        contentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, contentObserver);
    }

    protected final void stopListeningToDeviceVolume() {
        if (this.playerView == null || this.contentObserver == null) {
            return;
        }
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView));
        ContentResolver contentResolver = gPHVideoPlayerView.getContext().getContentResolver();
        ContentObserver contentObserver = this.contentObserver;
        Intrinsics.checkNotNull((Object)contentObserver);
        contentResolver.unregisterContentObserver(contentObserver);
        this.contentObserver = null;
    }

    protected final void startProgressTimer() {
        block2: {
            TimerTask timerTask = this.progressTimerTask;
            if (timerTask != null) {
                timerTask.cancel();
            }
            Timer timer = this.progressTimer;
            if (timer != null) {
                timer.cancel();
            }
            this.progressTimerTask = new TimerTask(this){
                final /* synthetic */ GPHAbstractVideoPlayer this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    new Handler(Looper.getMainLooper()).post(() -> startProgressTimer.1.run$lambda-0(this.this$0));
                }

                private static final void run$lambda-0(GPHAbstractVideoPlayer this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    if (!this$0.isPlaying() || this$0.getCurrentPosition() == 0L) {
                        return;
                    }
                    this$0.updateProgress(this$0.getCurrentPosition());
                }
            };
            Timer timer2 = this.progressTimer = new Timer("VideoProgressTimer");
            if (timer2 == null) break block2;
            timer2.schedule(this.progressTimerTask, 0L, 40L);
        }
    }

    private final void stopProgressTimer() {
        block0: {
            Timer timer = this.progressTimer;
            if (timer == null) break block0;
            timer.cancel();
        }
    }

    public abstract float getVolume();

    public abstract void setVolume(float var1);

    public abstract void setVideoSurfaceView(@Nullable SurfaceView var1);

    public final void addListener(@NotNull Function1<? super GPHVideoPlayerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Function1<? super GPHVideoPlayerState, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public abstract void seekTo(long var1);

    public abstract void play();

    public abstract void setupExoPlayer(@NotNull GPHVideoPlayerView var1, boolean var2);

    public final synchronized void loadMedia(@NotNull Media media, boolean autoPlay, @Nullable GPHVideoPlayerView view, @Nullable Boolean repeatable) throws Exception {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Boolean bl = repeatable;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            this.repeatable = it;
        }
        if (this.isDestroyed) {
            Timber.e((String)"Player is already destroyed!", (Object[])new Object[0]);
            return;
        }
        Timber.d((String)("loadMedia " + media.getId() + ' ' + autoPlay + ' ' + (Object)((Object)view)), (Object[])new Object[0]);
        long t0 = SystemClock.elapsedRealtime();
        if (view != null) {
            if (!Intrinsics.areEqual((Object)((Object)view), (Object)((Object)this.playerView))) {
                GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
                if (gPHVideoPlayerView != null) {
                    gPHVideoPlayerView.onPause();
                }
            }
            this.playerView = view;
        }
        this.media = media;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl3 = false;
            it.invoke((Object)new GPHVideoPlayerState.MediaChanged(media));
        }
        this.releasePlayer();
        if (this.playerView == null) {
            throw new Exception("playerView must not be null");
        }
        this.paused = false;
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        if (gPHVideoPlayerView != null) {
            gPHVideoPlayerView.setVisibility(0);
        }
        this.lastMedia = media;
        this.lastProgress = 0L;
        GPHVideoPlayerView gPHVideoPlayerView2 = this.playerView;
        Intrinsics.checkNotNull((Object)((Object)gPHVideoPlayerView2));
        this.setupExoPlayer(gPHVideoPlayerView2, autoPlay);
        Timber.d((String)("loadMedia time=" + (SystemClock.elapsedRealtime() - t0)), (Object[])new Object[0]);
    }

    public static /* synthetic */ void loadMedia$default(GPHAbstractVideoPlayer gPHAbstractVideoPlayer, Media media, boolean bl, GPHVideoPlayerView gPHVideoPlayerView, Boolean bl2, int n, Object object) throws Exception {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadMedia");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            gPHVideoPlayerView = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        gPHAbstractVideoPlayer.loadMedia(media, bl, gPHVideoPlayerView, bl2);
    }

    public abstract void destroyPlayer();

    private final void releasePlayer() {
        this.stopProgressTimer();
        this.destroyPlayer();
    }

    protected final void updateProgress(long position) {
        block0: {
            GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
            if (gPHVideoPlayerView == null) break block0;
            gPHVideoPlayerView.onProgress(position);
        }
    }

    private final void onStopPlaying() {
        this.releasePlayer();
        this.playerView = null;
    }

    protected final long getLastProgress() {
        return this.lastProgress;
    }

    protected final void setLastProgress(long l) {
        this.lastProgress = l;
    }

    public final boolean getPaused() {
        return this.paused;
    }

    public final void setPaused(boolean bl) {
        this.paused = bl;
    }

    public final void onPause() {
        this.paused = true;
        GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
        if (gPHVideoPlayerView != null) {
            gPHVideoPlayerView.onPause();
        }
        if (((CharSequence)this.media.getId()).length() > 0) {
            this.lastMedia = this.media;
        }
        this.lastProgress = this.getCurrentPosition();
        this.releasePlayer();
    }

    public final void onResume() {
        block1: {
            this.paused = false;
            GPHVideoPlayerView gPHVideoPlayerView = this.playerView;
            if (gPHVideoPlayerView != null) {
                gPHVideoPlayerView.onResume();
            }
            Media media = this.lastMedia;
            if (media == null) break block1;
            Media it = media;
            boolean bl = false;
            GPHAbstractVideoPlayer.loadMedia$default(this, it, false, null, null, 14, null);
        }
    }

    public final void onDestroy() {
        this.isDestroyed = true;
        this.stopListeningToDeviceVolume();
        this.onStopPlaying();
    }

    public final boolean isActive() {
        return this.playerView != null;
    }

    protected abstract void updateRepeatMode();

    private static final void startListeningToDeviceVolume$setVolumeValue(GPHAbstractVideoPlayer this$0) {
        AudioManager audioManager = this$0.audioManager;
        Intrinsics.checkNotNull((Object)audioManager);
        int currentVolume = audioManager.getStreamVolume(3);
        float playerVolumeValue = currentVolume > 0 ? 1.0f : 0.0f;
        this$0.isDeviceMuted = playerVolumeValue == 0.0f;
        this$0.setVolume(playerVolumeValue);
    }

    public static final /* synthetic */ void access$startListeningToDeviceVolume$setVolumeValue(GPHAbstractVideoPlayer this$0) {
        GPHAbstractVideoPlayer.startListeningToDeviceVolume$setVolumeValue(this$0);
    }
}

