/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.universallist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.MutableLiveData;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.core.GiphyCore;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.Meta;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.core.models.enums.MediaType;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.core.network.api.CompletionHandler;
import com.giphy.sdk.core.network.api.GPHApiClient;
import com.giphy.sdk.core.network.engine.ApiException;
import com.giphy.sdk.core.network.response.ErrorResponse;
import com.giphy.sdk.core.network.response.ListMediaResponse;
import com.giphy.sdk.tracking.GifTrackingManager;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.ui.GPHContentType;
import com.giphy.sdk.ui.GPHRequestType;
import com.giphy.sdk.ui.GPHSettings;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.pagination.GPHContent;
import com.giphy.sdk.ui.pagination.NetworkState;
import com.giphy.sdk.ui.universallist.SmartGridAdapter;
import com.giphy.sdk.ui.universallist.SmartGridRecyclerView;
import com.giphy.sdk.ui.universallist.SmartItemData;
import com.giphy.sdk.ui.universallist.SmartItemType;
import com.giphy.sdk.ui.universallist.WrapStaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e*\u0002nq\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010g\u001a\u00020FJ\b\u0010h\u001a\u00020FH\u0002J\u0010\u0010i\u001a\u00020j2\u0006\u0010d\u001a\u00020\u0007H\u0002J\b\u0010k\u001a\u00020jH\u0002J\u0006\u0010l\u001a\u00020&J\r\u0010m\u001a\u00020nH\u0002\u00a2\u0006\u0002\u0010oJ\r\u0010p\u001a\u00020qH\u0002\u00a2\u0006\u0002\u0010rJ\u0006\u0010s\u001a\u00020&J\u0016\u0010s\u001a\u00020&2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020v0uH\u0002J\u0010\u0010w\u001a\u00020F2\u0006\u0010x\u001a\u00020<H\u0002J\u0010\u0010y\u001a\u00020F2\u0006\u0010z\u001a\u00020\u0007H\u0002J\u0006\u0010{\u001a\u00020FJ\u0006\u0010|\u001a\u00020FJ\b\u0010}\u001a\u00020FH\u0016J\u001d\u0010~\u001a\u00020F2\b\u0010d\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020(\u00a2\u0006\u0002\u0010\u007fJ\u000f\u0010\u0080\u0001\u001a\u00020F2\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u0081\u0001\u001a\u00020FH\u0002J\t\u0010\u0082\u0001\u001a\u00020FH\u0002J\t\u0010\u0083\u0001\u001a\u00020FH\u0002R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$R\u001a\u0010,\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R*\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\"\"\u0004\b8\u0010$R\u000e\u00109\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0084\u0001\u0010G\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020F0A26\u0010\u000f\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020F0A8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u008a\u0001\u0010L\u001a4\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020F\u0018\u00010A28\u0010\u000f\u001a4\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0004\u0012\u00020F\u0018\u00010A8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010I\"\u0004\bN\u0010KR&\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020F0PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TRZ\u0010U\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0004\u0012\u00020F0P2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0004\u0012\u00020F0P8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010R\"\u0004\bW\u0010TR$\u0010X\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0012\"\u0004\bZ\u0010\u0014R(\u0010[\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\\\u0010\u0018\"\u0004\b]\u0010\u001aR \u0010^\u001a\b\u0012\u0004\u0012\u00020_0;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010>\"\u0004\ba\u0010@R\u0014\u0010b\u001a\b\u0012\u0002\b\u0003\u0018\u00010cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010d\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u0012\"\u0004\bf\u0010\u0014\u00a8\u0006\u0084\u0001"}, d2={"Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "apiClient", "Lcom/giphy/sdk/core/network/api/GPHApiClient;", "getApiClient$giphy_ui_2_3_4_release", "()Lcom/giphy/sdk/core/network/api/GPHApiClient;", "setApiClient$giphy_ui_2_3_4_release", "(Lcom/giphy/sdk/core/network/api/GPHApiClient;)V", "value", "cellPadding", "getCellPadding", "()I", "setCellPadding", "(I)V", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "clipsPreviewRenditionType", "getClipsPreviewRenditionType", "()Lcom/giphy/sdk/core/models/enums/RenditionType;", "setClipsPreviewRenditionType", "(Lcom/giphy/sdk/core/models/enums/RenditionType;)V", "content", "Lcom/giphy/sdk/ui/pagination/GPHContent;", "contentItems", "Ljava/util/ArrayList;", "Lcom/giphy/sdk/ui/universallist/SmartItemData;", "Lkotlin/collections/ArrayList;", "getContentItems", "()Ljava/util/ArrayList;", "setContentItems", "(Ljava/util/ArrayList;)V", "contentLoading", "", "contentType", "Lcom/giphy/sdk/ui/GPHContentType;", "footerItems", "getFooterItems", "setFooterItems", "gifTrackingManager", "Lcom/giphy/sdk/tracking/GifTrackingManager;", "getGifTrackingManager$giphy_ui_2_3_4_release", "()Lcom/giphy/sdk/tracking/GifTrackingManager;", "setGifTrackingManager$giphy_ui_2_3_4_release", "(Lcom/giphy/sdk/tracking/GifTrackingManager;)V", "gifsAdapter", "Lcom/giphy/sdk/ui/universallist/SmartGridAdapter;", "getGifsAdapter", "()Lcom/giphy/sdk/ui/universallist/SmartGridAdapter;", "headerItems", "getHeaderItems", "setHeaderItems", "mRequestedLayout", "networkState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/giphy/sdk/ui/pagination/NetworkState;", "getNetworkState", "()Landroidx/lifecycle/MutableLiveData;", "setNetworkState", "(Landroidx/lifecycle/MutableLiveData;)V", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "item", "position", "", "onItemLongPressListener", "getOnItemLongPressListener", "()Lkotlin/jvm/functions/Function2;", "setOnItemLongPressListener", "(Lkotlin/jvm/functions/Function2;)V", "onItemSelectedListener", "getOnItemSelectedListener", "setOnItemSelectedListener", "onResultsUpdateListener", "Lkotlin/Function1;", "getOnResultsUpdateListener", "()Lkotlin/jvm/functions/Function1;", "setOnResultsUpdateListener", "(Lkotlin/jvm/functions/Function1;)V", "onUserProfileInfoPressListener", "getOnUserProfileInfoPressListener", "setOnUserProfileInfoPressListener", "orientation", "getOrientation", "setOrientation", "renditionType", "getRenditionType", "setRenditionType", "responseId", "", "getResponseId", "setResponseId", "runningQuery", "Ljava/util/concurrent/Future;", "spanCount", "getSpanCount", "setSpanCount", "clear", "configureRecyclerViewForGridType", "createItemDecorationForGrid", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "createItemDecorationForStaggered", "emptyResults", "getPostComparator", "com/giphy/sdk/ui/universallist/SmartGridRecyclerView$getPostComparator$1", "()Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView$getPostComparator$1;", "getSpanSizeLookup", "com/giphy/sdk/ui/universallist/SmartGridRecyclerView$getSpanSizeLookup$1", "()Lcom/giphy/sdk/ui/universallist/SmartGridRecyclerView$getSpanSizeLookup$1;", "isAllDynamic", "list", "", "Lcom/giphy/sdk/core/models/Media;", "loadGifs", "state", "loadNextPage", "aroundPosition", "refresh", "refreshItems", "requestLayout", "update", "(Ljava/lang/Integer;Lcom/giphy/sdk/ui/GPHContentType;)V", "updateContent", "updateGridTypeIfNeeded", "updateItemDecorations", "updateNetworkState", "giphy-ui-2.3.4_release"})
public final class SmartGridRecyclerView
extends RecyclerView {
    @NotNull
    private ArrayList<SmartItemData> headerItems;
    @NotNull
    private ArrayList<SmartItemData> contentItems;
    @NotNull
    private ArrayList<SmartItemData> footerItems;
    @NotNull
    private GPHApiClient apiClient;
    @Nullable
    private GPHContent content;
    @NotNull
    private GifTrackingManager gifTrackingManager;
    private int orientation;
    private int spanCount;
    private int cellPadding;
    @Nullable
    private GPHContentType contentType;
    @NotNull
    private Function1<? super Integer, Unit> onResultsUpdateListener;
    @Nullable
    private Function2<? super SmartItemData, ? super Integer, Unit> onItemSelectedListener;
    private boolean contentLoading;
    @NotNull
    private MutableLiveData<NetworkState> networkState;
    @NotNull
    private MutableLiveData<String> responseId;
    @Nullable
    private Future<?> runningQuery;
    @NotNull
    private final SmartGridAdapter gifsAdapter;
    private boolean mRequestedLayout;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$gifsAdapter_u24lambda_u2d0;
        SmartGridAdapter smartGridAdapter;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.headerItems = new ArrayList();
        this.contentItems = new ArrayList();
        this.footerItems = new ArrayList();
        this.apiClient = GiphyCore.INSTANCE.getApiClient();
        this.gifTrackingManager = new GifTrackingManager(true);
        this.orientation = 1;
        this.spanCount = 2;
        this.cellPadding = -1;
        this.onResultsUpdateListener = onResultsUpdateListener.1.INSTANCE;
        this.networkState = new MutableLiveData();
        this.responseId = new MutableLiveData();
        SmartGridAdapter smartGridAdapter2 = smartGridAdapter = new SmartGridAdapter(context, (DiffUtil.ItemCallback<SmartItemData>)((DiffUtil.ItemCallback)this.getPostComparator()));
        SmartGridRecyclerView smartGridRecyclerView = this;
        boolean bl = false;
        $this$gifsAdapter_u24lambda_u2d0.setLoadingTrigger((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                SmartGridRecyclerView.access$loadNextPage((SmartGridRecyclerView)((Object)this.receiver), p0);
            }
        }));
        $this$gifsAdapter_u24lambda_u2d0.setUpdateTracking((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGifTrackingManager$giphy_ui_2_3_4_release().updateTracking();
            }
        }));
        smartGridRecyclerView.gifsAdapter = smartGridAdapter;
        if (this.cellPadding == -1) {
            this.setCellPadding(this.getResources().getDimensionPixelSize(R.dimen.gph_gif_border_size));
        }
        this.configureRecyclerViewForGridType();
        this.setAdapter((RecyclerView.Adapter)this.gifsAdapter);
        this.gifTrackingManager.attachToRecyclerView(this, this.gifsAdapter);
    }

    public /* synthetic */ SmartGridRecyclerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final ArrayList<SmartItemData> getHeaderItems() {
        return this.headerItems;
    }

    public final void setHeaderItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.headerItems = arrayList;
    }

    @NotNull
    public final ArrayList<SmartItemData> getContentItems() {
        return this.contentItems;
    }

    public final void setContentItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.contentItems = arrayList;
    }

    @NotNull
    public final ArrayList<SmartItemData> getFooterItems() {
        return this.footerItems;
    }

    public final void setFooterItems(@NotNull ArrayList<SmartItemData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.footerItems = arrayList;
    }

    @NotNull
    public final GPHApiClient getApiClient$giphy_ui_2_3_4_release() {
        return this.apiClient;
    }

    public final void setApiClient$giphy_ui_2_3_4_release(@NotNull GPHApiClient gPHApiClient) {
        Intrinsics.checkNotNullParameter((Object)gPHApiClient, (String)"<set-?>");
        this.apiClient = gPHApiClient;
    }

    @NotNull
    public final GifTrackingManager getGifTrackingManager$giphy_ui_2_3_4_release() {
        return this.gifTrackingManager;
    }

    public final void setGifTrackingManager$giphy_ui_2_3_4_release(@NotNull GifTrackingManager gifTrackingManager) {
        Intrinsics.checkNotNullParameter((Object)gifTrackingManager, (String)"<set-?>");
        this.gifTrackingManager = gifTrackingManager;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int value) {
        this.orientation = value;
        this.updateGridTypeIfNeeded();
    }

    public final int getSpanCount() {
        return this.spanCount;
    }

    public final void setSpanCount(int value) {
        this.spanCount = value;
        this.updateGridTypeIfNeeded();
    }

    public final int getCellPadding() {
        return this.cellPadding;
    }

    public final void setCellPadding(int value) {
        this.cellPadding = value;
        this.updateItemDecorations();
    }

    public final void update(@Nullable Integer spanCount, @NotNull GPHContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
        this.contentType = contentType;
        this.gifsAdapter.getAdapterHelper().setContentType(contentType);
        int sCount = 0;
        sCount = this.getResources().getConfiguration().orientation == 2 ? 4 : ((this.getResources().getConfiguration().screenLayout & 0xF) == 4 ? 4 : 2);
        Integer n = spanCount;
        sCount = n != null ? n : sCount;
        int orientation = 1;
        if (contentType == GPHContentType.emoji) {
            Integer n2 = spanCount;
            sCount = n2 != null ? n2 : 5;
        }
        this.setOrientation(orientation);
        this.setSpanCount(sCount);
    }

    @Nullable
    public final RenditionType getRenditionType() {
        return this.gifsAdapter.getAdapterHelper().getRenditionType();
    }

    public final void setRenditionType(@Nullable RenditionType value) {
        this.gifsAdapter.getAdapterHelper().setRenditionType(value);
    }

    @Nullable
    public final RenditionType getClipsPreviewRenditionType() {
        return this.gifsAdapter.getAdapterHelper().getClipsPreviewRenditionType();
    }

    public final void setClipsPreviewRenditionType(@Nullable RenditionType value) {
        this.gifsAdapter.getAdapterHelper().setClipsPreviewRenditionType(value);
    }

    @NotNull
    public final Function1<Integer, Unit> getOnResultsUpdateListener() {
        return this.onResultsUpdateListener;
    }

    public final void setOnResultsUpdateListener(@NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onResultsUpdateListener = function1;
    }

    @Nullable
    public final Function2<SmartItemData, Integer, Unit> getOnItemSelectedListener() {
        return this.gifsAdapter.getItemSelectedListener();
    }

    public final void setOnItemSelectedListener(@Nullable Function2<? super SmartItemData, ? super Integer, Unit> value) {
        this.onItemSelectedListener = value;
        this.gifsAdapter.setItemSelectedListener((Function2<? super SmartItemData, ? super Integer, Unit>)((Function2)new Function2<SmartItemData, Integer, Unit>(value, this){
            final /* synthetic */ Function2<SmartItemData, Integer, Unit> $value;
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull SmartItemData item, int position) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Media media = item.getMediaIfPresent();
                    if (media != null) {
                        Media media2 = media;
                        SmartGridRecyclerView smartGridRecyclerView = this.this$0;
                        Media it = media2;
                        boolean bl = false;
                        smartGridRecyclerView.getGifTrackingManager$giphy_ui_2_3_4_release().trackMedia(it, ActionType.CLICK);
                    }
                    Function2<SmartItemData, Integer, Unit> function2 = this.$value;
                    if (function2 == null) break block1;
                    function2.invoke((Object)item, (Object)position);
                }
            }
        }));
    }

    @NotNull
    public final Function2<SmartItemData, Integer, Unit> getOnItemLongPressListener() {
        return this.gifsAdapter.getItemLongPressListener();
    }

    public final void setOnItemLongPressListener(@NotNull Function2<? super SmartItemData, ? super Integer, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.gifsAdapter.setItemLongPressListener(value);
    }

    @NotNull
    public final Function1<SmartItemData, Unit> getOnUserProfileInfoPressListener() {
        return this.gifsAdapter.getUserProfileInfoPressListener();
    }

    public final void setOnUserProfileInfoPressListener(@NotNull Function1<? super SmartItemData, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.gifsAdapter.setUserProfileInfoPressListener(value);
    }

    @NotNull
    public final MutableLiveData<NetworkState> getNetworkState() {
        return this.networkState;
    }

    public final void setNetworkState(@NotNull MutableLiveData<NetworkState> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.networkState = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<String> getResponseId() {
        return this.responseId;
    }

    public final void setResponseId(@NotNull MutableLiveData<String> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.responseId = mutableLiveData;
    }

    public final void updateContent(@NotNull GPHContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.clear();
        this.gifTrackingManager.reset();
        this.content = content;
        this.gifsAdapter.setMediaType(content.getMediaType());
        this.loadGifs(NetworkState.Companion.getLOADING_INITIAL());
    }

    private final getPostComparator.1 getPostComparator() {
        return new DiffUtil.ItemCallback<SmartItemData>(){

            public boolean areItemsTheSame(@NotNull SmartItemData oldItem, @NotNull SmartItemData newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                return oldItem.getViewType() == newItem.getViewType() && Intrinsics.areEqual((Object)oldItem.getData(), (Object)newItem.getData());
            }

            @SuppressLint(value={"DiffUtilEquals"})
            public boolean areContentsTheSame(@NotNull SmartItemData oldItem, @NotNull SmartItemData newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                return oldItem.getViewType() == newItem.getViewType() && Intrinsics.areEqual((Object)oldItem.getData(), (Object)newItem.getData());
            }
        };
    }

    @NotNull
    public final SmartGridAdapter getGifsAdapter() {
        return this.gifsAdapter;
    }

    private final void updateGridTypeIfNeeded() {
        Object it;
        boolean requiresUpdate = false;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager != null) {
            it = linearLayoutManager;
            boolean bl = false;
            requiresUpdate = this.orientation != it.getOrientation();
        }
        layoutManager = this.getLayoutManager();
        GridLayoutManager gridLayoutManager = layoutManager instanceof GridLayoutManager ? (GridLayoutManager)layoutManager : null;
        if (gridLayoutManager != null) {
            it = gridLayoutManager;
            boolean bl = false;
            requiresUpdate = this.spanCount != it.getSpanCount();
        }
        layoutManager = this.getLayoutManager();
        WrapStaggeredGridLayoutManager wrapStaggeredGridLayoutManager = layoutManager instanceof WrapStaggeredGridLayoutManager ? (WrapStaggeredGridLayoutManager)layoutManager : null;
        if (wrapStaggeredGridLayoutManager != null) {
            it = wrapStaggeredGridLayoutManager;
            boolean bl = false;
            requiresUpdate = this.orientation != it.getOrientation() || this.spanCount != it.getSpanCount();
        }
        Timber.d((String)("updateGridTypeIfNeeded requiresUpdate=" + requiresUpdate), (Object[])new Object[0]);
        if (requiresUpdate) {
            this.configureRecyclerViewForGridType();
        }
    }

    private final void configureRecyclerViewForGridType() {
        Timber.d((String)"configureRecyclerViewForGridType", (Object[])new Object[0]);
        GPHContentType gPHContentType = this.contentType;
        if ((gPHContentType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[gPHContentType.ordinal()]) == 1) {
            GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), this.spanCount, this.orientation, false);
            gridLayoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.getSpanSizeLookup());
            this.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        } else {
            this.setLayoutManager((RecyclerView.LayoutManager)new WrapStaggeredGridLayoutManager(this.spanCount, this.orientation));
        }
        this.updateItemDecorations();
    }

    private final void updateItemDecorations() {
        while (this.getItemDecorationCount() > 0) {
            this.removeItemDecorationAt(0);
        }
        GPHContentType gPHContentType = this.contentType;
        if ((gPHContentType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[gPHContentType.ordinal()]) == 1) {
            this.addItemDecoration(this.createItemDecorationForGrid(this.spanCount));
        } else {
            this.addItemDecoration(this.createItemDecorationForStaggered());
        }
    }

    private final void loadNextPage(int aroundPosition) {
        Timber.d((String)("loadNextPage aroundPosition=" + aroundPosition), (Object[])new Object[0]);
        this.post(() -> SmartGridRecyclerView.loadNextPage$lambda-4(this));
    }

    private final void loadGifs(NetworkState state) {
        GPHContent gPHContent;
        Timber.d((String)("loadGifs " + (Object)((Object)state.getStatus())), (Object[])new Object[0]);
        this.networkState.setValue((Object)state);
        this.updateNetworkState();
        if (Intrinsics.areEqual((Object)state, (Object)NetworkState.Companion.getLOADING_INITIAL())) {
            this.contentItems.clear();
            Future<?> future = this.runningQuery;
            if (future != null) {
                future.cancel(true);
            }
            this.runningQuery = null;
        }
        Timber.d((String)("loadGifs " + state + " offset=" + this.contentItems.size()), (Object[])new Object[0]);
        this.contentLoading = true;
        GPHContent gPHContent2 = this.content;
        GPHRequestType requestType = gPHContent2 != null ? gPHContent2.getRequestType() : null;
        Future<?> future = this.runningQuery;
        if (future != null) {
            future.cancel(true);
        }
        GPHContent gPHContent3 = this.content;
        this.runningQuery = gPHContent3 != null && (gPHContent = gPHContent3.withApiClient$giphy_ui_2_3_4_release(this.apiClient)) != null ? gPHContent.queryGifs(this.contentItems.size(), (CompletionHandler<? super ListMediaResponse>)new CompletionHandler<ListMediaResponse>(this, state, requestType){
            final /* synthetic */ SmartGridRecyclerView this$0;
            final /* synthetic */ NetworkState $state;
            final /* synthetic */ GPHRequestType $requestType;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                this.$requestType = $requestType;
            }

            /*
             * WARNING - void declaration
             */
            public void onComplete(@Nullable ListMediaResponse result, @Nullable Throwable e) {
                block24: {
                    NetworkState networkState;
                    MutableLiveData<NetworkState> mutableLiveData;
                    Object object;
                    block23: {
                        Object object2;
                        Object it;
                        SmartGridRecyclerView smartGridRecyclerView;
                        Object object3;
                        Object object4;
                        block22: {
                            block21: {
                                if (!(e instanceof ApiException)) break block21;
                                object = new Integer[]{422, 403};
                                Meta meta = ((ApiException)e).getErrorResponse().getMeta();
                                if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])object), (Object)(meta != null ? Integer.valueOf(meta.getStatus()) : null))) break block22;
                            }
                            ListMediaResponse listMediaResponse = result;
                            if ((listMediaResponse != null ? listMediaResponse.getData() : null) == null) break block23;
                        }
                        this.this$0.getNetworkState().setValue((Object)(Intrinsics.areEqual((Object)this.this$0.getNetworkState().getValue(), (Object)NetworkState.Companion.getLOADING_INITIAL()) ? NetworkState.Companion.getLOADED_INITIAL() : NetworkState.Companion.getLOADED()));
                        Timber.d((String)("loadGifs " + this.$state + " newGifCount=" + ((object4 = result) != null && (object4 = ((ListMediaResponse)object4).getData()) != null ? Integer.valueOf(object4.size()) : null)), (Object[])new Object[0]);
                        this.this$0.getFooterItems().clear();
                        Object object5 = result;
                        if (object5 != null && (object5 = ((ListMediaResponse)object5).getData()) != null) {
                            void $this$filterTo$iv$iv;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Object element$iv$iv2;
                            Collection destination$iv$iv;
                            boolean enableDynamicText;
                            object3 = object5;
                            smartGridRecyclerView = this.this$0;
                            it = object3;
                            boolean bl = false;
                            Object mediaList = it;
                            GPHSettings gPHSettings = smartGridRecyclerView.getGifsAdapter().getAdapterHelper().getGphSettings();
                            boolean bl2 = enableDynamicText = gPHSettings != null ? gPHSettings.getEnableDynamicText() : false;
                            if (!enableDynamicText) {
                                void $this$filterTo$iv$iv2;
                                Iterable $this$filter$iv = (Iterable)mediaList;
                                boolean $i$f$filter = false;
                                Iterable iterable = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                                    Media it2 = (Media)element$iv$iv2;
                                    boolean bl3 = false;
                                    if (!(!it2.isDynamic())) continue;
                                    destination$iv$iv.add(element$iv$iv2);
                                }
                                mediaList = (List)destination$iv$iv;
                            }
                            boolean isAllDynamic = SmartGridRecyclerView.access$isAllDynamic(smartGridRecyclerView, (List)mediaList);
                            Iterable $i$f$filter = (Iterable)mediaList;
                            ArrayList<SmartItemData> arrayList = smartGridRecyclerView.getContentItems();
                            boolean $i$f$map = false;
                            destination$iv$iv = $this$map$iv;
                            Object destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (E item$iv$iv : $this$mapTo$iv$iv) {
                                void it3;
                                Media bl3 = (Media)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl4 = false;
                                SmartItemType viewType = null;
                                viewType = isAllDynamic ? SmartItemType.DynamicText : (it3.isDynamic() ? SmartItemType.DynamicTextWithMoreByYou : (MediaExtensionKt.isVideo((Media)it3) ? SmartItemType.Video : SmartItemType.Gif));
                                collection.add(new SmartItemData(viewType, it3, 0, 4, null));
                            }
                            arrayList.addAll((List)destination$iv$iv2);
                            Object object6 = SmartGridRecyclerView.access$getContent$p(smartGridRecyclerView);
                            if (object6 == null || (object6 = ((GPHContent)object6).getSearchQuery()) == null) {
                                object6 = "";
                            }
                            Object searchQuery = object6;
                            SmartItemData smartItemData = (SmartItemData)CollectionsKt.firstOrNull((List)smartGridRecyclerView.getContentItems());
                            destination$iv$iv2 = smartItemData != null ? smartItemData.getData() : null;
                            Media media = destination$iv$iv2 instanceof Media ? (Media)destination$iv$iv2 : null;
                            User user = media != null ? media.getUser() : null;
                            Iterable $this$filter$iv = smartGridRecyclerView.getContentItems();
                            boolean $i$f$filter2 = false;
                            element$iv$iv2 = $this$filter$iv;
                            Collection destination$iv$iv3 = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv3 : $this$filterTo$iv$iv) {
                                SmartItemData it4 = (SmartItemData)element$iv$iv3;
                                boolean bl5 = false;
                                User user2 = user;
                                Object object7 = it4.getData();
                                Object object8 = object7 instanceof Media ? (Media)object7 : null;
                                if (!Intrinsics.areEqual((Object)(object8 != null && (object8 = ((Media)object8).getUser()) != null ? ((User)object8).getUsername() : null), (Object)(user2 != null ? user2.getUsername() : null))) continue;
                                destination$iv$iv3.add(element$iv$iv3);
                            }
                            List filteredByUser = (List)destination$iv$iv3;
                            GPHSettings gPHSettings2 = smartGridRecyclerView.getGifsAdapter().getAdapterHelper().getGphSettings();
                            boolean bl6 = gPHSettings2 != null ? gPHSettings2.getEnablePartnerProfiles() : false;
                            if (bl6) {
                                CharSequence charSequence;
                                Character c = StringsKt.firstOrNull((CharSequence)((CharSequence)searchQuery));
                                char c2 = '@';
                                if (c != null && c.charValue() == c2 && ((CharSequence)searchQuery).length() > 1 && smartGridRecyclerView.getContentItems().size() <= 25 && !((Collection)smartGridRecyclerView.getContentItems()).isEmpty() && user != null && Intrinsics.areEqual((Object)searchQuery, (Object)('@' + user.getUsername())) && ((Collection)filteredByUser).size() == ((Collection)smartGridRecyclerView.getContentItems()).size() && !((charSequence = (CharSequence)user.getDisplayName()) == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)user.getAvatarUrl()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                                    CollectionsKt.removeAll((List)smartGridRecyclerView.getHeaderItems(), (Function1)loadGifs.onComplete.1.3.INSTANCE);
                                    smartGridRecyclerView.getHeaderItems().add(new SmartItemData(SmartItemType.UserProfile, user, smartGridRecyclerView.getSpanCount()));
                                }
                            }
                        }
                        if (Intrinsics.areEqual((Object)this.this$0.getNetworkState().getValue(), (Object)NetworkState.Companion.getLOADED_INITIAL()) && this.this$0.getContentItems().isEmpty()) {
                            String noResultsDescription = null;
                            GPHContent gPHContent = SmartGridRecyclerView.access$getContent$p(this.this$0);
                            MediaType mediaType = gPHContent != null ? gPHContent.getMediaType() : null;
                            switch (mediaType == null ? -1 : loadGifs.WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                                case 1: {
                                    String string2 = this.this$0.getContext().getString(R.string.gph_error_no_stickers_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026_error_no_stickers_found)");
                                    noResultsDescription = string2;
                                    break;
                                }
                                case 2: {
                                    String string3 = this.this$0.getContext().getString(R.string.gph_error_no_texts_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026gph_error_no_texts_found)");
                                    noResultsDescription = string3;
                                    break;
                                }
                                case 3: {
                                    String string4 = this.this$0.getContext().getString(R.string.gph_error_no_clips_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.stri\u2026gph_error_no_clips_found)");
                                    noResultsDescription = string4;
                                    break;
                                }
                                default: {
                                    String string5 = this.this$0.getContext().getString(R.string.gph_error_no_gifs_found);
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.getString(R.stri\u2026.gph_error_no_gifs_found)");
                                    noResultsDescription = string5;
                                }
                            }
                            ArrayList<SmartItemData> arrayList = this.this$0.getFooterItems();
                            Object object9 = e instanceof ApiException ? (ApiException)e : null;
                            if (object9 == null || (object9 = ((ApiException)object9).getErrorResponse()) == null || (object9 = ((ErrorResponse)object9).getMeta()) == null || (object9 = ((Meta)object9).getMsg()) == null) {
                                object9 = noResultsDescription;
                            }
                            arrayList.add(new SmartItemData(SmartItemType.NoResults, object9, this.this$0.getSpanCount()));
                        }
                        if ((object2 = result) != null && (object2 = ((ListMediaResponse)object2).getMeta()) != null) {
                            object3 = object2;
                            smartGridRecyclerView = this.this$0;
                            it = object3;
                            boolean bl = false;
                            smartGridRecyclerView.getResponseId().setValue((Object)((Meta)it).getResponseId());
                        }
                        this.this$0.refreshItems();
                        return;
                    }
                    if (this.$requestType == GPHRequestType.recents) {
                        this.this$0.getFooterItems().clear();
                        this.this$0.getFooterItems().add(new SmartItemData(SmartItemType.NoResults, this.this$0.getContext().getString(R.string.gph_error_no_recent_found), this.this$0.getSpanCount()));
                        this.this$0.refreshItems();
                        return;
                    }
                    Throwable throwable = e;
                    if (throwable == null) break block24;
                    object = throwable;
                    SmartGridRecyclerView smartGridRecyclerView = this.this$0;
                    Object it = object;
                    boolean bl = false;
                    MutableLiveData<NetworkState> mutableLiveData2 = smartGridRecyclerView.getNetworkState();
                    if (Intrinsics.areEqual((Object)smartGridRecyclerView.getNetworkState().getValue(), (Object)NetworkState.Companion.getLOADING_INITIAL())) {
                        void $this$onComplete_u24lambda_u2d7_u24lambda_u2d5;
                        NetworkState networkState2;
                        NetworkState mediaList = networkState2 = NetworkState.Companion.errorInitial(e.getMessage());
                        MutableLiveData<NetworkState> mutableLiveData3 = mutableLiveData2;
                        boolean bl7 = false;
                        $this$onComplete_u24lambda_u2d7_u24lambda_u2d5.setCallableAction((Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)smartGridRecyclerView)){

                            public final void invoke() {
                                ((SmartGridRecyclerView)((Object)this.receiver)).refresh();
                            }
                        }));
                        mutableLiveData = mutableLiveData3;
                        networkState = networkState2;
                    } else {
                        void $this$onComplete_u24lambda_u2d7_u24lambda_u2d6;
                        NetworkState networkState3;
                        NetworkState $this$onComplete_u24lambda_u2d7_u24lambda_u2d5 = networkState3 = NetworkState.Companion.error(e.getMessage());
                        MutableLiveData<NetworkState> mutableLiveData4 = mutableLiveData2;
                        boolean bl8 = false;
                        $this$onComplete_u24lambda_u2d7_u24lambda_u2d6.setCallableAction((Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)smartGridRecyclerView)){

                            public final void invoke() {
                                ((SmartGridRecyclerView)((Object)this.receiver)).refresh();
                            }
                        }));
                        mutableLiveData = mutableLiveData4;
                        networkState = networkState3;
                    }
                    mutableLiveData.setValue((Object)networkState);
                    SmartGridRecyclerView.access$updateNetworkState(smartGridRecyclerView);
                    smartGridRecyclerView.refreshItems();
                }
            }
        }) : null;
    }

    private final boolean isAllDynamic(List<Media> list) {
        int n;
        block2: {
            List<Media> $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Media> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Media item$iv;
                Media it = item$iv = iterator.next();
                boolean bl = false;
                if (!it.isDynamic()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n == -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAllDynamic() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = this.contentItems;
        SmartGridRecyclerView smartGridRecyclerView = this;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Media it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SmartItemData it = (SmartItemData)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getData();
            if ((object instanceof Media ? (Media)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return smartGridRecyclerView.isAllDynamic((List)destination$iv$iv);
    }

    private final void updateNetworkState() {
        Timber.d((String)"updateNetworkState", (Object[])new Object[0]);
        this.footerItems.clear();
        this.footerItems.add(new SmartItemData(SmartItemType.NetworkState, this.networkState.getValue(), this.spanCount));
    }

    public final void refreshItems() {
        Timber.d((String)("refreshItems " + this.headerItems.size() + ' ' + this.contentItems.size() + ' ' + this.footerItems.size()), (Object[])new Object[0]);
        ArrayList items = new ArrayList();
        items.addAll(this.headerItems);
        items.addAll(this.contentItems);
        items.addAll(this.footerItems);
        this.gifsAdapter.submitList(items, () -> SmartGridRecyclerView.refreshItems$lambda-7(this));
    }

    private final getSpanSizeLookup.1 getSpanSizeLookup() {
        return new GridLayoutManager.SpanSizeLookup(this){
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.this$0 = $receiver;
            }

            public int getSpanSize(int position) {
                return this.this$0.getGifsAdapter().getSpanCountForPosition(position);
            }
        };
    }

    private final RecyclerView.ItemDecoration createItemDecorationForGrid(int spanCount) {
        return new RecyclerView.ItemDecoration(spanCount, this){
            final /* synthetic */ int $spanCount;
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.$spanCount = $spanCount;
                this.this$0 = $receiver;
            }

            public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.GridLayoutManager.LayoutParams");
                GridLayoutManager.LayoutParams layoutParams2 = (GridLayoutManager.LayoutParams)layoutParams;
                int itemSpanIndex = layoutParams2.getSpanIndex();
                outRect.set(itemSpanIndex == 0 && this.$spanCount < 3 ? 0 : this.this$0.getCellPadding() / 2, 0, itemSpanIndex == this.$spanCount - 1 && this.$spanCount < 3 ? 0 : this.this$0.getCellPadding() / 2, this.this$0.getCellPadding());
            }
        };
    }

    private final RecyclerView.ItemDecoration createItemDecorationForStaggered() {
        return new RecyclerView.ItemDecoration(this){
            private final int borderSizePx;
            final /* synthetic */ SmartGridRecyclerView this$0;
            {
                this.this$0 = $receiver;
                this.borderSizePx = $receiver.getCellPadding();
            }

            public final int getBorderSizePx() {
                return this.borderSizePx;
            }

            public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
                Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                boolean disableMarginForProfileItem = false;
                RecyclerView.Adapter adapter = parent.getAdapter();
                if (adapter != null) {
                    RecyclerView.Adapter it = adapter;
                    boolean bl = false;
                    int position = parent.getChildAdapterPosition(view);
                    if (it.getItemViewType(position) == SmartItemType.UserProfile.ordinal()) {
                        disableMarginForProfileItem = true;
                    }
                }
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                StaggeredGridLayoutManager.LayoutParams layoutParams2 = (StaggeredGridLayoutManager.LayoutParams)layoutParams;
                int itemSpanIndex = layoutParams2.getSpanIndex();
                outRect.set(itemSpanIndex == 0 && this.this$0.getSpanCount() < 3 || disableMarginForProfileItem ? 0 : this.borderSizePx / 2, 0, itemSpanIndex == this.this$0.getSpanCount() - 1 && this.this$0.getSpanCount() < 3 || disableMarginForProfileItem ? 0 : this.borderSizePx / 2, this.borderSizePx);
            }
        };
    }

    public final void clear() {
        this.contentItems.clear();
        this.headerItems.clear();
        this.footerItems.clear();
        this.gifsAdapter.submitList(null);
    }

    public final void refresh() {
        block0: {
            GPHContent gPHContent = this.content;
            if (gPHContent == null) break block0;
            GPHContent it = gPHContent;
            boolean bl = false;
            this.updateContent(it);
        }
    }

    public final boolean emptyResults() {
        return this.contentItems.isEmpty();
    }

    public void requestLayout() {
        super.requestLayout();
        if (!this.mRequestedLayout) {
            this.mRequestedLayout = true;
            this.post(() -> SmartGridRecyclerView.requestLayout$lambda-9(this));
        }
    }

    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SmartGridRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void loadNextPage$lambda-4(SmartGridRecyclerView this$0) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                if (this$0.contentLoading) break block4;
                GPHContent gPHContent = this$0.content;
                boolean bl = gPHContent != null ? !gPHContent.getHasPagination() : false;
                if (!bl) break block5;
            }
            return;
        }
        if ((Intrinsics.areEqual((Object)this$0.networkState.getValue(), (Object)NetworkState.Companion.getLOADED()) || Intrinsics.areEqual((Object)this$0.networkState.getValue(), (Object)NetworkState.Companion.getLOADED_INITIAL())) && !((Collection)this$0.contentItems).isEmpty()) {
            this$0.loadGifs(NetworkState.Companion.getLOADING());
        }
    }

    private static final void refreshItems$lambda-7(SmartGridRecyclerView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.contentLoading = false;
        int response = this$0.contentItems.size();
        if (this$0.contentItems.isEmpty()) {
            SmartItemData smartItemData = (SmartItemData)CollectionsKt.firstOrNull((List)this$0.footerItems);
            if ((smartItemData != null ? smartItemData.getViewType() : null) == SmartItemType.NetworkState) {
                response = -1;
            }
        }
        this$0.onResultsUpdateListener.invoke((Object)response);
        this$0.gifTrackingManager.updateTracking();
    }

    private static final void requestLayout$lambda-9(SmartGridRecyclerView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.mRequestedLayout = false;
        this$0.layout(this$0.getLeft(), this$0.getTop(), this$0.getRight(), this$0.getBottom());
        this$0.onLayout(false, this$0.getLeft(), this$0.getTop(), this$0.getRight(), this$0.getBottom());
    }

    public static final /* synthetic */ GPHContent access$getContent$p(SmartGridRecyclerView $this) {
        return $this.content;
    }

    public static final /* synthetic */ boolean access$isAllDynamic(SmartGridRecyclerView $this, List list) {
        return $this.isAllDynamic(list);
    }

    public static final /* synthetic */ void access$updateNetworkState(SmartGridRecyclerView $this) {
        $this.updateNetworkState();
    }

    public static final /* synthetic */ void access$loadNextPage(SmartGridRecyclerView $this, int aroundPosition) {
        $this.loadNextPage(aroundPosition);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GPHContentType.values().length];
            nArray[GPHContentType.emoji.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

