/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui;

import android.content.Context;
import android.content.SharedPreferences;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/giphy/sdk/ui/GiphyRecents;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "MAX", "", "RECENT_GIF_IDS", "", "SHARED_PREF_FILE", "count", "getCount", "()I", "ids", "", "getIds$giphy_ui_2_3_4_release", "()Ljava/util/List;", "sharedPreferences", "Landroid/content/SharedPreferences;", "addMedia", "", "media", "Lcom/giphy/sdk/core/models/Media;", "clear", "removeGif", "id", "giphy-ui-2.3.4_release"})
public final class GiphyRecents {
    @NotNull
    private final String SHARED_PREF_FILE;
    @NotNull
    private final String RECENT_GIF_IDS;
    private final int MAX;
    @NotNull
    private final SharedPreferences sharedPreferences;

    public GiphyRecents(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.SHARED_PREF_FILE = "giphy_recents_file";
        this.RECENT_GIF_IDS = "recent_gif_ids";
        this.MAX = 10;
        SharedPreferences sharedPreferences = context.getSharedPreferences(this.SHARED_PREF_FILE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026LE, Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
    }

    @NotNull
    public final List<String> getIds$giphy_ui_2_3_4_release() {
        List list;
        String recentIds;
        String string = this.sharedPreferences.getString(this.RECENT_GIF_IDS, null);
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(recentIds = string)).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            String[] stringArray = new String[]{"|"};
            list = StringsKt.split$default((CharSequence)recentIds, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        return list;
    }

    public final int getCount() {
        return ((Collection)this.getIds$giphy_ui_2_3_4_release()).size();
    }

    public final void clear() {
        this.sharedPreferences.edit().clear().apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeGif(@Nullable String id) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getIds$giphy_ui_2_3_4_release();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)id))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentIds = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.sharedPreferences.edit().putString(this.RECENT_GIF_IDS, CollectionsKt.joinToString$default((Iterable)currentIds, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).apply();
        if (this.getIds$giphy_ui_2_3_4_release().isEmpty()) {
            this.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addMedia(@NotNull Media media) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (media.getType() == MediaType.emoji) {
            return;
        }
        Iterable $this$filter$iv = this.getIds$giphy_ui_2_3_4_release();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)media.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentIds = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        currentIds.add(0, media.getId());
        if (currentIds.size() > this.MAX) {
            currentIds.remove(CollectionsKt.last((List)currentIds));
        }
        this.sharedPreferences.edit().putString(this.RECENT_GIF_IDS, CollectionsKt.joinToString$default((Iterable)currentIds, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).apply();
    }
}

