/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.tracking;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.giphy.sdk.analytics.GiphyPingbacks;
import com.giphy.sdk.analytics.batching.PingbackCollector;
import com.giphy.sdk.analytics.models.Attribute;
import com.giphy.sdk.analytics.models.enums.ActionType;
import com.giphy.sdk.analytics.models.enums.EventType;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.tracking.GifTrackingCallback;
import com.giphy.sdk.tracking.GifTrackingManager;
import com.giphy.sdk.tracking.GifVisibilityListener;
import com.giphy.sdk.tracking.MediaExtensionKt;
import com.giphy.sdk.tracking.PingbacksDeduplicator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\b\b\u0010\u0018\u0000 B2\u00020\u0001:\u0001BB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u0016\u0010-\u001a\u00020+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020+J\u0006\u0010/\u001a\u00020+J\u0006\u00100\u001a\u00020+J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u000e\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020+J\u0018\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020+R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0004R\u000e\u0010&\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010\u0015\u00a8\u0006C"}, d2={"Lcom/giphy/sdk/tracking/GifTrackingManager;", "", "trackPingbacks", "", "(Z)V", "drawingRect", "Landroid/graphics/Rect;", "getRecyclerScrollListener", "com/giphy/sdk/tracking/GifTrackingManager$getRecyclerScrollListener$1", "Lcom/giphy/sdk/tracking/GifTrackingManager$getRecyclerScrollListener$1;", "gifTrackingCallback", "Lcom/giphy/sdk/tracking/GifTrackingCallback;", "gifVisibilityListeners", "", "Lcom/giphy/sdk/tracking/GifVisibilityListener;", "globalRect", "layoutType", "", "getLayoutType", "()Ljava/lang/String;", "setLayoutType", "(Ljava/lang/String;)V", "pingbackCollector", "Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "getPingbackCollector", "()Lcom/giphy/sdk/analytics/batching/PingbackCollector;", "setPingbackCollector", "(Lcom/giphy/sdk/analytics/batching/PingbackCollector;)V", "pingbacksDeduplicator", "Lcom/giphy/sdk/tracking/PingbacksDeduplicator;", "placement", "getPlacement", "setPlacement", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getTrackPingbacks", "()Z", "setTrackPingbacks", "trackSessions", "userId", "getUserId", "setUserId", "addGifVisibilityListener", "", "gifVisibilityListener", "attachToRecyclerView", "detach", "disableTracking", "enableTracking", "getCellVisibility", "", "view", "Landroid/view/View;", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "isMediaLoadedForIndex", "position", "", "removeGifVisibilityListener", "reset", "trackMedia", "media", "Lcom/giphy/sdk/core/models/Media;", "actionType", "Lcom/giphy/sdk/analytics/models/enums/ActionType;", "updateTracking", "Companion", "giphy-ui-2.3.4_release"})
public class GifTrackingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean trackPingbacks;
    @Nullable
    private RecyclerView recyclerView;
    @NotNull
    private final Rect globalRect;
    @NotNull
    private final Rect drawingRect;
    @Nullable
    private GifTrackingCallback gifTrackingCallback;
    @NotNull
    private final List<GifVisibilityListener> gifVisibilityListeners;
    @NotNull
    private PingbacksDeduplicator pingbacksDeduplicator;
    private boolean trackSessions;
    @NotNull
    private PingbackCollector pingbackCollector;
    @NotNull
    private String userId;
    @Nullable
    private String layoutType;
    @Nullable
    private String placement;
    @NotNull
    private final getRecyclerScrollListener.1 getRecyclerScrollListener;
    private static final String TAG = GifTrackingManager.class.getSimpleName();
    @NotNull
    private static String versionString = "n/a";

    public GifTrackingManager(boolean trackPingbacks) {
        this.trackPingbacks = trackPingbacks;
        this.globalRect = new Rect();
        this.drawingRect = new Rect();
        this.gifVisibilityListeners = new ArrayList();
        this.pingbacksDeduplicator = new PingbacksDeduplicator();
        this.trackSessions = true;
        this.pingbackCollector = GiphyPingbacks.INSTANCE.getPingbackCollector$giphy_ui_2_3_4_release();
        this.userId = "";
        this.getRecyclerScrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ GifTrackingManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                this.this$0.updateTracking();
            }
        };
    }

    public /* synthetic */ GifTrackingManager(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getTrackPingbacks() {
        return this.trackPingbacks;
    }

    public final void setTrackPingbacks(boolean bl) {
        this.trackPingbacks = bl;
    }

    @NotNull
    public final PingbackCollector getPingbackCollector() {
        return this.pingbackCollector;
    }

    public final void setPingbackCollector(@NotNull PingbackCollector pingbackCollector) {
        Intrinsics.checkNotNullParameter((Object)pingbackCollector, (String)"<set-?>");
        this.pingbackCollector = pingbackCollector;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userId = string;
    }

    @Nullable
    public final String getLayoutType() {
        return this.layoutType;
    }

    public final void setLayoutType(@Nullable String string) {
        this.layoutType = string;
    }

    @Nullable
    public final String getPlacement() {
        return this.placement;
    }

    public final void setPlacement(@Nullable String string) {
        this.placement = string;
    }

    public final boolean isMediaLoadedForIndex(int position) {
        GifTrackingCallback gifTrackingCallback = this.gifTrackingCallback;
        return gifTrackingCallback != null ? gifTrackingCallback.isMediaLoadedForIndex(position, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((GifTrackingManager)this.receiver).updateTracking();
            }
        })) : false;
    }

    public final void attachToRecyclerView(@NotNull RecyclerView recyclerView, @NotNull GifTrackingCallback gifTrackingCallback) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)gifTrackingCallback, (String)"gifTrackingCallback");
        this.recyclerView = recyclerView;
        this.gifTrackingCallback = gifTrackingCallback;
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.getRecyclerScrollListener);
        this.layoutType = this.getLayoutType(recyclerView.getLayoutManager());
    }

    public final void detach() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.getRecyclerScrollListener);
        }
        this.recyclerView = null;
        this.layoutType = null;
    }

    public final void disableTracking() {
        this.trackSessions = false;
    }

    public final void enableTracking() {
        this.trackSessions = true;
    }

    public final void addGifVisibilityListener(@NotNull GifVisibilityListener gifVisibilityListener) {
        Intrinsics.checkNotNullParameter((Object)gifVisibilityListener, (String)"gifVisibilityListener");
        this.gifVisibilityListeners.add(gifVisibilityListener);
    }

    public final void removeGifVisibilityListener(@NotNull GifVisibilityListener gifVisibilityListener) {
        Intrinsics.checkNotNullParameter((Object)gifVisibilityListener, (String)"gifVisibilityListener");
        this.gifVisibilityListeners.remove(gifVisibilityListener);
    }

    private final String getLayoutType(RecyclerView.LayoutManager layoutManager) {
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        return layoutManager2 instanceof LinearLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_CAROUSEL() : (layoutManager2 instanceof GridLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_GRID() : (layoutManager2 instanceof StaggeredGridLayoutManager ? Attribute.Companion.getLAYOUT_TYPE_GRID() : null));
    }

    public final void updateTracking() {
        block4: {
            if (!this.trackSessions) {
                return;
            }
            Log.d((String)TAG, (String)"updateTracking");
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView == null) break block4;
            RecyclerView recyclerView2 = recyclerView;
            boolean bl = false;
            int n = recyclerView2.getChildCount();
            for (int i = 0; i < n; ++i) {
                Media trackedMedia;
                Media media;
                View view = recyclerView2.getChildAt(i);
                int position = recyclerView2.getChildAdapterPosition(recyclerView2.getChildAt(i));
                if (position == -1 || !this.isMediaLoadedForIndex(position)) continue;
                GifTrackingCallback gifTrackingCallback = this.gifTrackingCallback;
                Media media2 = media = gifTrackingCallback != null ? gifTrackingCallback.mediaForIndex(position) : null;
                if (media == null) continue;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                float visiblePercent = this.getCellVisibility(view);
                if (this.trackPingbacks && visiblePercent == 1.0f) {
                    this.trackMedia(trackedMedia, ActionType.SEEN);
                }
                Iterable $this$forEach$iv = this.gifVisibilityListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GifVisibilityListener visibilityListener = (GifVisibilityListener)element$iv;
                    boolean bl3 = false;
                    visibilityListener.onVisible(position, trackedMedia, view, visiblePercent);
                }
            }
        }
    }

    public void trackMedia(@NotNull Media media, @NotNull ActionType actionType) {
        block6: {
            Object object;
            block5: {
                Intrinsics.checkNotNullParameter((Object)media, (String)"media");
                Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
                object = media.getAnalyticsResponsePayload();
                if (object == null || object.length() == 0) {
                    return;
                }
                if (actionType != ActionType.SEEN) break block5;
                String string = media.getId();
                String string2 = MediaExtensionKt.getResponseId(media);
                if (string2 == null) {
                    string2 = "";
                }
                if (!this.pingbacksDeduplicator.trackNeeded(string, string2)) break block6;
            }
            object = this.pingbackCollector;
            String string = this.userId;
            String string3 = media.getAnalyticsResponsePayload();
            String string4 = media.getId();
            EventType eventType = MediaExtensionKt.getEventType(media);
            String string5 = media.getTid();
            String string6 = this.layoutType;
            Integer n = MediaExtensionKt.getPosition(media);
            int n2 = n != null ? n : -1;
            String string7 = this.placement;
            ((PingbackCollector)object).addPingback(string, string3, null, eventType, string4, string5, actionType, null, string6, n2, string7);
        }
    }

    private final float getCellVisibility(View view) {
        if (!view.getGlobalVisibleRect(this.globalRect)) {
            return 0.0f;
        }
        view.getHitRect(this.drawingRect);
        int visibleViewArea = this.globalRect.width() * this.globalRect.height();
        int totalViewArea = this.drawingRect.width() * this.drawingRect.height();
        float visibility = (float)visibleViewArea / (float)totalViewArea;
        return totalViewArea <= 0 ? 0.0f : Math.min(visibility, 1.0f);
    }

    public final void reset() {
        if (!this.trackSessions) {
            return;
        }
        this.pingbacksDeduplicator.reset();
        Iterable $this$forEach$iv = this.gifVisibilityListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GifVisibilityListener it = (GifVisibilityListener)element$iv;
            boolean bl = false;
            it.reset();
        }
    }

    public GifTrackingManager() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/giphy/sdk/tracking/GifTrackingManager$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "versionString", "getVersionString", "setVersionString", "(Ljava/lang/String;)V", "giphy-ui-2.3.4_release"})
    public static final class Companion {
        private Companion() {
        }

        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final String getVersionString() {
            return versionString;
        }

        public final void setVersionString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            versionString = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

